﻿using Farakonesh.Models.Database.Systems;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Farakonesh.Logic.CommonOperations
{
    public static class ResponseCacheExtensions
    {
        public static ResponseCache Merge(WebserviceMetaData meta, string realApiKey,
            string realPassword)
        {
            if (meta == null)
                throw new ArgumentNullException(nameof(meta));
  
            return new ResponseCache
            {
                ServiceKeysId = meta.ServiceKeysId,
                Title = meta.Title,
                Username = meta.Username,
                BaseUrlService = meta.BaseUrlService,
                AdditionalConfig = meta.AdditionalConfig,
                NumberRequestsPerHour = meta.NumberRequestsPerHour,
                NumberRequestsPerDay = meta.NumberRequestsPerDay,
                NumberRequestsPerMonth = meta.NumberRequestsPerMonth,
                NumberRequests = meta.NumberRequests,
                NumberRequestsMade = meta.NumberRequestsMade,
                SaveDate = meta.SaveDate,
                ExpireDate = meta.ExpireDate,
                LastRequestDate = meta.LastRequestDate,
                ServiceKeyType = meta.ServiceKeyType,
                RealApiKey = realApiKey,
                RealPassword = realPassword
            };
        }
    }
}
