﻿using AngleSharp.Dom;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Logic.Services.Queue;
using Farakonesh.Logic.Services.RestRequest;
using Farakonesh.Models.API.Captcha;
using Farakonesh.Models.API.Mediana;
using Farakonesh.Models.API.RabbitMQ;
using Farakonesh.Models.API.SMS;
using Farakonesh.Models.API.SmsIr;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.keys;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Shared.Helpers;
using Kavenegar;
using MeliPayamakReceive;
using MeliPayamakServices;
using Microsoft.AspNetCore.Hosting.Server;
using Microsoft.AspNetCore.Http;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using NLog.Web.LayoutRenderers;
using RabbitMQ.Client;
using RestSharp;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.ServiceModel.Channels;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.CommonOperations
{
    public class SmsHelper : ISmsHelper
    {
        private readonly ISettingContext _ISettingContext;
        private readonly IQueueContext _IQueueContext;
        private readonly IServiceKeysContext _serviceKeysContext;
        private readonly ILog _logger;
        private readonly IHttpRequestKavenegar _httpRequestKavenegar;
        private readonly IHttpRequestSmsIr _httpRequestSmsIr;
        private readonly ISendSMSQueue _sendSMSQueue;
        private readonly IRedisContextService _redisContextService;
        private readonly IHttpRequestMediana _httpRequestMediana;
        private readonly IHttpContextAccessor _httpContextAccessor;
        public SmsHelper(ISettingContext ISettingContext, IQueueContext iQueueContext, RedisService redis,
            ILog logger, ISendSMSQueue sendSMSQueue, IHttpRequestKavenegar httpRequestKavenegar,
            IRedisContextService redisContextService, IHttpRequestSmsIr httpRequestSmsIr,
            IHttpRequestMediana httpRequestMediana, IHttpContextAccessor httpContextAccessor, IServiceKeysContext serviceKeysContext)
        {
            _httpContextAccessor = httpContextAccessor;
            _httpRequestMediana = httpRequestMediana;
            _httpRequestKavenegar = httpRequestKavenegar;
            _ISettingContext = ISettingContext;
            _IQueueContext = iQueueContext;
            _logger = logger;
            _sendSMSQueue = sendSMSQueue;
            _redisContextService = redisContextService;
            _httpRequestSmsIr = httpRequestSmsIr;
            _serviceKeysContext = serviceKeysContext;
        }

        public async Task<SmsHistoryResponseModel> getSms(string messageId, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Kavenegar, cancellationToken);

            KavenegarApi APi = new KavenegarApi(webServiceInfo.RealApiKey);
            var message = APi.Select(messageId);
            _logger.Information(message.ObjToJson() + "---------Url--------Kavenegar-Get-SMS----------messageId" + messageId, 3);

            return new SmsHistoryResponseModel { message = message.Message, messageId = message.Messageid.ToString(), statusMessage = message.StatusText, status = message.Status.ToString() };
        }
        public async Task<Dictionary<int, string>> sendSMSLockup(SmsRequestSendModel request, CancellationToken cancellationToken)
        {
            if (string.IsNullOrWhiteSpace(request.Mobile) || request.Pattern <= 0)
            {
                return new Dictionary<int, string> { };
            }

            var setting = await _redisContextService.getSettingSmsAsync(cancellationToken);

            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternalServer = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider()
, localIp);
            if (((isExternalServer && setting.IsActiveQueueExternalServer == true)
                || (!isExternalServer && setting.IsActiveQueueInternalServer == true)) && setting.SendSmsFromQueue == true)
            {
                await _sendSMSQueue.sendToQueueTransAction(new SMSSendModel
                {
                    mobile = request.Mobile,
                    text = request.Code,
                    text2 = request.Code2,
                    text3 = request.Code3,
                    text4 = request.Code4,
                    text5 = request.Code5,
                    text6 = request.Code6,
                    pattern = request.Pattern.ToString()
                });
                return new Dictionary<int, string> { { 1, "0" } };
            }

            var settingPattern = await _ISettingContext.Get_SettingPatternSMS_WithoutToken(new Get_SettingPatternSMS_WithoutToken.Inputs
            {
                PatternId = request.Pattern,
            }, cancellationToken);

            request.Template = settingPattern.Data.Template;
            request.Text = settingPattern.Data.Text;
            request.SystemTitle = settingPattern.Data.SystemTitle;

            switch (settingPattern.Data.Key)
            {
                case "kavenegar":
                    request.Type = (int)SmsServiceType.Kavenegar;
                    return await SendSMSLockupKavenegar(request, setting, cancellationToken);
                case "melipayamak":
                    request.Type = (int)SmsServiceType.MeliPayamak;
                    return await SendSMSLockupMeliPayamak(request, setting, cancellationToken);
                case "smsir":
                    request.Type = (int)SmsServiceType.SmsIr;
                    return await SendSMSLockupSmsIr(request, setting, cancellationToken);
                case "mediana":
                    request.Type = (int)SmsServiceType.Mediana;
                    return await SendSMSLockupMediana(request, setting, cancellationToken);
                default:
                    return new Dictionary<int, string> { };
            }

        }
        private async Task<Dictionary<int, string>> SendSMSLockupKavenegar(SmsRequestSendModel request, Get_Setting_SMS.Outputs setting, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Kavenegar, cancellationToken);
            var dbResultSMS = await _IQueueContext.Insert_Sms(new Insert_Sms.Inputs
            {
                Mobile = request.Mobile
                ,
                Pattern = request.Template,
                Text = "",
                Type = request.Type
            }, cancellationToken);
            int res = 0;
            string recId = null;
            string receptor = request.Mobile;

            KavenegarApi APi = new KavenegarApi(webServiceInfo.RealApiKey);
            var result = APi.VerifyLookup(receptor, request.Code, request.Code2, request.Code3, request.Template);
            if (result != null)
            {
                recId = result.Messageid.ToString();
                if (result.Status == 200)
                {
                    res = 1;
                }
                else
                {
                    res = result.Status;
                }
            }
            else
            {
                res = result.Status;
            }

            bool isDone = false;
            if (res > 0 && res < 6)
                isDone = true;
            await _serviceKeysContext.Update_ServiceKeys_ByJob(new Update_ServiceKeys_ByJob.Inputs
            {
                ServiceKeysId = webServiceInfo.ServiceKeysId
            }, cancellationToken);
            await _IQueueContext.Update_Sms(new Update_Sms.Inputs
            {
                IsDone = isDone,
                Status = res,
                RecId = recId
                ,
                SmsId = Guid.Parse(dbResultSMS.Data.getValue("SmsId").ToString())
            }, cancellationToken);

            return new Dictionary<int, string> { { res, recId } };

        }

        private async Task<Dictionary<int, string>> SendSMSLockupMeliPayamak(SmsRequestSendModel request, Get_Setting_SMS.Outputs setting, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.MeliPayamak, cancellationToken);
            var dbResultSMS = await _IQueueContext.Insert_Sms(new Insert_Sms.Inputs
            {
                Mobile = request.Mobile
                ,
                Pattern = request.Template,
                Text = "",
                Type = request.Type
            }, cancellationToken);

            int res = 0;

            string recId = null;

            var isDone = false;

            string receptor = request.Mobile;

            SendSoapClient soapClient = new SendSoapClient(SendSoapClient.EndpointConfiguration.SendSoap);

            request.Code = findSplitShortLinkMeliPayamak(request.Code);
            request.Code2 = findSplitShortLinkMeliPayamak(request.Code2);
            request.Code3 = findSplitShortLinkMeliPayamak(request.Code3);

            List<string> text = new List<string>() { request.Code, request.Code2, request.Code3 };
            recId = await soapClient.SendByBaseNumberAsync(webServiceInfo.Username,
                webServiceInfo.RealPassword, text.ToArray(), request.Mobile, Convert.ToInt32(request.Template));

            if (recId != null && recId.Length > 15)
                isDone = true;

            await _serviceKeysContext.Update_ServiceKeys_ByJob(new Update_ServiceKeys_ByJob.Inputs
            {
                ServiceKeysId = webServiceInfo.ServiceKeysId
            }, cancellationToken);

            await _IQueueContext.Update_Sms(new Update_Sms.Inputs
            {
                IsDone = isDone,
                Status = res,
                RecId = recId,
                SmsId = Guid.Parse(dbResultSMS.Data.getValue("SmsId").ToString())
            }, cancellationToken);

            return new Dictionary<int, string> { { res, recId } };

        }

        private async Task<Dictionary<int, string>> SendSMSLockupSmsIr(SmsRequestSendModel request, Get_Setting_SMS.Outputs setting, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.SmsIr, cancellationToken);
            var dbResultSMS = await _IQueueContext.Insert_Sms(new Insert_Sms.Inputs
            {
                Mobile = request.Mobile
                ,
                Pattern = request.Template,
                Text = "",
                Type = request.Type
            }, cancellationToken);

            int res = 0;

            string recId = null;

            var isDone = false;

            string receptor = request.Mobile;


            request.Code = findSplitShortLinkMeliPayamak(request.Code);
            request.Code2 = findSplitShortLinkMeliPayamak(request.Code2);
            request.Code3 = findSplitShortLinkMeliPayamak(request.Code3);
            var parameters = new List<RequestSmsIrParameters>();
            if (!string.IsNullOrWhiteSpace(request.Code))
            {
                parameters.Add(new RequestSmsIrParameters { name = "OTP", value = request.Code });
            }
            if (!string.IsNullOrWhiteSpace(request.Code2))
            {
                parameters.Add(new RequestSmsIrParameters { name = "OTP2", value = request.Code2 });
            }
            if (!string.IsNullOrWhiteSpace(request.Code3))
            {
                parameters.Add(new RequestSmsIrParameters { name = "OTP3", value = request.Code3 });
            }

            var responseSmsIr = await _httpRequestSmsIr.SendSms(new RequestSmsIr
            {
                mobile = request.Mobile,
                parameters = parameters,
                templateId = request.Template,
                ApiKey = webServiceInfo.RealApiKey,
                BaseUrl = webServiceInfo.BaseUrlService
            }, cancellationToken);

            if (responseSmsIr.status == 1)
            {
                isDone = true;
                recId = responseSmsIr.data.messageId.ToString();
            }
            await _serviceKeysContext.Update_ServiceKeys_ByJob(new Update_ServiceKeys_ByJob.Inputs
            {
                ServiceKeysId = webServiceInfo.ServiceKeysId
            }, cancellationToken);
            await _IQueueContext.Update_Sms(new Update_Sms.Inputs
            {
                IsDone = isDone,
                Status = res,
                RecId = recId,
                SmsId = Guid.Parse(dbResultSMS.Data.getValue("SmsId").ToString())
            }, cancellationToken);

            return new Dictionary<int, string> { { res, recId } };

        }

        private async Task<Dictionary<int, string>> SendSMSLockupMediana(SmsRequestSendModel request, Get_Setting_SMS.Outputs setting, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Mediana, cancellationToken);
            if (webServiceInfo.NumberRequests != null && webServiceInfo.NumberRequests > 0 && webServiceInfo.NumberRequests <= webServiceInfo.NumberRequestsMade)
            {
                throw new Exception("موجودی پنل پیامکی به اتمام رسیده است");
            }
            var dbResultSMS = await _IQueueContext.Insert_Sms(new Insert_Sms.Inputs
            {
                Mobile = request.Mobile
                ,
                Pattern = request.Template,
                Text = request.Text,
                Type = request.Type
            }, cancellationToken);

            int res = 0;

            string recId = null;

            var isDone = false;

            string receptor = request.Mobile;

            request.Text = request.Text.Replace("enter", Environment.NewLine);
            if (!string.IsNullOrWhiteSpace(request.Code))
            {
                request.Text = request.Text.Replace("value", request.Code);
            }
            if (!string.IsNullOrWhiteSpace(request.Code2))
            {
                request.Text = request.Text.Replace("value2", request.Code2);
            }
            if (!string.IsNullOrWhiteSpace(request.Code3))
            {
                request.Text = request.Text.Replace("value3", request.Code3);
            }
            if (!string.IsNullOrWhiteSpace(request.Code4))
            {
                request.Text = request.Text.Replace("value4", request.Code4);
            }
            if (!string.IsNullOrWhiteSpace(request.Code5))
            {
                request.Text = request.Text.Replace("value5", request.Code5);
            }
            if (!string.IsNullOrWhiteSpace(request.Code6))
            {
                request.Text = request.Text.Replace("value6", request.Code6);
            }
            if (!string.IsNullOrWhiteSpace(request.Code7))
            {
                request.Text = request.Text.Replace("value7", request.Code7);
            }
            if (!string.IsNullOrWhiteSpace(request.Code8))
            {
                request.Text = request.Text.Replace("value8", request.Code8);
            }
            if (!string.IsNullOrWhiteSpace(request.Code9))
            {
                request.Text = request.Text.Replace("value9", request.Code9);
            }
            var config = webServiceInfo.AdditionalConfig.JsonParse();
            var response = await _httpRequestMediana.SendSms(new RequestMedianaSendSms
            {
                Text = request.Text,
                Mobile = request.Mobile,
                SystemTitle = request.SystemTitle,
                ApiKey = webServiceInfo.RealApiKey,
                BaseUrl = webServiceInfo.BaseUrlService,
                Sender = (string)config["sender"]
            }, cancellationToken);

            if (response.succeeded == true && response.data.Count > 0)
            {
                isDone = true;
                recId = response.data.FirstOrDefault();
            }
            await _serviceKeysContext.Update_ServiceKeys_ByJob(new Update_ServiceKeys_ByJob.Inputs
            {
                ServiceKeysId = webServiceInfo.ServiceKeysId
            }, cancellationToken);
            await _IQueueContext.Update_Sms(new Update_Sms.Inputs
            {
                IsDone = isDone,
                Status = res,
                RecId = recId,
                SmsId = Guid.Parse(dbResultSMS.Data.getValue("SmsId").ToString())
            }, cancellationToken);

            return new Dictionary<int, string> { { res, recId } };

        }


        public async Task sendSMSGroups(List<string> mobile, string message, CancellationToken cancellationToken)
        {

            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.Kavenegar,cancellationToken);
            var config = setting.AdditionalConfig.JsonParse();
            var api = new KavenegarApi(setting.RealApiKey);
            api.Send((string)config["sender"], mobile, message);

        }
        public async Task<object> getAccountInfoKavenegar(CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.Kavenegar, cancellationToken);

            KavenegarApi api = new KavenegarApi(setting.RealApiKey);
            return api.AccountInfo();

        }
        public async Task<string> getAccountInfoKavenegarAlarm(CancellationToken cancellationToken)
        {

            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.Kavenegar, cancellationToken);

            KavenegarApi api = new KavenegarApi(setting.RealApiKey);
            var response = await _httpRequestKavenegar.accountInfo(cancellationToken);
            if (response == null || response.@return == null)
            {
                return "error-" + "اخطار: ارتباط با سرویس پیامکی کاوه نگار برقرار نشد ، لطفا بررسی کنید تا مشکلی بوجود نیاید";
            }
            if (response.@return.status != 200)
            {
                return "error-" + $"اخطار: ارتباط با سرویس پیامکی کاوه نگار برقرار نشد ، متن خطا: {response.@return.message}";
            }
            if (response.entries.GregorianExpiredate < DateTimeHelper.GetLocalTime())
            {
                return "error-" + "اخطار: سرویس پنل پیامکی کاوه نگار منقضی شده است";
            }
            if (response.entries.GregorianExpiredate < DateTimeHelper.GetLocalTime(add: TimeSpan.FromDays(30)))
            {
                return "error-" + $"اخطار: سرویس پنل پیامکی کاوه نگار ، {(DateTimeHelper.GetLocalTime(add: TimeSpan.FromDays(30)) - response.entries.GregorianExpiredate.Date).Days} روز دیگر منقضی می شود";
            }
            if (response.entries.RemainCredit < 3000000)
            {
                return "error-" + $"اخطار: شارژ سرویس پنل پیامکی کاوه نگار ، کمتر از 300 هزار تومان می باشد و بزودی به اتمام خواهد رسید";
            }
            return "success-" + "وضعیت سرویس پیامکی کاوه نگار پایدار می باشد";
        }

        public async Task<object> getAccountInfoMeliPayamak(CancellationToken cancellationToken)
        {

            var setting = await _redisContextService.GetWebserviceAsync(WebServiceType.MeliPayamak, cancellationToken);

            SendSoapClient soapClient = new SendSoapClient(SendSoapClient.EndpointConfiguration.SendSoap);
            var response = await soapClient.GetCreditAsync(setting.Username, setting.RealPassword);
            return response;
        }





        public async Task<SmsHistoryResponseModel> getSmsMeliPayamak(string messageId, Get_Setting_SMS.Outputs model, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.MeliPayamak,cancellationToken);
            ReceiveSoapClient soapClient = new ReceiveSoapClient(ReceiveSoapClient.EndpointConfiguration.ReceiveSoap);

            var response = await soapClient.GetMessagesReceptionsAsync(webServiceInfo.Username, webServiceInfo.RealPassword
                , Convert.ToInt32(messageId), 0);

            _logger.Information(response.ObjToJson() + "---------Url--------MeliPayamak-Get-SMS----------messageId" + messageId, 3);

            var responseSingle = response.FirstOrDefault();
            return new SmsHistoryResponseModel
            {
                message = responseSingle.DeliveryStatus
                ,
                status = responseSingle.RecStatus,
                messageId = responseSingle.RecID,
                statusMessage = responseSingle.DeliveryStatus
            };
        }


        private string findSplitShortLinkMeliPayamak(string code)
        {
            if (!string.IsNullOrWhiteSpace(code) && code.Contains("https://"))
            {
                var arraryFind = code.Replace("https://", "").Replace("http://", "").Split('/');
                return arraryFind[1] + "/" + arraryFind[2];
            }
            return code;
        }

    }
}
