﻿using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.Email;
using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.API.Telegram;
using Farakonesh.Logic.Services.Queue;
using Farakonesh.Models.API.RabbitMQ;
using Farakonesh.Logic.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Http;

namespace Farakonesh.Logic.CommonOperations
{
    public class TelegramHelper : ITelegramHelper
    {
        private readonly IQueueContext _IQueueContext;
        private readonly IHttpRequestTelegram _httpRequestTelegram;
        private readonly ISendTelegramQueue _sendTelegramQueue;
        private readonly IRedisContextService _redisContextService;
        private readonly IHttpContextAccessor _httpContextAccessor;
        public TelegramHelper(IQueueContext iQueueContext,
            IHttpRequestTelegram httpRequestTelegram, ISendTelegramQueue sendTelegramQueue
            , IRedisContextService redisContextService, IHttpContextAccessor httpContextAccessor)
        {

            _IQueueContext = iQueueContext;
            _httpRequestTelegram = httpRequestTelegram;
            _sendTelegramQueue = sendTelegramQueue;
            _redisContextService = redisContextService;
            _httpContextAccessor = httpContextAccessor;
        }
        public async Task<string> SendMessageToBot(RequestSendMessageToBotTelegramModel model, CancellationToken cancellationToken)
        {
            if (string.IsNullOrWhiteSpace(model.Channel) || string.IsNullOrWhiteSpace(model.Message))
            {
                return string.Empty;
            }
            var setting = await _redisContextService.GetSettingTelegramAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.TelegramBotApi
                ,cancellationToken);
            model.Message = model.Message.Trim();
            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternalServer = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider()
, localIp);
            if (((isExternalServer && setting.IsActiveQueueExternalServer == true)
                || (!isExternalServer && setting.IsActiveQueueInternalServer == true)) && setting.SendTelegramFromQueue == true)
            {
                await _sendTelegramQueue.sendToQueueTransActionWithHostName(new TelegramBotModel
                {
                    chatId = model.Channel,
                    message = model.Message,
                    parseMode = model.ParseMode
                });
                return string.Empty;
            }
            var responseQueue = await _IQueueContext.Insert_Messengers(new Insert_Messengers.Inputs
            {
                Address = model.Channel,
                MessengerType = (int)MessengerType.Telegram,
                Text = model.Message,
            }, cancellationToken);
            var response = await _httpRequestTelegram.sendMessageToBot(new RequestSendMessageToBotTelegramModel
            {
                Message = model.Message,
                BaseUrl = webServiceInfo.BaseUrlService,
                Channel = model.Channel,
                KeyAccess = setting.JobToken,
                Token = webServiceInfo.RealApiKey,
                ParseMode = model.ParseMode
            }, cancellationToken);
            if (responseQueue != null && response != null && ((response.data != null && response.data.result != null) ||
    (!string.IsNullOrWhiteSpace(response.message))))
            {
                await _IQueueContext.Update_Messengers(new Update_Messengers.Inputs
                {
                    IsDone = response.data != null && response.data.result != null ? true : false,
                    MessageId = response.data != null && response.data.result != null ? response.data.result.message_id.ToString() : response.message,
                    MessengerId = responseQueue.Data.MessengerId
                }, cancellationToken);
            }
            return string.Empty;

        }
    }
}
