﻿using Kavenegar.Exceptions;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Logic.IQueue;
using Farakonesh.Models.API.RabbitMQ;
using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Http;
using Farakonesh.Shared.Enums;

namespace Farakonesh.Logic.CommonOperations
{
    public class TtsHelper : ITtsHelper
    {
        private readonly IQueueContext _IQueueContext;
        private readonly IConfiguration _configuration;
        private readonly IRedisContextService _redisContextService;
        private readonly ISendTTsQueue _sendTTsQueue;
        private readonly IHttpContextAccessor _httpContextAccessor;
        public TtsHelper(IQueueContext IQueueContext, ISettingContext ISettingContext,
            IConfiguration configuration, RedisService redis, IRedisContextService redisContextService,
            ISendTTsQueue sendTTsQueue, IHttpContextAccessor httpContextAccessor)
        {
            _IQueueContext = IQueueContext;
            _configuration = configuration;
            _redisContextService = redisContextService;
            _sendTTsQueue = sendTTsQueue;
            _httpContextAccessor = httpContextAccessor;
        }

        /// <summary>
        /// ارسال تماس صوتی - کاوه نگار
        /// </summary>
        /// <param name="mobile"></param>
        /// <param name="code"></param>
        /// <param name="redis"></param>
        /// <returns></returns>
        public async Task<int> callTTS(string mobile, string code, bool sendCodeLanlineNumber, CancellationToken cancellationToken)
        {
            if (string.IsNullOrWhiteSpace(mobile))
            {
                return -1;
            }
            var spacedCode = string.Join(" - - ", code.ToCharArray());
            var message = $"کُدِ یکْبارْ مَصْرَفِ شُما {spacedCode} ... تِکرار می‌کنم ... {spacedCode}";
            var setting = await _redisContextService.getSettingSmsAsync(cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Kavenegar, cancellationToken);
            if (sendCodeLanlineNumber)
            {
                mobile.IsValidIranianLandline(setting.ValidAreaCodes);
            }
            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternalServer = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider()
, localIp);
            if (((isExternalServer && setting.IsActiveQueueExternalServer == true)
                || (!isExternalServer && setting.IsActiveQueueInternalServer == true)) && setting.SendTTSFromQueue == true)
            {
                await _sendTTsQueue.sendToQueueTransAction(new SMSSendModel
                {
                    mobile = mobile,
                    pattern = "tts",
                    text = message
                });
                return 1;
            }
            var dbResultSMS = await _IQueueContext.Insert_Sms(new Insert_Sms.Inputs { Mobile = mobile, Pattern = "", Text = "", Type = null }, cancellationToken);
            var api = new Kavenegar.KavenegarApi(webServiceInfo.RealApiKey);
            int res = 0;
            var receptors = new List<string> { mobile };



            var results = api.CallMakeTTS(message, receptors);
            if (results != null)
            {
                if (results[0].Status == 200)
                {
                    res = 1;
                }
                else
                {
                    res = results[0].Status;
                }
            }
            else
            {
                res = -1;
            }

            bool isDone = false;

            if (res > 0 && res < 6)
                isDone = true;

            await _IQueueContext.Update_Sms(new Update_Sms.Inputs { IsDone = isDone, Status = res, RecId = null, SmsId = Guid.Parse(dbResultSMS.Data.getValue("SmsId").ToString()) }, cancellationToken);


            return res;
        }
    }
}
