﻿using Farakonesh.Shared.Exceptions;
using System;
using System.Collections.Generic;
using System.Text;

namespace Farakonesh.Logic.CommonOperations
{
    public static class ValidatorHelper
    {
        public static void ValidatePaymentAmount(this decimal amount, decimal maxAmount, decimal minAmount)
        {
            if (amount > maxAmount)
                throw new LogicalException($"حداکثر مبلغ قابل پرداخت {maxAmount} تومان است.");
            if (amount < minAmount)
                throw new LogicalException($"حداقل مبلغ قابل پرداخت {minAmount} تومان است.");
        }


        public static decimal? ValidatePaymentAmountMultiPayment(this decimal amount, decimal maxAmount
            , decimal minAmount, decimal? paidAmount, bool? isActiveOnlinePaySingle, bool? isActiveOnlinePayMultiple)
        {
            if (amount < minAmount)
            {
                throw new LogicalException($"حداقل مبلغ جهت پرداخت آنلاین {minAmount} تومان می باشد ، لطفا از روش دیگری جهت پرداخت اقدام نمایید.");
            }
            if (amount > maxAmount)
            {
                if (isActiveOnlinePayMultiple != true)
                {
                    throw new LogicalException("روش پرداخت چند مرحله ای درگاه آنلاین غیر فعال می باشد ، لطفا روش پرداخت دیگری را انتخاب کنید");
                }

                if (paidAmount != null && paidAmount > 0)
                {
                    amount = amount - Convert.ToInt64(paidAmount);

                    if (amount <= 0)
                        throw new InternalServiceException("این سفارش بطور کامل پرداخت شده است ، در صورت بروز هرگونه مشکل از طریق تیکت با کارشناسان ما در ارتباط باشید.");
                    if (amount > maxAmount && (amount - maxAmount) >= minAmount)
                        amount = Convert.ToInt64(maxAmount);
                }
                else
                {
                    if (amount - maxAmount >= minAmount)
                        amount = Convert.ToInt64(maxAmount);
                }


            }
            else
            {
                if (isActiveOnlinePaySingle != true)
                {
                    throw new LogicalException("روش پرداخت درگاه آنلاین غیر فعال می باشد ، لطفا روش پرداخت دیگری را انتخاب کنید");
                }
            }
            return amount;
        }
    }
}
