﻿using Farakonesh.Commands.Services.HttpRequest;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.IServices.IRestRequest;
using Farakonesh.Models.API.Telegram;
using Farakonesh.Models.API.Whatsapp;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Farakonesh.Models.Database.Systems;
using Farakonesh.Shared.Enums;
using Farakonesh.Shared.Helpers;
using Microsoft.AspNetCore.Http;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.CommonOperations
{
    public class WhatsappHelper : IWhatsappHelper
    {
        private readonly IQueueContext _IQueueContext;
        private readonly IHttpRequestWhatsapp _httpRequestWhatsapp;
        private readonly ISendWhatsappQueue _sendWhatsappQueue;
        private readonly IRedisContextService _redisContextService;
        private readonly IHttpContextAccessor _httpContextAccessor;
        public WhatsappHelper(IQueueContext iQueueContext,
            IHttpRequestWhatsapp httpRequestWhatsapp, ISendWhatsappQueue sendWhatsappQueue
            , IRedisContextService redisContextService, IHttpContextAccessor httpContextAccessor)
        {
            _httpContextAccessor = httpContextAccessor;
            _IQueueContext = iQueueContext;
            _httpRequestWhatsapp = httpRequestWhatsapp;
            _sendWhatsappQueue = sendWhatsappQueue;
            _redisContextService = redisContextService;
        }
        public async Task<DBResult<GetMessagesWhatsappResonseModel>> GetMeWhatsappMessages(GetMeWhatsappMessagesCommand command, CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.WhatsAppAutoChat,cancellationToken);
            var response = await _httpRequestWhatsapp.GetMessagesAutochat(new GetMessagesWhatsappRequestModel
            {
                ApiKey = webServiceInfo.RealApiKey,
                BaseUrl = webServiceInfo.BaseUrlService,
                Status = command.Status,
                Per_page = command.PageSize,
                Page = command.StartIndex
            }, cancellationToken);
            return new DBResult<GetMessagesWhatsappResonseModel> { Data = response.data };
        }
        public async Task<DBResult<GetMeWhatsappResonseModel>> GetMeWhatsapp(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.WhatsAppAutoChat, cancellationToken);
            var response = await _httpRequestWhatsapp.GetMeAutochat(new BaseWhatsappRequestModel
            {
                ApiKey = webServiceInfo.RealApiKey,
                BaseUrl = webServiceInfo.BaseUrlService
            }, cancellationToken);
            return new DBResult<GetMeWhatsappResonseModel> { Data = response.data };
        }
        public async Task<DBResult<GetStatusWhatsappResonseModel>> GetStatusWhatsapp(CancellationToken cancellationToken)
        {
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.WhatsAppAutoChat, cancellationToken);
            var response = await _httpRequestWhatsapp.GetStatusAutochat(new BaseWhatsappRequestModel
            {
                ApiKey = webServiceInfo.RealApiKey,
                BaseUrl = webServiceInfo.BaseUrlService
            }, cancellationToken);
            return new DBResult<GetStatusWhatsappResonseModel> { Data = response.data };
        }
        public async Task<string> SendMessage(SendMessageWhatsappRequestModel model,
            ResponseCache webServiceInfo, CancellationToken cancellationToken)
        {
            var setting = await _redisContextService.GetSettingBasicSystemAsync(cancellationToken);
            if (string.IsNullOrWhiteSpace(model.Receivers) || string.IsNullOrWhiteSpace(model.Message))
            {
                return string.Empty;
            }
            if (webServiceInfo == null)
            {
                webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.WhatsAppAutoChat, cancellationToken);
            }
            
            model.Message = model.Message.Trim();
            var localIp = _httpContextAccessor.HttpContext?.Connection.LocalIpAddress;
            var isExternalServer = await IpCheckHelper.IsExternalServerAsync(setting.ExternalServerIp, new IpifyPublicIpProvider()
, localIp);
            if (((isExternalServer && setting.IsActiveQueueExternalServer == true)
                || (!isExternalServer && setting.IsActiveQueueInternalServer == true)) && setting.SendWhatsappFromQueue == true)
            {
                await _sendWhatsappQueue.sendToQueueTransAction(model);
                return string.Empty;
            }
            var responseQueue = await _IQueueContext.Insert_Messengers(new Insert_Messengers.Inputs
            {
                Address = model.Receivers,
                MessengerType = (int)MessengerType.Whatsapp,
                Text = model.Message,
            }, cancellationToken);
            var response = await _httpRequestWhatsapp.SendMessageAutochat(new SendMessageWhatsappRequestModel
            {
                Message = model.Message + Environment.NewLine + Environment.NewLine + Environment.NewLine + DateTime.Now,
                Receivers = model.Receivers,
                ApiKey = webServiceInfo.RealApiKey,
                BaseUrl = webServiceInfo.BaseUrlService
            }, cancellationToken);
            if (responseQueue != null && response != null)
            {
                await _IQueueContext.Update_Messengers(new Update_Messengers.Inputs
                {
                    IsDone = string.IsNullOrWhiteSpace(response.error) ? true : false,
                    MessageId = response.data.id.ToString(),
                    MessengerId = responseQueue.Data.MessengerId
                }, cancellationToken);
            }
            return string.Empty;

        }
    }
}
