﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Models.Database.StoredProcedures.App.Crm;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Currency;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;

namespace Farakonesh.Logic.Database.BlockChain
{
    public class CurrencyBlockChainContext: ICurrencyBlockChainContext
    {
        #region properties
        private string _connectionString { get; set; }
        #endregion properties

        #region SP_CallHistory
        private readonly DP.DapperORM.BaseSP<Get_Currency.Inputs, Get_Currency.Outputs> _Get_Currency;
        private readonly DP.DapperORM.BaseSP<Get_CurrencyByCustomer.Inputs, Get_CurrencyByCustomer.Outputs> _Get_CurrencyByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_Currency.Inputs, Insert_Currency.Outputs> _Insert_Currency;
        private readonly DP.DapperORM.BaseSP<Delete_Currency.Inputs, Delete_Currency.Outputs> _Delete_Currency;
        private readonly DP.DapperORM.BaseSP<Update_Currency.Inputs, Update_Currency.Outputs> _Update_Currency;
        private readonly DP.DapperORM.BaseSP<Insert_CurrencyAmount.Inputs, Insert_CurrencyAmount.Outputs> _Insert_CurrencyAmount;
        private readonly DP.DapperORM.BaseSP<Get_CurrencyAmount.Inputs, Get_CurrencyAmount.Outputs> _Get_CurrencyAmount;
        private readonly DP.DapperORM.BaseSP<Get_CurrencyPriceByOrder.Inputs, Get_CurrencyPriceByOrder.Outputs> _Get_CurrencyPriceByOrder;
        #endregion SP_CallHistory

        public CurrencyBlockChainContext(IConfiguration configuration)
        {

            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Get_Currency = new DP.DapperORM.BaseSP<Get_Currency.Inputs, Get_Currency.Outputs>("BlockChain.Get_Currency", executer);
            _Get_CurrencyByCustomer = new DP.DapperORM.BaseSP<Get_CurrencyByCustomer.Inputs, Get_CurrencyByCustomer.Outputs>("BlockChain.Get_CurrencyByCustomer", executer);
            _Insert_Currency = new DP.DapperORM.BaseSP<Insert_Currency.Inputs, Insert_Currency.Outputs>("BlockChain.Insert_Currency", executer);
            _Delete_Currency = new DP.DapperORM.BaseSP<Delete_Currency.Inputs, Delete_Currency.Outputs>("BlockChain.Delete_Currency", executer);
            _Update_Currency = new DP.DapperORM.BaseSP<Update_Currency.Inputs, Update_Currency.Outputs>("BlockChain.Update_Currency", executer);
            _Insert_CurrencyAmount = new DP.DapperORM.BaseSP<Insert_CurrencyAmount.Inputs, Insert_CurrencyAmount.Outputs>("BlockChain.Insert_CurrencyAmount", executer);
            _Get_CurrencyAmount = new DP.DapperORM.BaseSP<Get_CurrencyAmount.Inputs, Get_CurrencyAmount.Outputs>("BlockChain.Get_CurrencyAmount", executer);
            _Get_CurrencyPriceByOrder = new DP.DapperORM.BaseSP<Get_CurrencyPriceByOrder.Inputs, Get_CurrencyPriceByOrder.Outputs>("BlockChain.Get_CurrencyPriceByOrder", executer);
        }

        public async Task<DBResult<Get_CurrencyPriceByOrder.Outputs>> Get_CurrencyPriceByOrder(Get_CurrencyPriceByOrder.Inputs inputs, CancellationToken cancellationToken) { return await _Get_CurrencyPriceByOrder.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Currency.Outputs>>> Get_Currency(Get_Currency.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Currency.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_CurrencyByCustomer.Outputs>>> Get_CurrencyByCustomer(Get_CurrencyByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Get_CurrencyByCustomer.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_CurrencyAmount.Outputs>>> Get_CurrencyAmount(Get_CurrencyAmount.Inputs inputs, CancellationToken cancellationToken) { return await _Get_CurrencyAmount.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyAmount(Insert_CurrencyAmount.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyAmount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Currency(Insert_Currency.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Currency.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Currency(Update_Currency.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Currency.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Currency(Delete_Currency.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Currency.Execute(inputs, cancellationToken); }

    }
}
