﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Network;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.HistoryDeposit;

namespace Farakonesh.Logic.Database.BlockChain
{
    public class HistoryDepositBlockChainContext: IHistoryDepositBlockChainContext
    {
        #region properties
        private string _connectionString { get; set; }
        #endregion properties

        #region SP_Network
        private readonly DP.DapperORM.BaseSP<Get_HistoryDeposit.Inputs, Get_HistoryDeposit.Outputs> _Get_HistoryDeposit;
        private readonly DP.DapperORM.BaseSP<Get_PaymentHistoryDeposit.Inputs, Get_PaymentHistoryDeposit.Outputs> _Get_PaymentHistoryDeposit;
        private readonly DP.DapperORM.BaseSP<Update_HistoryDeposit_HashIdByPaymentId.Inputs, Update_HistoryDeposit_HashIdByPaymentId.Outputs> _Update_HistoryDeposit_HashIdByPaymentId;
        private readonly DP.DapperORM.BaseSP<Get_HistoryDepositByPayment.Inputs, Get_HistoryDepositByPayment.Outputs> _Get_HistoryDepositByPayment;
        #endregion SP_Network

        public HistoryDepositBlockChainContext(IConfiguration configuration)
        {

            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Get_HistoryDeposit = new DP.DapperORM.BaseSP<Get_HistoryDeposit.Inputs, Get_HistoryDeposit.Outputs>("BlockChain.Get_HistoryDeposit", executer);
            _Get_PaymentHistoryDeposit = new DP.DapperORM.BaseSP<Get_PaymentHistoryDeposit.Inputs, Get_PaymentHistoryDeposit.Outputs>("BlockChain.Get_PaymentHistoryDeposit", executer);
            _Update_HistoryDeposit_HashIdByPaymentId = new DP.DapperORM.BaseSP<Update_HistoryDeposit_HashIdByPaymentId.Inputs, Update_HistoryDeposit_HashIdByPaymentId.Outputs>("BlockChain.Update_HistoryDeposit_HashIdByPaymentId", executer);
            _Get_HistoryDepositByPayment = new DP.DapperORM.BaseSP<Get_HistoryDepositByPayment.Inputs, Get_HistoryDepositByPayment.Outputs>("BlockChain.Get_HistoryDepositByPayment", executer);
        }

        public async Task<DBResult<IEnumerable<Get_HistoryDeposit.Outputs>>> Get_HistoryDeposit(Get_HistoryDeposit.Inputs inputs, CancellationToken cancellationToken) { return await _Get_HistoryDeposit.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<Get_PaymentHistoryDeposit.Outputs>> Get_PaymentHistoryDeposit(Get_PaymentHistoryDeposit.Inputs inputs, CancellationToken cancellationToken) { return await _Get_PaymentHistoryDeposit.Single(inputs, cancellationToken); }
        public async Task<DBResult> Update_HistoryDeposit_HashIdByPaymentId(Update_HistoryDeposit_HashIdByPaymentId.Inputs inputs, CancellationToken cancellationToken) { return await _Update_HistoryDeposit_HashIdByPaymentId.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Get_HistoryDepositByPayment.Outputs>> Get_HistoryDepositByPayment(Get_HistoryDepositByPayment.Inputs inputs, CancellationToken cancellationToken) { return await _Get_HistoryDepositByPayment.Single(inputs, cancellationToken); }

    }
}
