﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Currency;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Network;

namespace Farakonesh.Logic.Database.BlockChain
{
    public class NetworkBlockChainContext: INetworkBlockChainContext
    {
        #region properties
        private string _connectionString { get; set; }
        #endregion properties

        #region SP_Network
        private readonly DP.DapperORM.BaseSP<Get_Network.Inputs, Get_Network.Outputs> _Get_Network;
        private readonly DP.DapperORM.BaseSP<Insert_Network.Inputs, Insert_Network.Outputs> _Insert_Network;
        private readonly DP.DapperORM.BaseSP<Delete_Network.Inputs, Delete_Network.Outputs> _Delete_Network;
        private readonly DP.DapperORM.BaseSP<Update_Network.Inputs, Update_Network.Outputs> _Update_Network;
        #endregion SP_Network

        public NetworkBlockChainContext(IConfiguration configuration)
        {

            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Get_Network = new DP.DapperORM.BaseSP<Get_Network.Inputs, Get_Network.Outputs>("BlockChain.Get_Network", executer);
            _Insert_Network = new DP.DapperORM.BaseSP<Insert_Network.Inputs, Insert_Network.Outputs>("BlockChain.Insert_Network", executer);
            _Delete_Network = new DP.DapperORM.BaseSP<Delete_Network.Inputs, Delete_Network.Outputs>("BlockChain.Delete_Network", executer);
            _Update_Network = new DP.DapperORM.BaseSP<Update_Network.Inputs, Update_Network.Outputs>("BlockChain.Update_Network", executer);

        }

        public async Task<DBResult<IEnumerable<Get_Network.Outputs>>> Get_Network(Get_Network.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Network.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Network(Insert_Network.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Network.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Network(Update_Network.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Network.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Network(Delete_Network.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Network.Execute(inputs, cancellationToken); }

    }
}
