﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Network;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Wallet;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;

namespace Farakonesh.Logic.Database.BlockChain
{
    public class WalletBlockChainContext: IWalletBlockChainContext
    {
        #region properties
        private string _connectionString { get; set; }
        #endregion properties

        #region SP_Network
        private readonly DP.DapperORM.BaseSP<Get_Wallet.Inputs, Get_Wallet.Outputs> _Get_Wallet;
        private readonly DP.DapperORM.BaseSP<Check_Validation_Wallet.Inputs, Check_Validation_Wallet.Outputs> _Check_Validation_Wallet;
        private readonly DP.DapperORM.BaseSP<Delete_Wallet.Inputs, Delete_Wallet.Outputs> _Delete_Wallet;
        private readonly DP.DapperORM.BaseSP<Insert_Wallet.Inputs, Insert_Wallet.Outputs> _Insert_Wallet;
        #endregion SP_Network

        public WalletBlockChainContext(IConfiguration configuration)
        {

            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Get_Wallet = new DP.DapperORM.BaseSP<Get_Wallet.Inputs, Get_Wallet.Outputs>("BlockChain.Get_Wallet", executer);
            _Check_Validation_Wallet = new DP.DapperORM.BaseSP<Check_Validation_Wallet.Inputs, Check_Validation_Wallet.Outputs>("BlockChain.Check_Validation_Wallet", executer);
            _Delete_Wallet = new DP.DapperORM.BaseSP<Delete_Wallet.Inputs, Delete_Wallet.Outputs>("BlockChain.Delete_Wallet", executer);
            _Insert_Wallet = new DP.DapperORM.BaseSP<Insert_Wallet.Inputs, Insert_Wallet.Outputs>("BlockChain.Insert_Wallet", executer);
        }

        public async Task<DBResult<IEnumerable<Get_Wallet.Outputs>>> Get_Wallet(Get_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Wallet.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<Check_Validation_Wallet.Outputs>> Check_Validation_Wallet(Check_Validation_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Check_Validation_Wallet.Single(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Wallet(Delete_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Wallet.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Wallet(Insert_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Wallet.Execute(inputs, cancellationToken); }

    }
}
