﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.ICrm;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.Crm;

namespace Farakonesh.Logic.Database.Crm
{
    public class CallHistoryContext: ICallHistoryContext
    {
        #region properties
        private string _connectionString { get; set; }
        #endregion properties

        #region SP_CallHistory
        private readonly DP.DapperORM.BaseSP<Get_CallHistory.Inputs, Get_CallHistory.Outputs> _Get_CallHistory;
        private readonly DP.DapperORM.BaseSP<Insert_CallHistory.Inputs, Insert_CallHistory.Outputs> _Insert_CallHistory;
        private readonly DP.DapperORM.BaseSP<Delete_CallHistory.Inputs, Delete_CallHistory.Outputs> _Delete_CallHistory;
        private readonly DP.DapperORM.BaseSP<Insert_CallHistoryGroup.Inputs, Insert_CallHistoryGroup.Outputs> _Insert_CallHistoryGroup;
        #endregion SP_CallHistory

        public CallHistoryContext(IConfiguration configuration)
        {

            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Get_CallHistory = new DP.DapperORM.BaseSP<Get_CallHistory.Inputs, Get_CallHistory.Outputs>("Crm.Get_CallHistory", executer);
            _Insert_CallHistory = new DP.DapperORM.BaseSP<Insert_CallHistory.Inputs, Insert_CallHistory.Outputs>("Crm.Insert_CallHistory", executer);
            _Delete_CallHistory = new DP.DapperORM.BaseSP<Delete_CallHistory.Inputs, Delete_CallHistory.Outputs>("Crm.Delete_CallHistory", executer);
            _Insert_CallHistoryGroup = new DP.DapperORM.BaseSP<Insert_CallHistoryGroup.Inputs, Insert_CallHistoryGroup.Outputs>("Crm.Insert_CallHistoryGroup", executer);

        }

        public async Task<DBResult<IEnumerable<Get_CallHistory.Outputs>>> Get_CallHistory(Get_CallHistory.Inputs inputs, CancellationToken cancellationToken) { return await _Get_CallHistory.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CallHistory(Insert_CallHistory.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CallHistory.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CallHistoryGroup(Insert_CallHistoryGroup.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CallHistoryGroup.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_CallHistory(Delete_CallHistory.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_CallHistory.Execute(inputs, cancellationToken); }

    }
}
