﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.App;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.AccountNumber;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class AccountNumberContext : IAccountNumberContext
    {
        private readonly DP.DapperORM.BaseSP<GetAccountNumberActive.Inputs, GetAccountNumberActive.Outputs> _GetAccountNumberActive;
        private readonly DP.DapperORM.BaseSP<GetAccountNumberByAdmin.Inputs, GetAccountNumberByAdmin.Outputs> _GetAccountNumberByAdmin;
        private readonly DP.DapperORM.BaseSP<GetAccountNumberHistory.Inputs, GetAccountNumberHistory.Outputs> _GetAccountNumberHistory;
        private readonly DP.DapperORM.BaseSP<InsertAccountNumber.Inputs, InsertAccountNumber.Outputs> _InsertAccountNumber;
        private readonly DP.DapperORM.BaseSP<UpdateAccountNumber.Inputs, UpdateAccountNumber.Outputs> _UpdateAccountNumber;
        private readonly DP.DapperORM.BaseSP<Delete_AccountNumber.Inputs, Delete_AccountNumber.Outputs> _Delete_AccountNumber;
        private readonly DP.DapperORM.BaseSP<InsertAccountNumberGroup.Inputs, InsertAccountNumberGroup.Outputs> _InsertAccountNumberGroup;
        private readonly DP.DapperORM.BaseSP<UpdateAccountNumberGroup.Inputs, UpdateAccountNumberGroup.Outputs> _UpdateAccountNumberGroup;

        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        public AccountNumberContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _GetAccountNumberActive = new DP.DapperORM.BaseSP<GetAccountNumberActive.Inputs, GetAccountNumberActive.Outputs>("Order.GetAccountNumberActive", executer);
            _GetAccountNumberByAdmin = new DP.DapperORM.BaseSP<GetAccountNumberByAdmin.Inputs, GetAccountNumberByAdmin.Outputs>("Order.GetAccountNumberByAdmin", executer);
            _GetAccountNumberHistory = new DP.DapperORM.BaseSP<GetAccountNumberHistory.Inputs, GetAccountNumberHistory.Outputs>("Order.GetAccountNumberHistory", executer);
            _InsertAccountNumber = new DP.DapperORM.BaseSP<InsertAccountNumber.Inputs, InsertAccountNumber.Outputs>("Order.InsertAccountNumber", executer);
            _UpdateAccountNumber = new DP.DapperORM.BaseSP<UpdateAccountNumber.Inputs, UpdateAccountNumber.Outputs>("Order.UpdateAccountNumber", executer);
            _Delete_AccountNumber = new DP.DapperORM.BaseSP<Delete_AccountNumber.Inputs, Delete_AccountNumber.Outputs>("Order.Delete_AccountNumber", executer);
            _InsertAccountNumberGroup = new DP.DapperORM.BaseSP<InsertAccountNumberGroup.Inputs, InsertAccountNumberGroup.Outputs>("Order.InsertAccountNumberGroup", executer);
            _UpdateAccountNumberGroup = new DP.DapperORM.BaseSP<UpdateAccountNumberGroup.Inputs, UpdateAccountNumberGroup.Outputs>("Order.UpdateAccountNumberGroup", executer);

        }

        public async Task<DBResult> InsertAccountNumber(InsertAccountNumber.Inputs inputs, CancellationToken cancellationToken) { return await _InsertAccountNumber.Execute(inputs, cancellationToken); }
        public async Task<DBResult> UpdateAccountNumber(UpdateAccountNumber.Inputs inputs, CancellationToken cancellationToken) { return await _UpdateAccountNumber.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_AccountNumber(Delete_AccountNumber.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_AccountNumber.Execute(inputs, cancellationToken); }
        public async Task<DBResult<GetAccountNumberActive.Outputs>> GetAccountNumberActive(GetAccountNumberActive.Inputs inputs, CancellationToken cancellationToken) { return await _GetAccountNumberActive.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetAccountNumberByAdmin.Outputs>>> GetAccountNumberByAdmin(GetAccountNumberByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetAccountNumberByAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetAccountNumberHistory.Outputs>>> GetAccountNumberHistory(GetAccountNumberHistory.Inputs inputs, CancellationToken cancellationToken) { return await _GetAccountNumberHistory.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> InsertAccountNumberGroup(InsertAccountNumberGroup.Inputs inputs, CancellationToken cancellationToken) { return await _InsertAccountNumberGroup.Execute(inputs, cancellationToken); }
        public async Task<DBResult> UpdateAccountNumberGroup(UpdateAccountNumberGroup.Inputs inputs, CancellationToken cancellationToken) { return await _UpdateAccountNumberGroup.Execute(inputs, cancellationToken); }
    }
}
