﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class AdvertisingContext: IAdvertisingContext
    {
        #region properties
        private string _connectionString { get; set; }
        private readonly IFileService _fileServices;
        private readonly ISettingContext _iSettingContext;
        private readonly RedisService _redis;

        #endregion properties

        private readonly DP.DapperORM.BaseSP<GetAdvertisingList.Inputs, GetAdvertisingList.Outputs> _GetAdvertisingList;
        private readonly DP.DapperORM.BaseSP<GetAdvertisingById.Inputs, GetAdvertisingById.Outputs> _GetAdvertisingById;
        private readonly DP.DapperORM.BaseSP<InsertAdvertising.Inputs, InsertAdvertising.Outputs> _InsertAdvertising;
        private readonly DP.DapperORM.BaseSP<UpdateAdvertising.Inputs, UpdateAdvertising.Outputs> _UpdateAdvertising;
        private readonly DP.DapperORM.BaseSP<Delete_Advertising.Inputs, Delete_Advertising.Outputs> _Delete_Advertising;

        public AdvertisingContext(IConfiguration configuration, IFileService fileServices, ISettingContext iSettingContext, RedisService redis)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _fileServices = fileServices;

            _Delete_Advertising = new DP.DapperORM.BaseSP<Delete_Advertising.Inputs, Delete_Advertising.Outputs>("Order.Delete_Advertising", executer);
            _GetAdvertisingList = new DP.DapperORM.BaseSP<GetAdvertisingList.Inputs, GetAdvertisingList.Outputs>("Order.GetAdvertisingList", executer);
            _GetAdvertisingById = new DP.DapperORM.BaseSP<GetAdvertisingById.Inputs, GetAdvertisingById.Outputs>("Order.GetAdvertisingById", executer);
            _InsertAdvertising = new DP.DapperORM.BaseSP<InsertAdvertising.Inputs, InsertAdvertising.Outputs>("Order.InsertAdvertising", executer);
            _UpdateAdvertising = new DP.DapperORM.BaseSP<UpdateAdvertising.Inputs, UpdateAdvertising.Outputs>("Order.UpdateAdvertising", executer);
            _iSettingContext = iSettingContext;
            _redis = redis;
        }

        public async Task<DBResult<IEnumerable<GetAdvertisingList.Outputs>>> GetAdvertisingList(GetAdvertisingList.Inputs inputs, CancellationToken cancellationToken) {return await _GetAdvertisingList.Query(inputs, cancellationToken); }
        public async Task<DBResult<GetAdvertisingById.Outputs>> GetAdvertisingById(GetAdvertisingById.Inputs inputs, CancellationToken cancellationToken) { return await _GetAdvertisingById.Single(inputs, cancellationToken); }
        public async Task<DBResult> InsertAdvertising(InsertAdvertising.Inputs inputs, CancellationToken cancellationToken) { return await _InsertAdvertising.Execute(inputs, cancellationToken); }
        public async Task<DBResult> UpdateAdvertising(UpdateAdvertising.Inputs inputs, CancellationToken cancellationToken) { return await _UpdateAdvertising.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Advertising(Delete_Advertising.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Advertising.Execute(inputs, cancellationToken); }

    }
}
