﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.ApplicationFee;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class ApplicationFeeContext: IApplicationFeeContext
    {
        private readonly RedisService _redis;
        private readonly IFileService _fileServices;
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Insert_OrderApplicationFeeByCustomer.Inputs, Insert_OrderApplicationFeeByCustomer.Outputs> _Insert_OrderApplicationFeeByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderApplicationFeeByCompany.Inputs, Insert_OrderApplicationFeeByCompany.Outputs> _Insert_OrderApplicationFeeByCompany;
        private readonly DP.DapperORM.BaseSP<GetOrder_ApplicationFee.Inputs, GetOrder_ApplicationFee.Outputs> _GetOrder_ApplicationFee;
        private readonly DP.DapperORM.BaseSP<GetOrder_ApplicationFeeByAdmin.Inputs, GetOrder_ApplicationFeeByAdmin.Outputs> _GetOrder_ApplicationFeeByAdmin;
        private readonly DP.DapperORM.BaseSP<Get_OrderApplicationFee_Price.Inputs, Get_OrderApplicationFee_Price.Outputs> _Get_OrderApplicationFee_Price;
        private readonly DP.DapperORM.BaseSP<Insert_OrderApplicationFeeMultipleByCustomer.Inputs, Insert_OrderApplicationFeeMultipleByCustomer.Outputs> _Insert_OrderApplicationFeeMultipleByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderApplicationFeeMultipleByCompany.Inputs, Insert_OrderApplicationFeeMultipleByCompany.Outputs> _Insert_OrderApplicationFeeMultipleByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderApplicationFeeByAdmin.Inputs, Insert_OrderApplicationFeeByAdmin.Outputs> _Insert_OrderApplicationFeeByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_ApplicationFeeMultipleByAdmin.Inputs, GetOrder_ApplicationFeeMultipleByAdmin.Outputs> _GetOrder_ApplicationFeeMultipleByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_ApplicationFeeMultiple.Inputs, GetOrder_ApplicationFeeMultiple.Outputs> _GetOrder_ApplicationFeeMultiple;
        private readonly DP.DapperORM.BaseSP<GetOrder_ApplicationFeeMultipleDetails.Inputs, GetOrder_ApplicationFeeMultipleDetails.Outputs> _GetOrder_ApplicationFeeMultipleDetails;
        private readonly DP.DapperORM.BaseSP<Get_OrderApplicationFee_Price_Servant.Inputs, Get_OrderApplicationFee_Price_Servant.Outputs> _Get_OrderApplicationFee_Price_Servant;
        public ApplicationFeeContext(IConfiguration configuration, RedisService redis, IFileService fileServices)
        {
            _redis = redis;
            _fileServices = fileServices;
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Insert_OrderApplicationFeeByCustomer = new DP.DapperORM.BaseSP<Insert_OrderApplicationFeeByCustomer.Inputs, Insert_OrderApplicationFeeByCustomer.Outputs>("Order.Insert_OrderApplicationFeeByCustomer", executer);
            _Insert_OrderApplicationFeeByCompany = new DP.DapperORM.BaseSP<Insert_OrderApplicationFeeByCompany.Inputs, Insert_OrderApplicationFeeByCompany.Outputs>("Order.Insert_OrderApplicationFeeByCompany", executer);

            _GetOrder_ApplicationFee = new DP.DapperORM.BaseSP<GetOrder_ApplicationFee.Inputs, GetOrder_ApplicationFee.Outputs>("Order.GetOrder_ApplicationFee", executer);
            _GetOrder_ApplicationFeeByAdmin = new DP.DapperORM.BaseSP<GetOrder_ApplicationFeeByAdmin.Inputs, GetOrder_ApplicationFeeByAdmin.Outputs>("Order.GetOrder_ApplicationFeeByAdmin", executer);
            _Get_OrderApplicationFee_Price = new DP.DapperORM.BaseSP<Get_OrderApplicationFee_Price.Inputs, Get_OrderApplicationFee_Price.Outputs>("Order.Get_OrderApplicationFee_Price", executer);
            _Get_OrderApplicationFee_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderApplicationFee_Price_Servant.Inputs, Get_OrderApplicationFee_Price_Servant.Outputs>("Order.Get_OrderApplicationFee_Price_Servant", executer);
            _GetOrder_ApplicationFeeMultipleDetails = new DP.DapperORM.BaseSP<GetOrder_ApplicationFeeMultipleDetails.Inputs, GetOrder_ApplicationFeeMultipleDetails.Outputs>("Order.GetOrder_ApplicationFeeMultipleDetails", executer);
            _GetOrder_ApplicationFeeMultipleByAdmin = new DP.DapperORM.BaseSP<GetOrder_ApplicationFeeMultipleByAdmin.Inputs, GetOrder_ApplicationFeeMultipleByAdmin.Outputs>("Order.GetOrder_ApplicationFeeMultipleByAdmin", executer);
            _GetOrder_ApplicationFeeMultiple = new DP.DapperORM.BaseSP<GetOrder_ApplicationFeeMultiple.Inputs, GetOrder_ApplicationFeeMultiple.Outputs>("Order.GetOrder_ApplicationFeeMultiple", executer);
            _Insert_OrderApplicationFeeMultipleByCustomer = new DP.DapperORM.BaseSP<Insert_OrderApplicationFeeMultipleByCustomer.Inputs, Insert_OrderApplicationFeeMultipleByCustomer.Outputs>("Order.Insert_OrderApplicationFeeMultipleByCustomer", executer);
            _Insert_OrderApplicationFeeMultipleByCompany = new DP.DapperORM.BaseSP<Insert_OrderApplicationFeeMultipleByCompany.Inputs, Insert_OrderApplicationFeeMultipleByCompany.Outputs>("Order.Insert_OrderApplicationFeeMultipleByCompany", executer);
            _Insert_OrderApplicationFeeByAdmin = new DP.DapperORM.BaseSP<Insert_OrderApplicationFeeByAdmin.Inputs, Insert_OrderApplicationFeeByAdmin.Outputs>("Order.Insert_OrderApplicationFeeByAdmin", executer);

        }
        public async Task<DBResult<Insert_OrderApplicationFeeByCustomer.Outputs>> Insert_OrderApplicationFeeByCustomer(Insert_OrderApplicationFeeByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderApplicationFeeByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderApplicationFeeByCompany.Outputs>> Insert_OrderApplicationFeeByCompany(Insert_OrderApplicationFeeByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderApplicationFeeByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_ApplicationFee.Outputs>>> GetOrder_ApplicationFee(GetOrder_ApplicationFee.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_ApplicationFee.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_ApplicationFeeByAdmin.Outputs>>> GetOrder_ApplicationFeeByAdmin(GetOrder_ApplicationFeeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_ApplicationFeeByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderApplicationFee_Price.Outputs>> Get_OrderApplicationFee_Price(Get_OrderApplicationFee_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderApplicationFee_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_ApplicationFeeMultipleByAdmin.Outputs>>> GetOrder_ApplicationFeeMultipleByAdmin(GetOrder_ApplicationFeeMultipleByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_ApplicationFeeMultipleByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderApplicationFee_Price_Servant.Outputs>> Get_OrderApplicationFee_Price_Servant(Get_OrderApplicationFee_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderApplicationFee_Price_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_ApplicationFeeMultiple.Outputs>>> GetOrder_ApplicationFeeMultiple(GetOrder_ApplicationFeeMultiple.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_ApplicationFeeMultiple.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_ApplicationFeeMultipleDetails.Outputs>>> GetOrder_ApplicationFeeMultipleDetails(GetOrder_ApplicationFeeMultipleDetails.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_ApplicationFeeMultipleDetails.Query(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderApplicationFeeMultipleByCustomer.Outputs>> Insert_OrderApplicationFeeMultipleByCustomer(Insert_OrderApplicationFeeMultipleByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderApplicationFeeMultipleByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderApplicationFeeMultipleByCompany.Outputs>> Insert_OrderApplicationFeeMultipleByCompany(Insert_OrderApplicationFeeMultipleByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderApplicationFeeMultipleByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderApplicationFeeByAdmin.Outputs>> Insert_OrderApplicationFeeByAdmin(Insert_OrderApplicationFeeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderApplicationFeeByAdmin.Single(inputs, cancellationToken); }

    }
}
