﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class CountryContext : ICountryContext
    {
        #region properties
        private string _connectionString { get; set; }
        private readonly IFileService _fileServices;
        private readonly RedisService _redis;
        #endregion properties

        private readonly DP.DapperORM.BaseSP<Delete_Country.Inputs, Delete_Country.Outputs> _Delete_Country;
        private readonly DP.DapperORM.BaseSP<GetCountryById.Inputs, GetCountryById.Outputs> _GetCountryById;
        private readonly DP.DapperORM.BaseSP<GetCountryList.Inputs, GetCountryList.Outputs> _GetCountryList;
        private readonly DP.DapperORM.BaseSP<Insert_Country.Inputs, Insert_Country.Outputs> _Insert_Country;
        private readonly DP.DapperORM.BaseSP<Update_Country.Inputs, Update_Country.Outputs> _Update_Country;

        public CountryContext(IConfiguration configuration,
            RedisService redis)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _redis = redis;
            _Delete_Country = new DP.DapperORM.BaseSP<Delete_Country.Inputs, Delete_Country.Outputs>("Order.Delete_Country", executer);
            _GetCountryById = new DP.DapperORM.BaseSP<GetCountryById.Inputs, GetCountryById.Outputs>("Order.GetCountryById", executer);
            _GetCountryList = new DP.DapperORM.BaseSP<GetCountryList.Inputs, GetCountryList.Outputs>("Order.GetCountryList", executer);
            _Insert_Country = new DP.DapperORM.BaseSP<Insert_Country.Inputs, Insert_Country.Outputs>("Order.Insert_Country", executer);
            _Update_Country = new DP.DapperORM.BaseSP<Update_Country.Inputs, Update_Country.Outputs>("Order.Update_Country", executer);


        }
        public async Task<DBResult> Delete_Country(Delete_Country.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Country.Execute(inputs, cancellationToken); }
        public async Task<DBResult<GetCountryById.Outputs>> GetCountryById(GetCountryById.Inputs inputs, CancellationToken cancellationToken) { return await _GetCountryById.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCountryList.Outputs>>> GetCountryList(GetCountryList.Inputs inputs, CancellationToken cancellationToken)
        {
            return await _GetCountryList.Query(inputs, cancellationToken);

        }
        public async Task<DBResult> Insert_Country(Insert_Country.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Country.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Country(Update_Country.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Country.Execute(inputs, cancellationToken); }


    }
}
