﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.ApplicationFee;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.DP.DapperORM;

namespace Farakonesh.Logic.Database.Order
{
    public class CurrencyContext : ICurrencyContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly BaseSP<Insert_CurrencyRates.Inputs, Insert_CurrencyRates.Outputs> _Insert_CurrencyRates;
        private readonly BaseSP<Insert_Currency_Main.Inputs, Insert_Currency_Main.Outputs> _Insert_Currency_Main;
        private readonly DP.DapperORM.BaseSP<GetCurrencyAmountListByCustomer.Inputs, GetCurrencyAmountListByCustomer.Outputs> _GetCurrencyAmountListByCustomer;
        private readonly DP.DapperORM.BaseSP<Appointment_Currency.Inputs, Appointment_Currency.Outputs> _Appointment_Currency;
        private readonly DP.DapperORM.BaseSP<GetCurrency.Inputs, GetCurrency.Outputs> _GetCurrency;
        private readonly DP.DapperORM.BaseSP<Delete_CurrencyOrder.Inputs, Delete_CurrencyOrder.Outputs> _Delete_CurrencyOrder;
        private readonly DP.DapperORM.BaseSP<Update_CurrencyShow.Inputs, Update_CurrencyShow.Outputs> _Update_CurrencyShow;
        private readonly DP.DapperORM.BaseSP<GetCurrencyAmountListByAdmin.Inputs, GetCurrencyAmountListByAdmin.Outputs> _GetCurrencyAmountListByAdmin;
        private readonly DP.DapperORM.BaseSP<Update_CurrencyPercentageOfImpact.Inputs, Update_CurrencyPercentageOfImpact.Outputs> _Update_CurrencyPercentageOfImpact;
        private readonly DP.DapperORM.BaseSP<Delete_Currency.Inputs, Delete_Currency.Outputs> _Delete_Currency;
        private readonly DP.DapperORM.BaseSP<GetCurrencyAmountById.Inputs, GetCurrencyAmountById.Outputs> _GetCurrencyAmountById;
        private readonly DP.DapperORM.BaseSP<GetCurrencyAmountList.Inputs, GetCurrencyAmountList.Outputs> _GetCurrencyAmountList;
        private readonly DP.DapperORM.BaseSP<GetCurrencyById.Inputs, GetCurrencyById.Outputs> _GetCurrencyById;
        private readonly DP.DapperORM.BaseSP<GetCurrencyList.Inputs, GetCurrencyList.Outputs> _GetCurrencyList;
        private readonly DP.DapperORM.BaseSP<Insert_Currency.Inputs, Insert_Currency.Outputs> _Insert_Currency;
        private readonly DP.DapperORM.BaseSP<Insert_CurrencyAmount.Inputs, Insert_CurrencyAmount.Outputs> _Insert_CurrencyAmount;
        private readonly DP.DapperORM.BaseSP<Insert_CurrencyAmountGroup.Inputs, Insert_CurrencyAmountGroup.Outputs> _Insert_CurrencyAmountGroup;
        private readonly DP.DapperORM.BaseSP<Update_Currency.Inputs, Update_Currency.Outputs> _Update_Currency;
        private readonly DP.DapperORM.BaseSP<Get_CurrencyPecentSetting.Inputs, Get_CurrencyPecentSetting.Outputs> _Get_CurrencyPecentSetting;
        private readonly DP.DapperORM.BaseSP<Delete_CurrencyPecentSetting.Inputs, Delete_CurrencyPecentSetting.Outputs> _Delete_CurrencyPecentSetting;
        private readonly DP.DapperORM.BaseSP<Insert_CurrencyPercentSetting.Inputs, Insert_CurrencyPercentSetting.Outputs> _Insert_CurrencyPercentSetting;
        private readonly DP.DapperORM.BaseSP<Update_CurrencyPercentSetting.Inputs, Update_CurrencyPercentSetting.Outputs> _Update_CurrencyPercentSetting;
        private readonly DP.DapperORM.BaseSP<GetCurrencyAmountList_Servant.Inputs, GetCurrencyAmountList_Servant.Outputs> _GetCurrencyAmountList_Servant;
        private readonly BaseSP<GetCurrencyList_Servant.Inputs, GetCurrencyList_Servant.Outputs> _GetCurrencyList_Servant;
        private readonly BaseSP<GetCurrencyListByCustomer.Inputs, GetCurrencyListByCustomer.Outputs> _GetCurrencyListByCustomer;
        private readonly BaseSP<Insert_CurrencyIndicator_Automatic.Inputs, Insert_CurrencyIndicator_Automatic.Outputs> _Insert_CurrencyIndicator_Automatic;
        private readonly BaseSP<Update_MinAmountForChange.Inputs, Update_MinAmountForChange.Outputs> _Update_MinAmountForChange;
        public CurrencyContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Insert_CurrencyRates = new BaseSP<Insert_CurrencyRates.Inputs, Insert_CurrencyRates.Outputs>("Order.Insert_CurrencyRates", executer);
            _Insert_Currency_Main = new DP.DapperORM.BaseSP<Insert_Currency_Main.Inputs, Insert_Currency_Main.Outputs>("Order.Insert_CurrencyAmount_Main", executer);
            _GetCurrencyAmountListByCustomer = new DP.DapperORM.BaseSP<GetCurrencyAmountListByCustomer.Inputs, GetCurrencyAmountListByCustomer.Outputs>("Order.GetCurrencyAmountListByCustomer", executer);
            _Appointment_Currency = new DP.DapperORM.BaseSP<Appointment_Currency.Inputs, Appointment_Currency.Outputs>("Order.Appointment_Currency", executer);
            _GetCurrency = new DP.DapperORM.BaseSP<GetCurrency.Inputs, GetCurrency.Outputs>("Order.GetCurrency", executer);
            _Delete_CurrencyOrder = new DP.DapperORM.BaseSP<Delete_CurrencyOrder.Inputs, Delete_CurrencyOrder.Outputs>("Order.Delete_CurrencyOrder", executer);
            _Update_CurrencyShow = new DP.DapperORM.BaseSP<Update_CurrencyShow.Inputs, Update_CurrencyShow.Outputs>("Order.Update_CurrencyShow", executer);
            _GetCurrencyAmountListByAdmin = new DP.DapperORM.BaseSP<GetCurrencyAmountListByAdmin.Inputs, GetCurrencyAmountListByAdmin.Outputs>("Order.GetCurrencyAmountListByAdmin", executer);
            _Update_CurrencyPercentageOfImpact = new DP.DapperORM.BaseSP<Update_CurrencyPercentageOfImpact.Inputs, Update_CurrencyPercentageOfImpact.Outputs>("Order.Update_CurrencyPercentageOfImpact", executer);
            _Delete_Currency = new DP.DapperORM.BaseSP<Delete_Currency.Inputs, Delete_Currency.Outputs>("Order.Delete_Currency", executer);
            _GetCurrencyAmountById = new DP.DapperORM.BaseSP<GetCurrencyAmountById.Inputs, GetCurrencyAmountById.Outputs>("Order.GetCurrencyAmountById", executer);
            _GetCurrencyAmountList = new DP.DapperORM.BaseSP<GetCurrencyAmountList.Inputs, GetCurrencyAmountList.Outputs>("Order.GetCurrencyAmountList", executer);
            _GetCurrencyById = new DP.DapperORM.BaseSP<GetCurrencyById.Inputs, GetCurrencyById.Outputs>("Order.GetCurrencyById", executer);
            _GetCurrencyList = new DP.DapperORM.BaseSP<GetCurrencyList.Inputs, GetCurrencyList.Outputs>("Order.GetCurrencyList", executer);
            _Insert_Currency = new DP.DapperORM.BaseSP<Insert_Currency.Inputs, Insert_Currency.Outputs>("Order.Insert_Currency", executer);
            _Insert_CurrencyAmount = new DP.DapperORM.BaseSP<Insert_CurrencyAmount.Inputs, Insert_CurrencyAmount.Outputs>("Order.Insert_CurrencyAmount", executer);
            _Insert_CurrencyAmountGroup = new DP.DapperORM.BaseSP<Insert_CurrencyAmountGroup.Inputs, Insert_CurrencyAmountGroup.Outputs>("Order.Insert_CurrencyAmountGroup", executer);
            _Insert_Currency = new DP.DapperORM.BaseSP<Insert_Currency.Inputs, Insert_Currency.Outputs>("Order.Insert_Currency", executer);
            _Update_Currency = new DP.DapperORM.BaseSP<Update_Currency.Inputs, Update_Currency.Outputs>("Order.Update_Currency", executer);
            _Get_CurrencyPecentSetting = new DP.DapperORM.BaseSP<Get_CurrencyPecentSetting.Inputs, Get_CurrencyPecentSetting.Outputs>("Order.Get_CurrencyPecentSetting", executer);
            _Insert_CurrencyPercentSetting = new DP.DapperORM.BaseSP<Insert_CurrencyPercentSetting.Inputs, Insert_CurrencyPercentSetting.Outputs>("Order.Insert_CurrencyPercentSetting", executer);
            _Update_CurrencyPercentSetting = new DP.DapperORM.BaseSP<Update_CurrencyPercentSetting.Inputs, Update_CurrencyPercentSetting.Outputs>("Order.Update_CurrencyPercentSetting", executer);
            _Delete_CurrencyPecentSetting = new DP.DapperORM.BaseSP<Delete_CurrencyPecentSetting.Inputs, Delete_CurrencyPecentSetting.Outputs>("Order.Delete_CurrencyPecentSetting", executer);
            _GetCurrencyAmountList_Servant = new DP.DapperORM.BaseSP<GetCurrencyAmountList_Servant.Inputs, GetCurrencyAmountList_Servant.Outputs>("Order.GetCurrencyAmountList_Servant", executer);
            _GetCurrencyList_Servant = new BaseSP<GetCurrencyList_Servant.Inputs, GetCurrencyList_Servant.Outputs>("Order.GetCurrencyList_Servant", executer);
            _GetCurrencyListByCustomer = new BaseSP<GetCurrencyListByCustomer.Inputs, GetCurrencyListByCustomer.Outputs>("Order.GetCurrencyListByCustomer", executer);
            _Insert_CurrencyIndicator_Automatic = new BaseSP<Insert_CurrencyIndicator_Automatic.Inputs, Insert_CurrencyIndicator_Automatic.Outputs>("Order.Insert_CurrencyIndicator_Automatic", executer);
            _Update_MinAmountForChange = new BaseSP<Update_MinAmountForChange.Inputs, Update_MinAmountForChange.Outputs>("Order.Update_MinAmountForChange", executer);

        }
        public async Task<DBResult> Insert_Currency_Main(Insert_Currency_Main.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Currency_Main.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Appointment_Currency.Outputs>> Appointment_Currency(Appointment_Currency.Inputs inputs, CancellationToken cancellationToken) { return await _Appointment_Currency.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCurrencyAmountListByCustomer.Outputs>>> GetCurrencyAmountListByCustomer(GetCurrencyAmountListByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _GetCurrencyAmountListByCustomer.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCurrency.Outputs>>> GetCurrency(GetCurrency.Inputs inputs, CancellationToken cancellationToken) { return await _GetCurrency.Query(inputs, cancellationToken); }
        public async Task<DBResult> Delete_CurrencyOrder(Delete_CurrencyOrder.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_CurrencyOrder.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_CurrencyShow(Update_CurrencyShow.Inputs inputs, CancellationToken cancellationToken) { return await _Update_CurrencyShow.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_CurrencyPercentageOfImpact(Update_CurrencyPercentageOfImpact.Inputs inputs, CancellationToken cancellationToken) { return await _Update_CurrencyPercentageOfImpact.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCurrencyAmountListByAdmin.Outputs>>> GetCurrencyAmountListByAdmin(GetCurrencyAmountListByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetCurrencyAmountListByAdmin.QueryPagination(inputs, cancellationToken); }
        /// <summary>
        /// دریافت لیست ارز به همراه قیمت تومانی آن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        public async Task<DBResult<IEnumerable<GetCurrencyAmountList.Outputs>>> GetCurrencyAmountList(GetCurrencyAmountList.Inputs inputs, CancellationToken cancellationToken)
        {
            return await _GetCurrencyAmountList.QueryPagination(inputs, cancellationToken);
        }
        public async Task<DBResult<IEnumerable<GetCurrencyListByCustomer.Outputs>>> GetCurrencyListByCustomer(GetCurrencyListByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            return await _GetCurrencyListByCustomer.Query(inputs, cancellationToken);
        }
        public async Task<DBResult<GetCurrencyById.Outputs>> GetCurrencyById(GetCurrencyById.Inputs inputs, CancellationToken cancellationToken) { return await _GetCurrencyById.Single(inputs, cancellationToken); }
        /// <summary>
        /// دریافت لیست ارز ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        public async Task<DBResult<IEnumerable<GetCurrencyList.Outputs>>> GetCurrencyList(GetCurrencyList.Inputs inputs, CancellationToken cancellationToken)
        { return await _GetCurrencyList.Query(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Currency(Delete_Currency.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Currency.Execute(inputs, cancellationToken); }
        public async Task<DBResult<GetCurrencyAmountById.Outputs>> GetCurrencyAmountById(GetCurrencyAmountById.Inputs inputs, CancellationToken cancellationToken) { return await _GetCurrencyAmountById.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_CurrencyPecentSetting.Outputs>>> Get_CurrencyPecentSetting(Get_CurrencyPecentSetting.Inputs inputs, CancellationToken cancellationToken) { return await _Get_CurrencyPecentSetting.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyPercentSetting(Insert_CurrencyPercentSetting.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyPercentSetting.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_CurrencyPercentSetting(Update_CurrencyPercentSetting.Inputs inputs, CancellationToken cancellationToken) { return await _Update_CurrencyPercentSetting.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_CurrencyPecentSetting(Delete_CurrencyPecentSetting.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_CurrencyPecentSetting.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Currency(Insert_Currency.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Currency.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyAmount(Insert_CurrencyAmount.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyAmount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyAmountGroup(Insert_CurrencyAmountGroup.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyAmountGroup.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Currency(Update_Currency.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Currency.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCurrencyList_Servant.Outputs>>> GetCurrencyList_Servant(GetCurrencyList_Servant.Inputs inputs, CancellationToken cancellationToken)
        {
            return await _GetCurrencyList_Servant.Query(inputs, cancellationToken);
          
        }
        public async Task<DBResult<IEnumerable<GetCurrencyAmountList_Servant.Outputs>>> GetCurrencyAmountList_Servant(GetCurrencyAmountList_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _GetCurrencyAmountList_Servant.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyIndicator_Automatic(Insert_CurrencyIndicator_Automatic.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyIndicator_Automatic.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_MinAmountForChange(Update_MinAmountForChange.Inputs inputs, CancellationToken cancellationToken) { return await _Update_MinAmountForChange.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyRates(Insert_CurrencyRates.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyRates.Execute(inputs, cancellationToken); }
    }
}
