﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class CurrencyHistoryWarehouseContext: ICurrencyHistoryWarehouseContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Get_HistoryWarehouse_Admin.Inputs, Get_HistoryWarehouse_Admin.Outputs> _Get_HistoryWarehouse_Admin;
        private readonly DP.DapperORM.BaseSP<Delete_HistoryWarehouse.Inputs, Delete_HistoryWarehouse.Outputs> _Delete_HistoryWarehouse;
        private readonly DP.DapperORM.BaseSP<Insert_HistoryWarehouseByAdmin.Inputs, Insert_HistoryWarehouseByAdmin.Outputs> _Insert_HistoryWarehouseByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_HistoryWarehouseByServicecWorker.Inputs, Insert_HistoryWarehouseByServicecWorker.Outputs> _Insert_HistoryWarehouseByServicecWorker;
        private readonly DP.DapperORM.BaseSP<Insert_HistoryWarehouseByChangeStatusOrder.Inputs, Insert_HistoryWarehouseByChangeStatusOrder.Outputs> _Insert_HistoryWarehouseByChangeStatusOrder;
        private readonly DP.DapperORM.BaseSP<Appointment_Order_To_CurrencyWareHouse.Inputs, Appointment_Order_To_CurrencyWareHouse.Outputs> _Appointment_Order_To_CurrencyWareHouse;
        public CurrencyHistoryWarehouseContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Get_HistoryWarehouse_Admin = new DP.DapperORM.BaseSP<Get_HistoryWarehouse_Admin.Inputs, Get_HistoryWarehouse_Admin.Outputs>("Order.Get_HistoryWarehouse_Admin", executer);
            _Delete_HistoryWarehouse = new DP.DapperORM.BaseSP<Delete_HistoryWarehouse.Inputs, Delete_HistoryWarehouse.Outputs>("Order.Delete_HistoryWarehouse", executer);
            _Insert_HistoryWarehouseByAdmin = new DP.DapperORM.BaseSP<Insert_HistoryWarehouseByAdmin.Inputs, Insert_HistoryWarehouseByAdmin.Outputs>("Order.Insert_HistoryWarehouseByAdmin", executer);
            _Insert_HistoryWarehouseByServicecWorker = new DP.DapperORM.BaseSP<Insert_HistoryWarehouseByServicecWorker.Inputs, Insert_HistoryWarehouseByServicecWorker.Outputs>("Order.Insert_HistoryWarehouseByServicecWorker", executer);
            _Insert_HistoryWarehouseByChangeStatusOrder = new DP.DapperORM.BaseSP<Insert_HistoryWarehouseByChangeStatusOrder.Inputs, Insert_HistoryWarehouseByChangeStatusOrder.Outputs>("Order.Insert_HistoryWarehouseByChangeStatusOrder", executer);
            _Appointment_Order_To_CurrencyWareHouse = new DP.DapperORM.BaseSP<Appointment_Order_To_CurrencyWareHouse.Inputs, Appointment_Order_To_CurrencyWareHouse.Outputs>("Order.Appointment_Order_To_CurrencyWareHouse", executer);

        }
        public async Task<DBResult<IEnumerable<Get_HistoryWarehouse_Admin.Outputs>>> Get_HistoryWarehouse_Admin(Get_HistoryWarehouse_Admin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_HistoryWarehouse_Admin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_HistoryWarehouseByAdmin(Insert_HistoryWarehouseByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_HistoryWarehouseByAdmin.Execute(inputs, cancellationToken); }

        public async Task<DBResult> Delete_HistoryWarehouse(Delete_HistoryWarehouse.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_HistoryWarehouse.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Appointment_Order_To_CurrencyWareHouse(Appointment_Order_To_CurrencyWareHouse.Inputs inputs, CancellationToken cancellationToken) { return await _Appointment_Order_To_CurrencyWareHouse.Execute(inputs, cancellationToken); }

        public async Task<DBResult> Insert_HistoryWarehouseByServicecWorker(Insert_HistoryWarehouseByServicecWorker.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_HistoryWarehouseByServicecWorker.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_HistoryWarehouseByChangeStatusOrder(Insert_HistoryWarehouseByChangeStatusOrder.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_HistoryWarehouseByChangeStatusOrder.Execute(inputs, cancellationToken); }
    }
}
