﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.Logic.Database.Order
{
    public class CurrencyHistoryWarehouseTomanContext: ICurrencyHistoryWarehouseTomanContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Get_HistoryWarehouseToman_Admin.Inputs, Get_HistoryWarehouseToman_Admin.Outputs> _Get_HistoryWarehouseToman_Admin;
        private readonly DP.DapperORM.BaseSP<Delete_HistoryWarehouseToman.Inputs, Delete_HistoryWarehouseToman.Outputs> _Delete_HistoryWarehouseToman;
        private readonly DP.DapperORM.BaseSP<Insert_HistoryWarehouseTomanByAdmin.Inputs, Insert_HistoryWarehouseTomanByAdmin.Outputs> _Insert_HistoryWarehouseTomanByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_HistoryWarehouseTomanByServicecWorker.Inputs, Insert_HistoryWarehouseTomanByServicecWorker.Outputs> _Insert_HistoryWarehouseTomanByServicecWorker;
        private readonly DP.DapperORM.BaseSP<Insert_HistoryWarehouseByChangeStatusOrderToman.Inputs, Insert_HistoryWarehouseByChangeStatusOrderToman.Outputs> _Insert_HistoryWarehouseByChangeStatusOrderToman;
        public CurrencyHistoryWarehouseTomanContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Get_HistoryWarehouseToman_Admin = new DP.DapperORM.BaseSP<Get_HistoryWarehouseToman_Admin.Inputs, Get_HistoryWarehouseToman_Admin.Outputs>("Order.Get_HistoryWarehouseToman_Admin", executer);
            _Delete_HistoryWarehouseToman = new DP.DapperORM.BaseSP<Delete_HistoryWarehouseToman.Inputs, Delete_HistoryWarehouseToman.Outputs>("Order.Delete_HistoryWarehouseToman", executer);
            _Insert_HistoryWarehouseTomanByAdmin = new DP.DapperORM.BaseSP<Insert_HistoryWarehouseTomanByAdmin.Inputs, Insert_HistoryWarehouseTomanByAdmin.Outputs>("Order.Insert_HistoryWarehouseTomanByAdmin", executer);
            _Insert_HistoryWarehouseTomanByServicecWorker = new DP.DapperORM.BaseSP<Insert_HistoryWarehouseTomanByServicecWorker.Inputs, Insert_HistoryWarehouseTomanByServicecWorker.Outputs>("Order.Insert_HistoryWarehouseTomanByServicecWorker", executer);
            _Insert_HistoryWarehouseByChangeStatusOrderToman = new DP.DapperORM.BaseSP<Insert_HistoryWarehouseByChangeStatusOrderToman.Inputs, Insert_HistoryWarehouseByChangeStatusOrderToman.Outputs>("Order.Insert_HistoryWarehouseByChangeStatusOrderToman", executer);

        }
        public async Task<DBResult<IEnumerable<Get_HistoryWarehouseToman_Admin.Outputs>>> Get_HistoryWarehouseToman_Admin(Get_HistoryWarehouseToman_Admin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_HistoryWarehouseToman_Admin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_HistoryWarehouseTomanByAdmin(Insert_HistoryWarehouseTomanByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_HistoryWarehouseTomanByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_HistoryWarehouseToman(Delete_HistoryWarehouseToman.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_HistoryWarehouseToman.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_HistoryWarehouseTomanByServicecWorker(Insert_HistoryWarehouseTomanByServicecWorker.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_HistoryWarehouseTomanByServicecWorker.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_HistoryWarehouseByChangeStatusOrderToman(Insert_HistoryWarehouseByChangeStatusOrderToman.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_HistoryWarehouseByChangeStatusOrderToman.Execute(inputs,cancellationToken); }
    }
}
