﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.App;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Wage;

namespace Farakonesh.Logic.Database.Order
{
    public class CurrencyWageContext: ICurrencyWageContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Insert_CurrencyWageGroupStair.Inputs, Insert_CurrencyWageGroupStair.Outputs> _Insert_CurrencyWageGroupStair;
        private readonly DP.DapperORM.BaseSP<Insert_CurrencyWageGroup.Inputs, Insert_CurrencyWageGroup.Outputs> _Insert_CurrencyWageGroup;
        private readonly DP.DapperORM.BaseSP<GetCurrencyWageList.Inputs, GetCurrencyWageList.Outputs> _GetCurrencyWageList;
        private readonly DP.DapperORM.BaseSP<Insert_CurrencyWage.Inputs, Insert_CurrencyWage.Outputs> _Insert_CurrencyWage;
        private readonly DP.DapperORM.BaseSP<Update_CurrencyWage.Inputs, Update_CurrencyWage.Outputs> _Update_CurrencyWage;
        private readonly DP.DapperORM.BaseSP<Delete_CurrencyWage.Inputs, Delete_CurrencyWage.Outputs> _Delete_CurrencyWage;

        private readonly DP.DapperORM.BaseSP<GetWagesList.Inputs, GetWagesList.Outputs> _GetWagesList;
        private readonly DP.DapperORM.BaseSP<Insert_Wages.Inputs, Insert_Wages.Outputs> _Insert_Wages;
        private readonly DP.DapperORM.BaseSP<Update_CurrencyWageGroup.Inputs, Update_CurrencyWageGroup.Outputs> _Update_CurrencyWageGroup;
        private readonly DP.DapperORM.BaseSP<Insert_CurrencyWage_FullGroupSave.Inputs, Insert_CurrencyWage_FullGroupSave.Outputs> _Insert_CurrencyWage_FullGroupSave;
        public CurrencyWageContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _GetCurrencyWageList = new DP.DapperORM.BaseSP<GetCurrencyWageList.Inputs, GetCurrencyWageList.Outputs>("Order.GetCurrencyWageList", executer);
            _Insert_CurrencyWage = new DP.DapperORM.BaseSP<Insert_CurrencyWage.Inputs, Insert_CurrencyWage.Outputs>("Order.Insert_CurrencyWage", executer);
            _Update_CurrencyWage = new DP.DapperORM.BaseSP<Update_CurrencyWage.Inputs, Update_CurrencyWage.Outputs>("Order.Update_CurrencyWage", executer);
            _Delete_CurrencyWage = new DP.DapperORM.BaseSP<Delete_CurrencyWage.Inputs, Delete_CurrencyWage.Outputs>("Order.Delete_CurrencyWage", executer);
            _Insert_Wages = new DP.DapperORM.BaseSP<Insert_Wages.Inputs, Insert_Wages.Outputs>("Order.Insert_Wages", executer);
            _GetWagesList = new DP.DapperORM.BaseSP<GetWagesList.Inputs, GetWagesList.Outputs>("Order.GetWagesList", executer);
            _Insert_CurrencyWageGroup = new DP.DapperORM.BaseSP<Insert_CurrencyWageGroup.Inputs, Insert_CurrencyWageGroup.Outputs>("Order.Insert_CurrencyWageGroup", executer);
            _Insert_CurrencyWageGroupStair = new DP.DapperORM.BaseSP<Insert_CurrencyWageGroupStair.Inputs, Insert_CurrencyWageGroupStair.Outputs>("Order.Insert_CurrencyWageGroupStair", executer);
            _Update_CurrencyWageGroup = new DP.DapperORM.BaseSP<Update_CurrencyWageGroup.Inputs, Update_CurrencyWageGroup.Outputs>("Order.Update_CurrencyWageGroup", executer);
            _Insert_CurrencyWage_FullGroupSave = new DP.DapperORM.BaseSP<Insert_CurrencyWage_FullGroupSave.Inputs, Insert_CurrencyWage_FullGroupSave.Outputs>("Order.Insert_CurrencyWage_FullGroupSave", executer);
        }
        public async Task<DBResult<IEnumerable<GetCurrencyWageList.Outputs>>> GetCurrencyWageList(GetCurrencyWageList.Inputs inputs, CancellationToken cancellationToken) { return await _GetCurrencyWageList.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyWage(Insert_CurrencyWage.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyWage.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_CurrencyWage(Update_CurrencyWage.Inputs inputs, CancellationToken cancellationToken) { return await _Update_CurrencyWage.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_CurrencyWage(Delete_CurrencyWage.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_CurrencyWage.Execute(inputs, cancellationToken); }

        public async Task<DBResult> Insert_Wages(Insert_Wages.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Wages.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetWagesList.Outputs>>> GetWagesList(GetWagesList.Inputs inputs, CancellationToken cancellationToken) { return await _GetWagesList.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyWageGroup(Insert_CurrencyWageGroup.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyWageGroup.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyWageGroupStair(Insert_CurrencyWageGroupStair.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyWageGroupStair.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_CurrencyWageGroup(Update_CurrencyWageGroup.Inputs inputs, CancellationToken cancellationToken) { return await _Update_CurrencyWageGroup.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyWage_FullGroupSave(Insert_CurrencyWage_FullGroupSave.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyWage_FullGroupSave.Execute(inputs, cancellationToken); }

    }
}
