﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Farakonesh.Logic.Security;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.Report;

namespace Farakonesh.Logic.Database.Order
{
    public class CurrencyWarehouseContext: ICurrencyWarehouseContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Get_CurrencyWarehouse_Admin.Inputs, Get_CurrencyWarehouse_Admin.Outputs> _Get_CurrencyWarehouse_Admin;
        private readonly DP.DapperORM.BaseSP<Delete_CurrencyWarehouse.Inputs, Delete_CurrencyWarehouse.Outputs> _Delete_CurrencyWarehouse;
        private readonly DP.DapperORM.BaseSP<Insert_CurrencyWarehouseByAdmin.Inputs, Insert_CurrencyWarehouseByAdmin.Outputs> _Insert_CurrencyWarehouseByAdmin;
        private readonly DP.DapperORM.BaseSP<Update_CurrencyWarehouseByAdmin.Inputs, Update_CurrencyWarehouseByAdmin.Outputs> _Update_CurrencyWarehouseByAdmin;
        private readonly DP.DapperORM.BaseSP<Conversion_CurrencyWarehouseByAdmin.Inputs, Conversion_CurrencyWarehouseByAdmin.Outputs> _Conversion_CurrencyWarehouseByAdmin;
        private readonly DP.DapperORM.BaseSP<Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin.Inputs, Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin.Outputs> _Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin;
        private readonly DP.DapperORM.BaseSP<Clear_CurrencyWarehouse.Inputs, Clear_CurrencyWarehouse.Outputs> _Clear_CurrencyWarehouse;
        private readonly DP.DapperORM.BaseSP<Clear_CurrencyWarehouseToman.Inputs, Clear_CurrencyWarehouseToman.Outputs> _Clear_CurrencyWarehouseToman;
        private readonly DP.DapperORM.BaseSP<Get_CurrencyWarehouse_Search.Inputs, Get_CurrencyWarehouse_Search.Outputs> _Get_CurrencyWarehouse_Search;
        public CurrencyWarehouseContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Get_CurrencyWarehouse_Admin = new DP.DapperORM.BaseSP<Get_CurrencyWarehouse_Admin.Inputs, Get_CurrencyWarehouse_Admin.Outputs>("Order.Get_CurrencyWarehouse_Admin", executer);
            _Delete_CurrencyWarehouse = new DP.DapperORM.BaseSP<Delete_CurrencyWarehouse.Inputs, Delete_CurrencyWarehouse.Outputs>("Order.Delete_CurrencyWarehouse", executer);
            _Insert_CurrencyWarehouseByAdmin = new DP.DapperORM.BaseSP<Insert_CurrencyWarehouseByAdmin.Inputs, Insert_CurrencyWarehouseByAdmin.Outputs>("Order.Insert_CurrencyWarehouseByAdmin", executer);
            _Update_CurrencyWarehouseByAdmin = new DP.DapperORM.BaseSP<Update_CurrencyWarehouseByAdmin.Inputs, Update_CurrencyWarehouseByAdmin.Outputs>("Order.Update_CurrencyWarehouseByAdmin", executer);
            _Conversion_CurrencyWarehouseByAdmin = new DP.DapperORM.BaseSP<Conversion_CurrencyWarehouseByAdmin.Inputs, Conversion_CurrencyWarehouseByAdmin.Outputs>("Order.Conversion_CurrencyWarehouseByAdmin", executer);
            _Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin = new DP.DapperORM.BaseSP<Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin.Inputs, Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin.Outputs>("Order.Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin", executer);
            _Clear_CurrencyWarehouse = new DP.DapperORM.BaseSP<Clear_CurrencyWarehouse.Inputs, Clear_CurrencyWarehouse.Outputs>("Order.Clear_CurrencyWarehouse", executer);
            _Clear_CurrencyWarehouseToman = new DP.DapperORM.BaseSP<Clear_CurrencyWarehouseToman.Inputs, Clear_CurrencyWarehouseToman.Outputs>("Order.Clear_CurrencyWarehouseToman", executer);
            
            _Get_CurrencyWarehouse_Search = new DP.DapperORM.BaseSP<Get_CurrencyWarehouse_Search.Inputs, Get_CurrencyWarehouse_Search.Outputs>("Order.Get_CurrencyWarehouse_Search", executer);
        }
        public async Task<DBResult<IEnumerable<Get_CurrencyWarehouse_Admin.Outputs>>> Get_CurrencyWarehouse_Admin(Get_CurrencyWarehouse_Admin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_CurrencyWarehouse_Admin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_CurrencyWarehouse_Search.Outputs>>> Get_CurrencyWarehouse_Search(Get_CurrencyWarehouse_Search.Inputs inputs, CancellationToken cancellationToken) { return await _Get_CurrencyWarehouse_Search.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CurrencyWarehouseByAdmin(Insert_CurrencyWarehouseByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyWarehouseByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_CurrencyWarehouseByAdmin(Update_CurrencyWarehouseByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Update_CurrencyWarehouseByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Conversion_CurrencyWarehouseByAdmin(Conversion_CurrencyWarehouseByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Conversion_CurrencyWarehouseByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin(Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_CurrencyWarehouse(Delete_CurrencyWarehouse.Inputs inputs, CancellationToken cancellationToken) {  return await _Delete_CurrencyWarehouse.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Clear_CurrencyWarehouse(Clear_CurrencyWarehouse.Inputs inputs, CancellationToken cancellationToken) { return await _Clear_CurrencyWarehouse.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Clear_CurrencyWarehouseToman(Clear_CurrencyWarehouseToman.Inputs inputs, CancellationToken cancellationToken) { return await _Clear_CurrencyWarehouseToman.Execute(inputs, cancellationToken); }

    }
}
