﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.Logic.Database.Order
{
    public class CurrencyWarehouseTomanContext: ICurrencyWarehouseTomanContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Get_CurrencyWarehouseToman_Admin.Inputs, Get_CurrencyWarehouseToman_Admin.Outputs> _Get_CurrencyWarehouseToman_Admin;
        private readonly DP.DapperORM.BaseSP<Delete_CurrencyWarehouseToman.Inputs, Delete_CurrencyWarehouseToman.Outputs> _Delete_CurrencyWarehouseToman;
        private readonly DP.DapperORM.BaseSP<Insert_CurrencyWarehouseTomanByAdmin.Inputs, Insert_CurrencyWarehouseTomanByAdmin.Outputs> _Insert_CurrencyWarehouseTomanByAdmin;
        private readonly DP.DapperORM.BaseSP<Update_CurrencyWarehouseTomanByAdmin.Inputs, Update_CurrencyWarehouseTomanByAdmin.Outputs> _Update_CurrencyWarehouseTomanByAdmin;
        private readonly DP.DapperORM.BaseSP<Conversion_CurrencyWarehouseTomanByAdmin.Inputs, Conversion_CurrencyWarehouseTomanByAdmin.Outputs> _Conversion_CurrencyWarehouseTomanByAdmin;
        private readonly DP.DapperORM.BaseSP<Clear_CurrencyWarehouseToman.Inputs, Clear_CurrencyWarehouseToman.Outputs> _Clear_CurrencyWarehouseToman;
        public CurrencyWarehouseTomanContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Get_CurrencyWarehouseToman_Admin = new DP.DapperORM.BaseSP<Get_CurrencyWarehouseToman_Admin.Inputs, Get_CurrencyWarehouseToman_Admin.Outputs>("Order.Get_CurrencyWarehouseToman_Admin", executer);
            _Delete_CurrencyWarehouseToman = new DP.DapperORM.BaseSP<Delete_CurrencyWarehouseToman.Inputs, Delete_CurrencyWarehouseToman.Outputs>("Order.Delete_CurrencyWarehouseToman", executer);
            _Insert_CurrencyWarehouseTomanByAdmin = new DP.DapperORM.BaseSP<Insert_CurrencyWarehouseTomanByAdmin.Inputs, Insert_CurrencyWarehouseTomanByAdmin.Outputs>("Order.Insert_CurrencyWarehouseTomanByAdmin", executer);
            _Update_CurrencyWarehouseTomanByAdmin = new DP.DapperORM.BaseSP<Update_CurrencyWarehouseTomanByAdmin.Inputs, Update_CurrencyWarehouseTomanByAdmin.Outputs>("Order.Update_CurrencyWarehouseTomanByAdmin", executer);
            _Conversion_CurrencyWarehouseTomanByAdmin = new DP.DapperORM.BaseSP<Conversion_CurrencyWarehouseTomanByAdmin.Inputs, Conversion_CurrencyWarehouseTomanByAdmin.Outputs>("Order.Conversion_CurrencyWarehouseTomanByAdmin", executer);
            _Clear_CurrencyWarehouseToman = new DP.DapperORM.BaseSP<Clear_CurrencyWarehouseToman.Inputs, Clear_CurrencyWarehouseToman.Outputs>("Order.Clear_CurrencyWarehouseToman", executer);

        }
        public async Task<DBResult<IEnumerable<Get_CurrencyWarehouseToman_Admin.Outputs>>> Get_CurrencyWarehouseToman_Admin(Get_CurrencyWarehouseToman_Admin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_CurrencyWarehouseToman_Admin.QueryPagination(inputs,cancellationToken); }
        public async Task<DBResult> Insert_CurrencyWarehouseTomanByAdmin(Insert_CurrencyWarehouseTomanByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CurrencyWarehouseTomanByAdmin.Execute(inputs,cancellationToken); }
        public async Task<DBResult> Update_CurrencyWarehouseTomanByAdmin(Update_CurrencyWarehouseTomanByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Update_CurrencyWarehouseTomanByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Conversion_CurrencyWarehouseTomanByAdmin(Conversion_CurrencyWarehouseTomanByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Conversion_CurrencyWarehouseTomanByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Clear_CurrencyWarehouseToman(Clear_CurrencyWarehouseToman.Inputs inputs, CancellationToken cancellationToken) { return await _Clear_CurrencyWarehouseToman.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_CurrencyWarehouseToman(Delete_CurrencyWarehouseToman.Inputs inputs,CancellationToken cancellationToken) { return await _Delete_CurrencyWarehouseToman.Execute(inputs, cancellationToken); }
    }
}
