﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order.ApplicationFee;
using Farakonesh.Models.Database.StoredProcedures.App.Order.FreeOrder;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class FreeOrderContext: IFreeOrderContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_OrderFreeOrderByAdmin.Inputs, Insert_OrderFreeOrderByAdmin.Outputs> _Insert_OrderFreeOrderByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderFreeOrderByCustomer.Inputs, Insert_OrderFreeOrderByCustomer.Outputs> _Insert_OrderFreeOrderByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderFreeOrderByCompany.Inputs, Insert_OrderFreeOrderByCompany.Outputs> _Insert_OrderFreeOrderByCompany;
        private readonly DP.DapperORM.BaseSP<GetOrder_FreeOrderByAdmin.Inputs, GetOrder_FreeOrderByAdmin.Outputs> _GetOrder_FreeOrderByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_FreeOrder.Inputs, GetOrder_FreeOrder.Outputs> _GetOrder_FreeOrder;
        private readonly DP.DapperORM.BaseSP<Get_OrderFreeOrder_Price.Inputs, Get_OrderFreeOrder_Price.Outputs> _Get_OrderFreeOrder_Price;
        public FreeOrderContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Insert_OrderFreeOrderByAdmin = new DP.DapperORM.BaseSP<Insert_OrderFreeOrderByAdmin.Inputs, Insert_OrderFreeOrderByAdmin.Outputs>("Order.Insert_OrderFreeOrderByAdmin", executer);
            _Insert_OrderFreeOrderByCustomer = new DP.DapperORM.BaseSP<Insert_OrderFreeOrderByCustomer.Inputs, Insert_OrderFreeOrderByCustomer.Outputs>("Order.Insert_OrderFreeOrderByCustomer", executer);
            _Insert_OrderFreeOrderByCompany = new DP.DapperORM.BaseSP<Insert_OrderFreeOrderByCompany.Inputs, Insert_OrderFreeOrderByCompany.Outputs>("Order.Insert_OrderFreeOrderByCompany", executer);
            _GetOrder_FreeOrder = new DP.DapperORM.BaseSP<GetOrder_FreeOrder.Inputs, GetOrder_FreeOrder.Outputs>("Order.GetOrder_FreeOrder", executer);
            _GetOrder_FreeOrderByAdmin = new DP.DapperORM.BaseSP<GetOrder_FreeOrderByAdmin.Inputs, GetOrder_FreeOrderByAdmin.Outputs>("Order.GetOrder_FreeOrderByAdmin", executer);
            _Get_OrderFreeOrder_Price = new DP.DapperORM.BaseSP<Get_OrderFreeOrder_Price.Inputs, Get_OrderFreeOrder_Price.Outputs>("Order.Get_OrderFreeOrder_Price", executer);

        }
        public async Task<DBResult<IEnumerable<GetOrder_FreeOrderByAdmin.Outputs>>> GetOrder_FreeOrderByAdmin(GetOrder_FreeOrderByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_FreeOrderByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_FreeOrder.Outputs>>> GetOrder_FreeOrder(GetOrder_FreeOrder.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_FreeOrder.Query(inputs,cancellationToken); }
        public async Task<DBResult<Get_OrderFreeOrder_Price.Outputs>> Get_OrderFreeOrder_Price(Get_OrderFreeOrder_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderFreeOrder_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderFreeOrderByAdmin.Outputs>> Insert_OrderFreeOrderByAdmin(Insert_OrderFreeOrderByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderFreeOrderByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderFreeOrderByCompany.Outputs>> Insert_OrderFreeOrderByCompany(Insert_OrderFreeOrderByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderFreeOrderByCompany.Single(inputs,cancellationToken); }
        public async Task<DBResult<Insert_OrderFreeOrderByCustomer.Outputs>> Insert_OrderFreeOrderByCustomer(Insert_OrderFreeOrderByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderFreeOrderByCustomer.Single(inputs,cancellationToken); }

    }
}
