﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.GiftCard;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class GiftCardContext : IGiftCardContext
    {
        private readonly DP.DapperORM.BaseSP<Get_GiftCardReadySale_Admin.Inputs, Get_GiftCardReadySale_Admin.Outputs> _Get_GiftCardReadySale_Admin;
        private readonly DP.DapperORM.BaseSP<Insert_GiftCardReady.Inputs, Insert_GiftCardReady.Outputs> _Insert_GiftCardReady;
        private readonly DP.DapperORM.BaseSP<Update_GiftCardReady.Inputs, Update_GiftCardReady.Outputs> _Update_GiftCardReady;
        private readonly DP.DapperORM.BaseSP<Delete_GiftCardReady.Inputs, Delete_GiftCardReady.Outputs> _Delete_GiftCardReady;
        private readonly DP.DapperORM.BaseSP<GetGiftCardTypeCountryList.Inputs, GetGiftCardTypeCountryList.Outputs> _GetGiftCardTypeCountryList;
        private readonly DP.DapperORM.BaseSP<Insert_OrderGiftCardByAdmin.Inputs, Insert_OrderGiftCardByAdmin.Outputs> _Insert_OrderGiftCardByAdmin;

        private readonly DP.DapperORM.BaseSP<GetOrder_GiftCard.Inputs, GetOrder_GiftCard.Outputs> _GetOrder_GiftCard;
        private readonly DP.DapperORM.BaseSP<Insert_OrderGiftCardByCustomer.Inputs, Insert_OrderGiftCardByCustomer.Outputs> _Insert_OrderGiftCardByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderGiftCardByCompany.Inputs, Insert_OrderGiftCardByCompany.Outputs> _Insert_OrderGiftCardByCompany;
        private readonly DP.DapperORM.BaseSP<GetOrder_GiftCardByAdmin.Inputs, GetOrder_GiftCardByAdmin.Outputs> _GetOrder_GiftCardByAdmin;
        private readonly DP.DapperORM.BaseSP<Get_OrderGiftCard_Price.Inputs, Get_OrderGiftCard_Price.Outputs> _Get_OrderGiftCard_Price;
        private readonly DP.DapperORM.BaseSP<Delete_GiftCardType.Inputs, Delete_GiftCardType.Outputs> _Delete_GiftCardType;
        private readonly DP.DapperORM.BaseSP<InsertGiftCardType.Inputs, InsertGiftCardType.Outputs> _InsertGiftCardType;
        private readonly DP.DapperORM.BaseSP<UpdateGiftCardType.Inputs, UpdateGiftCardType.Outputs> _UpdateGiftCardType;
        private readonly DP.DapperORM.BaseSP<GetGiftCardTypeListByAdmin.Inputs, GetGiftCardTypeListByAdmin.Outputs> _GetGiftCardTypeListByAdmin;
        private readonly DP.DapperORM.BaseSP<GetGiftCardTypeById.Inputs, GetGiftCardTypeById.Outputs> _GetGiftCardTypeById;
        private readonly DP.DapperORM.BaseSP<GetGiftCardTypeList.Inputs, GetGiftCardTypeList.Outputs> _GetGiftCardTypeList;
        private readonly DP.DapperORM.BaseSP<GiftCardReady_Spend.Inputs, GiftCardReady_Spend.Outputs> _GiftCardReady_Spend;
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        public GiftCardContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Get_GiftCardReadySale_Admin = new DP.DapperORM.BaseSP<Get_GiftCardReadySale_Admin.Inputs, Get_GiftCardReadySale_Admin.Outputs>("Order.Get_GiftCardReadySale_Admin", executer);
            _Delete_GiftCardReady = new DP.DapperORM.BaseSP<Delete_GiftCardReady.Inputs, Delete_GiftCardReady.Outputs>("Order.Delete_GiftCardReady", executer);
            _Insert_GiftCardReady = new DP.DapperORM.BaseSP<Insert_GiftCardReady.Inputs, Insert_GiftCardReady.Outputs>("Order.Insert_GiftCardReady", executer);
            _Update_GiftCardReady = new DP.DapperORM.BaseSP<Update_GiftCardReady.Inputs, Update_GiftCardReady.Outputs>("Order.Update_GiftCardReady", executer);
            _GetGiftCardTypeCountryList = new DP.DapperORM.BaseSP<GetGiftCardTypeCountryList.Inputs, GetGiftCardTypeCountryList.Outputs>("Order.GetGiftCardTypeCountryList", executer);
            _Insert_OrderGiftCardByAdmin = new DP.DapperORM.BaseSP<Insert_OrderGiftCardByAdmin.Inputs, Insert_OrderGiftCardByAdmin.Outputs>("Order.Insert_OrderGiftCardByAdmin", executer);

            _Insert_OrderGiftCardByCustomer = new DP.DapperORM.BaseSP<Insert_OrderGiftCardByCustomer.Inputs, Insert_OrderGiftCardByCustomer.Outputs>("Order.Insert_OrderGiftCardByCustomer", executer);
            _Insert_OrderGiftCardByCompany = new DP.DapperORM.BaseSP<Insert_OrderGiftCardByCompany.Inputs, Insert_OrderGiftCardByCompany.Outputs>("Order.Insert_OrderGiftCardByCompany", executer);
            _GetOrder_GiftCard = new DP.DapperORM.BaseSP<GetOrder_GiftCard.Inputs, GetOrder_GiftCard.Outputs>("Order.GetOrder_GiftCard", executer);
            _GetOrder_GiftCardByAdmin = new DP.DapperORM.BaseSP<GetOrder_GiftCardByAdmin.Inputs, GetOrder_GiftCardByAdmin.Outputs>("Order.GetOrder_GiftCardByAdmin", executer);
            _Get_OrderGiftCard_Price = new DP.DapperORM.BaseSP<Get_OrderGiftCard_Price.Inputs, Get_OrderGiftCard_Price.Outputs>("Order.Get_OrderGiftCard_Price", executer);
            _GetGiftCardTypeList = new DP.DapperORM.BaseSP<GetGiftCardTypeList.Inputs, GetGiftCardTypeList.Outputs>("Order.GetGiftCardTypeList", executer);
            _Delete_GiftCardType = new DP.DapperORM.BaseSP<Delete_GiftCardType.Inputs, Delete_GiftCardType.Outputs>("Order.Delete_GiftCardType", executer);
            _InsertGiftCardType = new DP.DapperORM.BaseSP<InsertGiftCardType.Inputs, InsertGiftCardType.Outputs>("Order.InsertGiftCardType", executer);
            _UpdateGiftCardType = new DP.DapperORM.BaseSP<UpdateGiftCardType.Inputs, UpdateGiftCardType.Outputs>("Order.UpdateGiftCardType", executer);
            _GetGiftCardTypeListByAdmin = new DP.DapperORM.BaseSP<GetGiftCardTypeListByAdmin.Inputs, GetGiftCardTypeListByAdmin.Outputs>("Order.GetGiftCardTypeListByAdmin", executer);
            _GetGiftCardTypeById = new DP.DapperORM.BaseSP<GetGiftCardTypeById.Inputs, GetGiftCardTypeById.Outputs>("Order.GetGiftCardTypeById", executer);
            _GiftCardReady_Spend = new DP.DapperORM.BaseSP<GiftCardReady_Spend.Inputs, GiftCardReady_Spend.Outputs>("Order.GiftCardReady_Spend", executer);
        }

        public async Task<DBResult<IEnumerable<Get_GiftCardReadySale_Admin.Outputs>>> Get_GiftCardReadySale_Admin(Get_GiftCardReadySale_Admin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_GiftCardReadySale_Admin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_GiftCardReady(Insert_GiftCardReady.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_GiftCardReady.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_GiftCardReady(Update_GiftCardReady.Inputs inputs, CancellationToken cancellationToken) { return await _Update_GiftCardReady.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_GiftCardReady(Delete_GiftCardReady.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_GiftCardReady.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetGiftCardTypeCountryList.Outputs>>> GetGiftCardTypeCountryList(GetGiftCardTypeCountryList.Inputs inputs, CancellationToken cancellationToken) { return await _GetGiftCardTypeCountryList.Query(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderGiftCardByAdmin.Outputs>> Insert_OrderGiftCardByAdmin(Insert_OrderGiftCardByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderGiftCardByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderGiftCardByCustomer.Outputs>> Insert_OrderGiftCardByCustomer(Insert_OrderGiftCardByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderGiftCardByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderGiftCardByCompany.Outputs>> Insert_OrderGiftCardByCompany(Insert_OrderGiftCardByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderGiftCardByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_GiftCard.Outputs>>> GetOrder_GiftCard(GetOrder_GiftCard.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_GiftCard.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_GiftCardByAdmin.Outputs>>> GetOrder_GiftCardByAdmin(GetOrder_GiftCardByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_GiftCardByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderGiftCard_Price.Outputs>> Get_OrderGiftCard_Price(Get_OrderGiftCard_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderGiftCard_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetGiftCardTypeList.Outputs>>> GetGiftCardTypeList(GetGiftCardTypeList.Inputs inputs, CancellationToken cancellationToken) { return await _GetGiftCardTypeList.Query(inputs, cancellationToken); }
        public async Task<DBResult> Delete_GiftCardType(Delete_GiftCardType.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_GiftCardType.Execute(inputs, cancellationToken); }
        public async Task<DBResult> InsertGiftCardType(InsertGiftCardType.Inputs inputs, CancellationToken cancellationToken) { return await _InsertGiftCardType.Execute(inputs, cancellationToken); }
        public async Task<DBResult> UpdateGiftCardType(UpdateGiftCardType.Inputs inputs, CancellationToken cancellationToken) { return await _UpdateGiftCardType.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetGiftCardTypeListByAdmin.Outputs>>> GetGiftCardTypeListByAdmin(GetGiftCardTypeListByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetGiftCardTypeListByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetGiftCardTypeById.Outputs>>> GetGiftCardTypeById(GetGiftCardTypeById.Inputs inputs, CancellationToken cancellationToken) { return await _GetGiftCardTypeById.Query(inputs, cancellationToken); }
        public async Task<DBResult<GiftCardReady_Spend.Outputs>> GiftCardReady_Spend(GiftCardReady_Spend.Inputs inputs,CancellationToken cancellationToken) { return await _GiftCardReady_Spend.Single(inputs, cancellationToken); }
    }
}
