﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order.IncomeCashExchange;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class IncomeCashExchangeContext: IIncomeCashExchangeContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_OrderIncomeCashExchangeByCustomer.Inputs, Insert_OrderIncomeCashExchangeByCustomer.Outputs> _Insert_OrderIncomeCashExchangeByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderIncomeCashExchangeByCompany.Inputs, Insert_OrderIncomeCashExchangeByCompany.Outputs> _Insert_OrderIncomeCashExchangeByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderIncomeCashExchangeByAdmin.Inputs, Insert_OrderIncomeCashExchangeByAdmin.Outputs> _Insert_OrderIncomeCashExchangeByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_IncomeCashExchange.Inputs, GetOrder_IncomeCashExchange.Outputs> _GetOrder_IncomeCashExchange;
        private readonly DP.DapperORM.BaseSP<GetOrder_IncomeCashExchangeByAdmin.Inputs, GetOrder_IncomeCashExchangeByAdmin.Outputs> _GetOrder_IncomeCashExchangeByAdmin;
        private readonly DP.DapperORM.BaseSP<Get_OrderIncomeCashExchange_Price.Inputs, Get_OrderIncomeCashExchange_Price.Outputs> _Get_OrderIncomeCashExchange_Price;
        private readonly DP.DapperORM.BaseSP<Get_OrderIncomeCashExchange_Price_Servant.Inputs, Get_OrderIncomeCashExchange_Price_Servant.Outputs> _Get_OrderIncomeCashExchange_Price_Servant;
        public IncomeCashExchangeContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetOrder_IncomeCashExchangeByAdmin = new DP.DapperORM.BaseSP<GetOrder_IncomeCashExchangeByAdmin.Inputs, GetOrder_IncomeCashExchangeByAdmin.Outputs>("Order.GetOrder_IncomeCashExchangeByAdmin", executer);
            _GetOrder_IncomeCashExchange = new DP.DapperORM.BaseSP<GetOrder_IncomeCashExchange.Inputs, GetOrder_IncomeCashExchange.Outputs>("Order.GetOrder_IncomeCashExchange", executer);
            _Get_OrderIncomeCashExchange_Price = new DP.DapperORM.BaseSP<Get_OrderIncomeCashExchange_Price.Inputs, Get_OrderIncomeCashExchange_Price.Outputs>("Order.Get_OrderIncomeCashExchange_Price", executer);
            _Get_OrderIncomeCashExchange_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderIncomeCashExchange_Price_Servant.Inputs, Get_OrderIncomeCashExchange_Price_Servant.Outputs>("Order.Get_OrderIncomeCashExchange_Price_Servant", executer);
            _Insert_OrderIncomeCashExchangeByCustomer = new DP.DapperORM.BaseSP<Insert_OrderIncomeCashExchangeByCustomer.Inputs, Insert_OrderIncomeCashExchangeByCustomer.Outputs>("Order.Insert_OrderIncomeCashExchangeByCustomer", executer);
            _Insert_OrderIncomeCashExchangeByCompany = new DP.DapperORM.BaseSP<Insert_OrderIncomeCashExchangeByCompany.Inputs, Insert_OrderIncomeCashExchangeByCompany.Outputs>("Order.Insert_OrderIncomeCashExchangeByCompany", executer);
            _Insert_OrderIncomeCashExchangeByAdmin = new DP.DapperORM.BaseSP<Insert_OrderIncomeCashExchangeByAdmin.Inputs, Insert_OrderIncomeCashExchangeByAdmin.Outputs>("Order.Insert_OrderIncomeCashExchangeByAdmin", executer);

        }
        public async Task<DBResult<Insert_OrderIncomeCashExchangeByCustomer.Outputs>> Insert_OrderIncomeCashExchangeByCustomer(Insert_OrderIncomeCashExchangeByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderIncomeCashExchangeByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderIncomeCashExchangeByCompany.Outputs>> Insert_OrderIncomeCashExchangeByCompany(Insert_OrderIncomeCashExchangeByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderIncomeCashExchangeByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderIncomeCashExchangeByAdmin.Outputs>> Insert_OrderIncomeCashExchangeByAdmin(Insert_OrderIncomeCashExchangeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderIncomeCashExchangeByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_IncomeCashExchangeByAdmin.Outputs>>> GetOrder_IncomeCashExchangeByAdmin(GetOrder_IncomeCashExchangeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_IncomeCashExchangeByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_IncomeCashExchange.Outputs>>> GetOrder_IncomeCashExchange(GetOrder_IncomeCashExchange.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_IncomeCashExchange.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderIncomeCashExchange_Price.Outputs>> Get_OrderIncomeCashExchange_Price(Get_OrderIncomeCashExchange_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderIncomeCashExchange_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderIncomeCashExchange_Price_Servant.Outputs>> Get_OrderIncomeCashExchange_Price_Servant(Get_OrderIncomeCashExchange_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderIncomeCashExchange_Price_Servant.Single(inputs, cancellationToken); }
    }
}
