﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order.GiftCard;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Notes;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class NoteContext : INoteContext
    {
        #region properties
        private string _connectionString { get; set; }

       
        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_Note.Inputs, Insert_Note.Outputs> _Insert_Note;
        private readonly DP.DapperORM.BaseSP<Update_Note.Inputs, Update_Note.Outputs> _Update_Note;
        private readonly DP.DapperORM.BaseSP<GetNotes.Inputs, GetNotes.Outputs> _GetNotes;
        private readonly DP.DapperORM.BaseSP<Delete_Note.Inputs, Delete_Note.Outputs> _Delete_Note;
        public NoteContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Insert_Note = new DP.DapperORM.BaseSP<Insert_Note.Inputs, Insert_Note.Outputs>("Order.Insert_Note", executer);
            _Update_Note = new DP.DapperORM.BaseSP<Update_Note.Inputs, Update_Note.Outputs>("Order.Update_Note", executer);
            _GetNotes = new DP.DapperORM.BaseSP<GetNotes.Inputs, GetNotes.Outputs>("Order.GetNotes", executer);
            _Delete_Note = new DP.DapperORM.BaseSP<Delete_Note.Inputs, Delete_Note.Outputs>("Order.Delete_Note", executer);

        }
        public async Task<DBResult> Insert_Note(Insert_Note.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Note.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Note(Update_Note.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Note.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetNotes.Outputs>>> GetNotes(GetNotes.Inputs inputs, CancellationToken cancellationToken) { return await _GetNotes.QueryPagination(inputs, cancellationToken); }

        public async Task<DBResult> Delete_Note(Delete_Note.Inputs inputs, CancellationToken cancellationToken) {return await _Delete_Note.Execute(inputs, cancellationToken); }

    }
}
