﻿using Dapper;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using Farakonesh.DP.DapperORM;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Database.dbo;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database
{
    public class OrderContext : IOrderContext
    {
        private readonly BaseSP<Get_Discount_OrderType_Servant.Inputs, Get_Discount_OrderType_Servant.Outputs> _Get_Discount_OrderType_Servant;
        private readonly BaseSP<Show_Order_Company_Commission.Inputs, Show_Order_Company_Commission.Outputs> _Show_Order_Company_Commission;
        private readonly BaseSP<Update_Wallet_Company_ByCommission.Inputs, Update_Wallet_Company_ByCommission.Outputs> _Update_Wallet_Company_ByCommission;
        private readonly BaseSP<Update_Order_Status.Inputs, Update_Order_Status.Outputs> _Update_Order_Status;
        private readonly DP.DapperORM.BaseSP<Update_Order_Status_ExpireDate_Cancel.Inputs, Update_Order_Status_ExpireDate_Cancel.Outputs> _Update_Order_Status_ExpireDate_Cancel;
        private readonly DP.DapperORM.BaseSP<Update_Order_Status_WithouToken.Inputs, Update_Order_Status_WithouToken.Outputs> _Update_Order_Status_WithouToken;
        private readonly DP.DapperORM.BaseSP<Update_Order_Status_ByAdmin.Inputs, Update_Order_Status_ByAdmin.Outputs> _Update_Order_Status_ByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrderById.Inputs, GetOrderById.Outputs> _GetOrderById;
        private readonly DP.DapperORM.BaseSP<GetOrderById_Print.Inputs, GetOrderById_Print.Outputs> _GetOrderById_Print;
        private readonly DP.DapperORM.BaseSP<GetOrders.Inputs, GetOrders.Outputs> _GetOrders;
        private readonly DP.DapperORM.BaseSP<GetOrdersAdmin.Inputs, GetOrdersAdmin.Outputs> _GetOrdersAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrdersAdmin_Export.Inputs, GetOrdersAdmin_Export.Outputs> _GetOrdersAdmin_Export;
        private readonly DP.DapperORM.BaseSP<GetOrdersCompeletedAdmin_Export.Inputs, GetOrdersCompeletedAdmin_Export.Outputs> _GetOrdersCompeletedAdmin_Export;
        private readonly DP.DapperORM.BaseSP<GetOrdersCompeletedAdmin.Inputs, GetOrdersCompeletedAdmin.Outputs> _GetOrdersCompeletedAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrdersAdminById.Inputs, GetOrdersAdminById.Outputs> _GetOrdersAdminById;


        private readonly DP.DapperORM.BaseSP<GetHistoryOrder.Inputs, GetHistoryOrder.Outputs> _GetHistoryOrder;
        private readonly DP.DapperORM.BaseSP<GetOrders_Search.Inputs, GetOrders_Search.Outputs> _GetOrders_Search;

        private readonly DP.DapperORM.BaseSP<GetOrderDocuments.Inputs, GetOrderDocuments.Outputs> _GetOrderDocuments;
        private readonly DP.DapperORM.BaseSP<GetOrderDocumentsAdmin.Inputs, GetOrderDocumentsAdmin.Outputs> _GetOrderDocumentsAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderDocumentsByCustomer.Inputs, Insert_OrderDocumentsByCustomer.Outputs> _Insert_OrderDocumentsByCustomer;



        private readonly DP.DapperORM.BaseSP<Update_Order_Finance.Inputs, Update_Order_Finance.Outputs> _Update_Order_Finance;
        private readonly DP.DapperORM.BaseSP<Update_Order.Inputs, Update_Order.Outputs> _Update_Order;
        private readonly DP.DapperORM.BaseSP<GetOrdersCompeletedAdmin_Financial.Inputs, GetOrdersCompeletedAdmin_Financial.Outputs> _GetOrdersCompeletedAdmin_Financial;
        private readonly BaseSP<GetOrdersCompeletedAdmin_Financial_Sell.Inputs, GetOrdersCompeletedAdmin_Financial_Sell.Outputs> _GetOrdersCompeletedAdmin_Financial_Sell;
        private readonly DP.DapperORM.BaseSP<GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse.Inputs, GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse.Outputs> _GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse;
        private readonly BaseSP<GetCurrencyWareHouse_FinancialByOrder.Inputs, GetCurrencyWareHouse_FinancialByOrder.Outputs> _GetCurrencyWareHouse_FinancialByOrder;
        private readonly BaseSP<GetCurrencyWareHouse_FinancialByOrder_Sum.Inputs, GetCurrencyWareHouse_FinancialByOrder_Sum.Outputs> _GetCurrencyWareHouse_FinancialByOrder_Sum;
        private readonly DP.DapperORM.BaseSP<GetStatus_Step_Order.Inputs, GetStatus_Step_Order.Outputs> _GetStatus_Step_Order;



        private readonly BaseSP<Update_Order_Receipt.Inputs, Update_Order_Receipt.Outputs> _Update_Order_Receipt;

        private readonly BaseSP<Delete_Order.Inputs, Delete_Order.Outputs> _Delete_Order;
        private readonly BaseSP<GetOrderByIdWithoutToken.Inputs, GetOrderByIdWithoutToken.Outputs> _GetOrderByIdWithoutToken;
        private readonly BaseSP<GetFullOrder.Inputs, GetFullOrder.Outputs> _GetFullOrder;

        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        public OrderContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Get_Discount_OrderType_Servant = new DP.DapperORM.BaseSP<Get_Discount_OrderType_Servant.Inputs, Get_Discount_OrderType_Servant.Outputs>("Order.Get_Discount_OrderType_Servant", executer);
            _Update_Order_Status = new DP.DapperORM.BaseSP<Update_Order_Status.Inputs, Update_Order_Status.Outputs>("Order.Update_Order_Status", executer);
            _Update_Wallet_Company_ByCommission = new DP.DapperORM.BaseSP<Update_Wallet_Company_ByCommission.Inputs, Update_Wallet_Company_ByCommission.Outputs>("Order.Update_Wallet_Company_ByCommission", executer);
            _Update_Order_Status_ExpireDate_Cancel = new DP.DapperORM.BaseSP<Update_Order_Status_ExpireDate_Cancel.Inputs, Update_Order_Status_ExpireDate_Cancel.Outputs>("Order.Update_Order_Status_ExpireDate_Cancel", executer);
            _Update_Order_Status_WithouToken = new DP.DapperORM.BaseSP<Update_Order_Status_WithouToken.Inputs, Update_Order_Status_WithouToken.Outputs>("Order.Update_Order_Status_WithouToken", executer);
            _Update_Order_Finance = new DP.DapperORM.BaseSP<Update_Order_Finance.Inputs, Update_Order_Finance.Outputs>("Order.Update_Order_Finance", executer);
            _Update_Order = new DP.DapperORM.BaseSP<Update_Order.Inputs, Update_Order.Outputs>("Order.Update_Order", executer);
            _Update_Order_Receipt = new DP.DapperORM.BaseSP<Update_Order_Receipt.Inputs, Update_Order_Receipt.Outputs>("Order.Update_Order_Receipt", executer);
            _Update_Order_Status_ByAdmin = new DP.DapperORM.BaseSP<Update_Order_Status_ByAdmin.Inputs, Update_Order_Status_ByAdmin.Outputs>("Order.Update_Order_Status_ByAdmin", executer);
            _GetHistoryOrder = new DP.DapperORM.BaseSP<GetHistoryOrder.Inputs, GetHistoryOrder.Outputs>("Order.GetHistoryOrder", executer);
            _GetOrders_Search = new DP.DapperORM.BaseSP<GetOrders_Search.Inputs, GetOrders_Search.Outputs>("Order.GetOrders_Search", executer);

            _GetOrderById = new DP.DapperORM.BaseSP<GetOrderById.Inputs, GetOrderById.Outputs>("Order.GetOrderById", executer);
            _GetOrderById_Print = new DP.DapperORM.BaseSP<GetOrderById_Print.Inputs, GetOrderById_Print.Outputs>("Order.GetOrderById_Print", executer);
            _GetOrders = new DP.DapperORM.BaseSP<GetOrders.Inputs, GetOrders.Outputs>("Order.GetOrders", executer);
            _GetOrdersCompeletedAdmin = new DP.DapperORM.BaseSP<GetOrdersCompeletedAdmin.Inputs, GetOrdersCompeletedAdmin.Outputs>("Order.GetOrdersCompeletedAdmin", executer);
            _GetOrdersAdmin = new DP.DapperORM.BaseSP<GetOrdersAdmin.Inputs, GetOrdersAdmin.Outputs>("Order.GetOrdersAdmin", executer);
            _GetOrdersAdmin_Export = new DP.DapperORM.BaseSP<GetOrdersAdmin_Export.Inputs, GetOrdersAdmin_Export.Outputs>("Order.GetOrdersAdmin_Export", executer);
            _GetOrdersCompeletedAdmin_Export = new DP.DapperORM.BaseSP<GetOrdersCompeletedAdmin_Export.Inputs, GetOrdersCompeletedAdmin_Export.Outputs>("Order.GetOrdersCompeletedAdmin_Export", executer);
            _GetOrdersAdminById = new DP.DapperORM.BaseSP<GetOrdersAdminById.Inputs, GetOrdersAdminById.Outputs>("Order.GetOrdersAdminById", executer);

            _GetOrderDocuments = new DP.DapperORM.BaseSP<GetOrderDocuments.Inputs, GetOrderDocuments.Outputs>("Order.GetOrderDocuments", executer);
            _GetOrderDocumentsAdmin = new DP.DapperORM.BaseSP<GetOrderDocumentsAdmin.Inputs, GetOrderDocumentsAdmin.Outputs>("Order.GetOrderDocumentsAdmin", executer);
            _Insert_OrderDocumentsByCustomer = new DP.DapperORM.BaseSP<Insert_OrderDocumentsByCustomer.Inputs, Insert_OrderDocumentsByCustomer.Outputs>("Order.Insert_OrderDocumentsByCustomer", executer);



            _Show_Order_Company_Commission = new BaseSP<Show_Order_Company_Commission.Inputs, Show_Order_Company_Commission.Outputs>("Order.Show_Order_Company_Commission", executer);
            _GetOrdersCompeletedAdmin_Financial = new DP.DapperORM.BaseSP<GetOrdersCompeletedAdmin_Financial.Inputs, GetOrdersCompeletedAdmin_Financial.Outputs>("Order.GetOrdersCompeletedAdmin_Financial", executer);
            _GetOrdersCompeletedAdmin_Financial_Sell = new DP.DapperORM.BaseSP<GetOrdersCompeletedAdmin_Financial_Sell.Inputs, GetOrdersCompeletedAdmin_Financial_Sell.Outputs>("Order.GetOrdersCompeletedAdmin_Financial_Sell", executer);
            _GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse = new DP.DapperORM.BaseSP<GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse.Inputs, GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse.Outputs>("Order.GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse", executer);
            _GetCurrencyWareHouse_FinancialByOrder_Sum = new BaseSP<GetCurrencyWareHouse_FinancialByOrder_Sum.Inputs, GetCurrencyWareHouse_FinancialByOrder_Sum.Outputs>("Order.GetCurrencyWareHouse_FinancialByOrder_Sum", executer);
            _GetStatus_Step_Order = new BaseSP<GetStatus_Step_Order.Inputs, GetStatus_Step_Order.Outputs>("Order.GetStatus_Step_Order", executer);

            _Delete_Order = new DP.DapperORM.BaseSP<Delete_Order.Inputs, Delete_Order.Outputs>("Order.Delete_Order", executer);
            _GetOrderByIdWithoutToken = new DP.DapperORM.BaseSP<GetOrderByIdWithoutToken.Inputs, GetOrderByIdWithoutToken.Outputs>("Order.GetOrderByIdWithoutToken", executer);
            _GetCurrencyWareHouse_FinancialByOrder = new BaseSP<GetCurrencyWareHouse_FinancialByOrder.Inputs, GetCurrencyWareHouse_FinancialByOrder.Outputs>("Order.GetCurrencyWareHouse_FinancialByOrder", executer);
            _GetFullOrder = new BaseSP<GetFullOrder.Inputs, GetFullOrder.Outputs>("Order.GetFullOrder", executer);
        }

        public async Task<DBResult<Get_Discount_OrderType_Servant.Outputs>> Get_Discount_OrderType_Servant(Get_Discount_OrderType_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Discount_OrderType_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Wallet_Company_ByCommission.Outputs>> Update_Wallet_Company_ByCommission(Update_Wallet_Company_ByCommission.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Wallet_Company_ByCommission.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Order_Status.Outputs>> Update_Order_Status(Update_Order_Status.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Order_Status.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Order_Status_WithouToken.Outputs>> Update_Order_Status_WithouToken(Update_Order_Status_WithouToken.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Order_Status_WithouToken.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Order_Status_ByAdmin.Outputs>> Update_Order_Status_ByAdmin(Update_Order_Status_ByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Order_Status_ByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Order_Status.Outputs>> Update_Order_Status_Cancel(Update_Order_Status.Inputs inputs, CancellationToken cancellationToken) { inputs.Status = 187; return await _Update_Order_Status.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Order_Status_ExpireDate_Cancel.Outputs>> Update_Order_Status_ExpireDate_Cancel(Update_Order_Status_ExpireDate_Cancel.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Order_Status_ExpireDate_Cancel.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetHistoryOrder.Outputs>>> GetHistoryOrder(GetHistoryOrder.Inputs inputs, CancellationToken cancellationToken) { return await _GetHistoryOrder.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrders_Search.Outputs>>> GetOrders_Search(GetOrders_Search.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrders_Search.QueryPagination(inputs, cancellationToken); }


        public async Task<DBResult<GetOrderById.Outputs>> GetOrderById(GetOrderById.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrderById.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetOrderById_Print.Outputs>> GetOrderById_Print(GetOrderById_Print.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrderById_Print.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetOrderByIdWithoutToken.Outputs>> GetOrderByIdWithoutToken(GetOrderByIdWithoutToken.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrderByIdWithoutToken.Single(inputs, cancellationToken); }
       
        public async Task<DBResult<IEnumerable<GetOrders.Outputs>>> GetOrders(GetOrders.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrders.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrdersAdmin.Outputs>>> GetOrdersAdmin(GetOrdersAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrdersAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrdersAdmin_Export.Outputs>>> GetOrdersAdmin_Export(GetOrdersAdmin_Export.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrdersAdmin_Export.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrdersCompeletedAdmin_Export.Outputs>>> GetOrdersCompeletedAdmin_Export(GetOrdersCompeletedAdmin_Export.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrdersCompeletedAdmin_Export.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrdersCompeletedAdmin.Outputs>>> GetOrdersCompeletedAdmin(GetOrdersCompeletedAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrdersCompeletedAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<GetOrdersAdminById.Outputs>> GetOrdersAdminById(GetOrdersAdminById.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrdersAdminById.Single(inputs, cancellationToken); }


   
        public async Task<DBResult> Insert_OrderDocumentsByCustomer(Insert_OrderDocumentsByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderDocumentsByCustomer.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrderDocumentsAdmin.Outputs>>> GetOrderDocumentsAdmin(GetOrderDocumentsAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrderDocumentsAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrderDocuments.Outputs>>> GetOrderDocuments(GetOrderDocuments.Inputs inputs, CancellationToken cancellationToken) {  return await _GetOrderDocuments.Query(inputs, cancellationToken); }



        public async Task<DBResult> Update_Order_Finance(Update_Order_Finance.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Order_Finance.Execute(inputs, cancellationToken); }

        public async Task<DBResult> Update_Order(Update_Order.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Order.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrdersCompeletedAdmin_Financial.Outputs>>> GetOrdersCompeletedAdmin_Financial(GetOrdersCompeletedAdmin_Financial.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrdersCompeletedAdmin_Financial.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse.Outputs>>> GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse(GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCurrencyWareHouse_FinancialByOrder.Outputs>>> GetCurrencyWareHouse_FinancialByOrder(GetCurrencyWareHouse_FinancialByOrder.Inputs inputs, CancellationToken cancellationToken) { return await _GetCurrencyWareHouse_FinancialByOrder.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<GetCurrencyWareHouse_FinancialByOrder_Sum.Outputs>> GetCurrencyWareHouse_FinancialByOrder_Sum(GetCurrencyWareHouse_FinancialByOrder_Sum.Inputs inputs, CancellationToken cancellationToken) { return await _GetCurrencyWareHouse_FinancialByOrder_Sum.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrdersCompeletedAdmin_Financial_Sell.Outputs>>> GetOrdersCompeletedAdmin_Financial_Sell(GetOrdersCompeletedAdmin_Financial_Sell.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrdersCompeletedAdmin_Financial_Sell.QueryPagination(inputs, cancellationToken); }

        public async Task<DBResult<IEnumerable<GetStatus_Step_Order.Outputs>>> GetStatus_Step_Order(GetStatus_Step_Order.Inputs inputs, CancellationToken cancellationToken) { return await _GetStatus_Step_Order.Query(inputs, cancellationToken); }

        public async Task<DBResult<GetFullOrder.Outputs>> GetFullOrder(GetFullOrder.Inputs inputs, CancellationToken cancellationToken) { return await _GetFullOrder.QueryMultiple(inputs, cancellationToken); }

        public async Task<DBResult<Update_Order_Receipt.Outputs>> Update_Order_Receipt(Update_Order_Receipt.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Order_Receipt.Single(inputs, cancellationToken); }


        public async Task<DBResult> Delete_Order(Delete_Order.Inputs inputs, CancellationToken cancellationToken) { 
            return await _Delete_Order.Execute(inputs, cancellationToken); 
        }

        public async Task<DBResult<Show_Order_Company_Commission.Outputs>> Show_Order_Company_Commission(Show_Order_Company_Commission.Inputs inputs, CancellationToken cancellationToken) { return await _Show_Order_Company_Commission.Single(inputs, cancellationToken); }
    }
}
