﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.ApplicationFee;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Paypal;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class PayeerContext : IPayeerContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_OrderPayeerSellByCustomer.Inputs, Insert_OrderPayeerSellByCustomer.Outputs> _Insert_OrderPayeerSellByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPayeerSellByCompany.Inputs, Insert_OrderPayeerSellByCompany.Outputs> _Insert_OrderPayeerSellByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPayeerSellByAdmin.Inputs, Insert_OrderPayeerSellByAdmin.Outputs> _Insert_OrderPayeerSellByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPayerAccountChargeByAdmin.Inputs, Insert_OrderPayerAccountChargeByAdmin.Outputs> _Insert_OrderPayerAccountChargeByAdmin;
        private readonly DP.DapperORM.BaseSP<Update_OrderPayeerSellByCustomer.Inputs, Update_OrderPayeerSellByCustomer.Outputs> _Update_OrderPayeerSellByCustomer;
        private readonly DP.DapperORM.BaseSP<Update_OrderPayeerChargeByCustomer.Inputs, Update_OrderPayeerChargeByCustomer.Outputs> _Update_OrderPayeerChargeByCustomer;
        private readonly DP.DapperORM.BaseSP<GetOrder_PayeerSellByAdmin.Inputs, GetOrder_PayeerSellByAdmin.Outputs> _GetOrder_PayeerSellByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_PayeerSell.Inputs, GetOrder_PayeerSell.Outputs> _GetOrder_PayeerSell;
        private readonly DP.DapperORM.BaseSP<GetOrder_PayeerSellAnonymous.Inputs, GetOrder_PayeerSellAnonymous.Outputs> _GetOrder_PayeerSellAnonymous;
        private readonly DP.DapperORM.BaseSP<Get_OrderPayeerSell_Price.Inputs, Get_OrderPayeerSell_Price.Outputs> _Get_OrderPayeerSell_Price;
        private readonly DP.DapperORM.BaseSP<Get_OrderPayeerSell_Price_Servant.Inputs, Get_OrderPayeerSell_Price_Servant.Outputs> _Get_OrderPayeerSell_Price_Servant;
        private readonly DP.DapperORM.BaseSP<Get_OrderPayerAccountCharge_Price_Servant.Inputs, Get_OrderPayerAccountCharge_Price_Servant.Outputs> _Get_OrderPayerAccountCharge_Price_Servant;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPayerAccountChargeByCustomer.Inputs, Insert_OrderPayerAccountChargeByCustomer.Outputs> _Insert_OrderPayerAccountChargeByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPayerAccountChargeByCompany.Inputs, Insert_OrderPayerAccountChargeByCompany.Outputs> _Insert_OrderPayerAccountChargeByCompany;
        private readonly DP.DapperORM.BaseSP<Get_OrderPayerAccountCharge_Price.Inputs, Get_OrderPayerAccountCharge_Price.Outputs> _Get_OrderPayerAccountCharge_Price;
        private readonly DP.DapperORM.BaseSP<GetOrder_PayerAccountCharge.Inputs, GetOrder_PayerAccountCharge.Outputs> _GetOrder_PayerAccountCharge;
        private readonly DP.DapperORM.BaseSP<GetOrder_PayerAccountChargeByAdmin.Inputs, GetOrder_PayerAccountChargeByAdmin.Outputs> _GetOrder_PayerAccountChargeByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_PayerAccountChargeAnonymous.Inputs, GetOrder_PayerAccountChargeAnonymous.Outputs> _GetOrder_PayerAccountChargeAnonymous;
        public PayeerContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetOrder_PayeerSellAnonymous = new DP.DapperORM.BaseSP<GetOrder_PayeerSellAnonymous.Inputs, GetOrder_PayeerSellAnonymous.Outputs>("Order.GetOrder_PayeerSellAnonymous", executer);
            _GetOrder_PayeerSellByAdmin = new DP.DapperORM.BaseSP<GetOrder_PayeerSellByAdmin.Inputs, GetOrder_PayeerSellByAdmin.Outputs>("Order.GetOrder_PayeerSellByAdmin", executer);
            _GetOrder_PayeerSell = new DP.DapperORM.BaseSP<GetOrder_PayeerSell.Inputs, GetOrder_PayeerSell.Outputs>("Order.GetOrder_PayeerSell", executer);
            _Get_OrderPayeerSell_Price = new DP.DapperORM.BaseSP<Get_OrderPayeerSell_Price.Inputs, Get_OrderPayeerSell_Price.Outputs>("Order.Get_OrderPayeerSell_Price", executer);
            _Get_OrderPayeerSell_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderPayeerSell_Price_Servant.Inputs, Get_OrderPayeerSell_Price_Servant.Outputs>("Order.Get_OrderPayeerSell_Price_Servant", executer);
            _Get_OrderPayerAccountCharge_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderPayerAccountCharge_Price_Servant.Inputs, Get_OrderPayerAccountCharge_Price_Servant.Outputs>("Order.Get_OrderPayerAccountCharge_Price_Servant", executer);
            _Insert_OrderPayeerSellByCustomer = new DP.DapperORM.BaseSP<Insert_OrderPayeerSellByCustomer.Inputs, Insert_OrderPayeerSellByCustomer.Outputs>("Order.Insert_OrderPayeerSellByCustomer", executer);
            _Insert_OrderPayeerSellByCompany = new DP.DapperORM.BaseSP<Insert_OrderPayeerSellByCompany.Inputs, Insert_OrderPayeerSellByCompany.Outputs>("Order.Insert_OrderPayeerSellByCompany", executer);
            _Insert_OrderPayeerSellByAdmin = new DP.DapperORM.BaseSP<Insert_OrderPayeerSellByAdmin.Inputs, Insert_OrderPayeerSellByAdmin.Outputs>("Order.Insert_OrderPayeerSellByAdmin", executer);
            _Insert_OrderPayerAccountChargeByAdmin = new DP.DapperORM.BaseSP<Insert_OrderPayerAccountChargeByAdmin.Inputs, Insert_OrderPayerAccountChargeByAdmin.Outputs>("Order.Insert_OrderPayerAccountChargeByAdmin", executer);
            _Update_OrderPayeerSellByCustomer = new DP.DapperORM.BaseSP<Update_OrderPayeerSellByCustomer.Inputs, Update_OrderPayeerSellByCustomer.Outputs>("Order.Update_OrderPayeerSellByCustomer", executer);
            _Update_OrderPayeerChargeByCustomer = new DP.DapperORM.BaseSP<Update_OrderPayeerChargeByCustomer.Inputs, Update_OrderPayeerChargeByCustomer.Outputs>("Order.Update_OrderPayeerChargeByCustomer", executer);
            _Insert_OrderPayerAccountChargeByCustomer = new DP.DapperORM.BaseSP<Insert_OrderPayerAccountChargeByCustomer.Inputs, Insert_OrderPayerAccountChargeByCustomer.Outputs>("Order.Insert_OrderPayerAccountChargeByCustomer", executer);
            _Insert_OrderPayerAccountChargeByCompany = new DP.DapperORM.BaseSP<Insert_OrderPayerAccountChargeByCompany.Inputs, Insert_OrderPayerAccountChargeByCompany.Outputs>("Order.Insert_OrderPayerAccountChargeByCompany", executer);
            _Get_OrderPayerAccountCharge_Price = new DP.DapperORM.BaseSP<Get_OrderPayerAccountCharge_Price.Inputs, Get_OrderPayerAccountCharge_Price.Outputs>("Order.Get_OrderPayerAccountCharge_Price", executer);
            _GetOrder_PayerAccountCharge = new DP.DapperORM.BaseSP<GetOrder_PayerAccountCharge.Inputs, GetOrder_PayerAccountCharge.Outputs>("Order.GetOrder_PayerAccountCharge", executer);
            _GetOrder_PayerAccountChargeAnonymous = new DP.DapperORM.BaseSP<GetOrder_PayerAccountChargeAnonymous.Inputs, GetOrder_PayerAccountChargeAnonymous.Outputs>("Order.GetOrder_PayerAccountChargeAnonymous", executer);
            _GetOrder_PayerAccountChargeByAdmin = new DP.DapperORM.BaseSP<GetOrder_PayerAccountChargeByAdmin.Inputs, GetOrder_PayerAccountChargeByAdmin.Outputs>("Order.GetOrder_PayerAccountChargeByAdmin", executer);

        }
        public async Task<DBResult<Insert_OrderPayeerSellByCustomer.Outputs>> Insert_OrderPayeerSellByCustomer(Insert_OrderPayeerSellByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPayeerSellByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPayeerSellByCompany.Outputs>> Insert_OrderPayeerSellByCompany(Insert_OrderPayeerSellByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPayeerSellByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPayeerSellByAdmin.Outputs>> Insert_OrderPayeerSellByAdmin(Insert_OrderPayeerSellByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPayeerSellByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPayerAccountChargeByAdmin.Outputs>> Insert_OrderPayerAccountChargeByAdmin(Insert_OrderPayerAccountChargeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPayerAccountChargeByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PayeerSellByAdmin.Outputs>>> GetOrder_PayeerSellByAdmin(GetOrder_PayeerSellByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PayeerSellByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PayeerSell.Outputs>>> GetOrder_PayeerSell(GetOrder_PayeerSell.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PayeerSell.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPayeerSell_Price.Outputs>> Get_OrderPayeerSell_Price(Get_OrderPayeerSell_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPayeerSell_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPayeerSell_Price_Servant.Outputs>> Get_OrderPayeerSell_Price_Servant(Get_OrderPayeerSell_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPayeerSell_Price_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPayerAccountCharge_Price_Servant.Outputs>> Get_OrderPayerAccountCharge_Price_Servant(Get_OrderPayerAccountCharge_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPayerAccountCharge_Price_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetOrder_PayeerSellAnonymous.Outputs>> GetOrder_PayeerSellAnonymous(GetOrder_PayeerSellAnonymous.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PayeerSellAnonymous.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_OrderPayeerSellByCustomer.Outputs>> Update_OrderPayeerSellByCustomer(Update_OrderPayeerSellByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Update_OrderPayeerSellByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_OrderPayeerChargeByCustomer.Outputs>> Update_OrderPayeerChargeByCustomer(Update_OrderPayeerChargeByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Update_OrderPayeerChargeByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPayerAccountChargeByCustomer.Outputs>> Insert_OrderPayerAccountChargeByCustomer(Insert_OrderPayerAccountChargeByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPayerAccountChargeByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPayerAccountChargeByCompany.Outputs>> Insert_OrderPayerAccountChargeByCompany(Insert_OrderPayerAccountChargeByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPayerAccountChargeByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PayerAccountCharge.Outputs>>> GetOrder_PayerAccountCharge(GetOrder_PayerAccountCharge.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PayerAccountCharge.Query(inputs, cancellationToken); }
        public async Task<DBResult<GetOrder_PayerAccountChargeAnonymous.Outputs>> GetOrder_PayerAccountChargeAnonymous(GetOrder_PayerAccountChargeAnonymous.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PayerAccountChargeAnonymous.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PayerAccountChargeByAdmin.Outputs>>> GetOrder_PayerAccountChargeByAdmin(GetOrder_PayerAccountChargeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PayerAccountChargeByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPayerAccountCharge_Price.Outputs>> Get_OrderPayerAccountCharge_Price(Get_OrderPayerAccountCharge_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPayerAccountCharge_Price.Single(inputs, cancellationToken); }

    }
}
