﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.Services.App;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PaymentInternationalSites;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class PaymentInternationalSitesContext: IPaymentInternationalSitesContext
    {
        #region properties
        private string _connectionString { get; set; }
        private readonly IFileService _fileServices;
        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_OrderPaymentInternationalSitesByCustomer.Inputs, Insert_OrderPaymentInternationalSitesByCustomer.Outputs> _Insert_OrderPaymentInternationalSitesByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPaymentInternationalSitesByCompany.Inputs, Insert_OrderPaymentInternationalSitesByCompany.Outputs> _Insert_OrderPaymentInternationalSitesByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPaymentInternationalSitesByAdmin.Inputs, Insert_OrderPaymentInternationalSitesByAdmin.Outputs> _Insert_OrderPaymentInternationalSitesByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_PaymentInternationalSites.Inputs, GetOrder_PaymentInternationalSites.Outputs> _GetOrder_PaymentInternationalSites;
        private readonly DP.DapperORM.BaseSP<GetOrder_PaymentInternationalSitesByAdmin.Inputs, GetOrder_PaymentInternationalSitesByAdmin.Outputs> _GetOrder_PaymentInternationalSitesByAdmin;
        private readonly DP.DapperORM.BaseSP<Get_OrderPaymentInternationalSites_Price.Inputs, Get_OrderPaymentInternationalSites_Price.Outputs> _Get_OrderPaymentInternationalSites_Price;
        private readonly DP.DapperORM.BaseSP<Get_OrderPaymentInternationalSites_Price_Servant.Inputs, Get_OrderPaymentInternationalSites_Price_Servant.Outputs> _Get_OrderPaymentInternationalSites_Price_Servant;

        public PaymentInternationalSitesContext(IConfiguration configuration, IFileService fileServices)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _fileServices = fileServices;

            _Insert_OrderPaymentInternationalSitesByCustomer = new DP.DapperORM.BaseSP<Insert_OrderPaymentInternationalSitesByCustomer.Inputs, Insert_OrderPaymentInternationalSitesByCustomer.Outputs>("Order.Insert_OrderPaymentInternationalSitesByCustomer", executer);
            _Insert_OrderPaymentInternationalSitesByCompany = new DP.DapperORM.BaseSP<Insert_OrderPaymentInternationalSitesByCompany.Inputs, Insert_OrderPaymentInternationalSitesByCompany.Outputs>("Order.Insert_OrderPaymentInternationalSitesByCompany", executer);
            _Insert_OrderPaymentInternationalSitesByAdmin = new DP.DapperORM.BaseSP<Insert_OrderPaymentInternationalSitesByAdmin.Inputs, Insert_OrderPaymentInternationalSitesByAdmin.Outputs>("Order.Insert_OrderPaymentInternationalSitesByAdmin", executer);
            _Get_OrderPaymentInternationalSites_Price = new DP.DapperORM.BaseSP<Get_OrderPaymentInternationalSites_Price.Inputs, Get_OrderPaymentInternationalSites_Price.Outputs>("Order.Get_OrderPaymentInternationalSites_Price", executer);
            _Get_OrderPaymentInternationalSites_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderPaymentInternationalSites_Price_Servant.Inputs, Get_OrderPaymentInternationalSites_Price_Servant.Outputs>("Order.Get_OrderPaymentInternationalSites_Price_Servant", executer);
            _GetOrder_PaymentInternationalSites = new DP.DapperORM.BaseSP<GetOrder_PaymentInternationalSites.Inputs, GetOrder_PaymentInternationalSites.Outputs>("Order.GetOrder_PaymentInternationalSites", executer);
            _GetOrder_PaymentInternationalSitesByAdmin = new DP.DapperORM.BaseSP<GetOrder_PaymentInternationalSitesByAdmin.Inputs, GetOrder_PaymentInternationalSitesByAdmin.Outputs>("Order.GetOrder_PaymentInternationalSitesByAdmin", executer);

        }
        public async Task<DBResult<Insert_OrderPaymentInternationalSitesByCustomer.Outputs>> Insert_OrderPaymentInternationalSitesByCustomer(Insert_OrderPaymentInternationalSitesByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaymentInternationalSitesByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPaymentInternationalSitesByCompany.Outputs>> Insert_OrderPaymentInternationalSitesByCompany(Insert_OrderPaymentInternationalSitesByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaymentInternationalSitesByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPaymentInternationalSitesByAdmin.Outputs>> Insert_OrderPaymentInternationalSitesByAdmin(Insert_OrderPaymentInternationalSitesByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaymentInternationalSitesByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PaymentInternationalSites.Outputs>>> GetOrder_PaymentInternationalSites(GetOrder_PaymentInternationalSites.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PaymentInternationalSites.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PaymentInternationalSitesByAdmin.Outputs>>> GetOrder_PaymentInternationalSitesByAdmin(GetOrder_PaymentInternationalSitesByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PaymentInternationalSitesByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPaymentInternationalSites_Price.Outputs>> Get_OrderPaymentInternationalSites_Price(Get_OrderPaymentInternationalSites_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPaymentInternationalSites_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPaymentInternationalSites_Price_Servant.Outputs>> Get_OrderPaymentInternationalSites_Price_Servant(Get_OrderPaymentInternationalSites_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPaymentInternationalSites_Price_Servant.Single(inputs, cancellationToken); }

    }
}
