﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Paypal;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PaymentLink;
using Farakonesh.Logic.IDatabase.IOrder;

namespace Farakonesh.Logic.Database.Order
{
    public class PaymentLinkContext: IPaymentLinkContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<GetPaymentLink_WithoutToken.Inputs, GetPaymentLink_WithoutToken.Outputs> _GetPaymentLink_WithoutToken;
        private readonly DP.DapperORM.BaseSP<GetPaymentLinkHistory.Inputs, GetPaymentLinkHistory.Outputs> _GetPaymentLinkHistory;
        private readonly DP.DapperORM.BaseSP<GetPaymentLink.Inputs, GetPaymentLink.Outputs> _GetPaymentLink;
        private readonly DP.DapperORM.BaseSP<Insert_PaymentLink.Inputs, Insert_PaymentLink.Outputs> _Insert_PaymentLink;
        private readonly DP.DapperORM.BaseSP<Insert_PaymentLinkHistory.Inputs, Insert_PaymentLinkHistory.Outputs> _Insert_PaymentLinkHistory;
        private readonly DP.DapperORM.BaseSP<Update_PaymentLink.Inputs, Update_PaymentLink.Outputs> _Update_PaymentLink;
        private readonly DP.DapperORM.BaseSP<Delete_PaymentLinkHistory.Inputs, Delete_PaymentLinkHistory.Outputs> _Delete_PaymentLinkHistory;
        private readonly DP.DapperORM.BaseSP<Delete_PaymentLink.Inputs, Delete_PaymentLink.Outputs> _Delete_PaymentLink;

        public PaymentLinkContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _GetPaymentLink_WithoutToken = new DP.DapperORM.BaseSP<GetPaymentLink_WithoutToken.Inputs, GetPaymentLink_WithoutToken.Outputs>("Order.GetPaymentLink_WithoutToken", executer);
            _GetPaymentLinkHistory = new DP.DapperORM.BaseSP<GetPaymentLinkHistory.Inputs, GetPaymentLinkHistory.Outputs>("Order.GetPaymentLinkHistory", executer);
            _GetPaymentLink = new DP.DapperORM.BaseSP<GetPaymentLink.Inputs, GetPaymentLink.Outputs>("Order.GetPaymentLink", executer);
            _Insert_PaymentLink = new DP.DapperORM.BaseSP<Insert_PaymentLink.Inputs, Insert_PaymentLink.Outputs>("Order.Insert_PaymentLink", executer);
            _Insert_PaymentLinkHistory = new DP.DapperORM.BaseSP<Insert_PaymentLinkHistory.Inputs, Insert_PaymentLinkHistory.Outputs>("Order.Insert_PaymentLinkHistory", executer);
            _Update_PaymentLink = new DP.DapperORM.BaseSP<Update_PaymentLink.Inputs, Update_PaymentLink.Outputs>("Order.Update_PaymentLink", executer);
            _Delete_PaymentLinkHistory = new DP.DapperORM.BaseSP<Delete_PaymentLinkHistory.Inputs, Delete_PaymentLinkHistory.Outputs>("Order.Delete_PaymentLinkHistory", executer);
            _Delete_PaymentLink = new DP.DapperORM.BaseSP<Delete_PaymentLink.Inputs, Delete_PaymentLink.Outputs>("Order.Delete_PaymentLink", executer);

        }
        public async Task<DBResult<IEnumerable<GetPaymentLink_WithoutToken.Outputs>>> GetPaymentLink_WithoutToken(GetPaymentLink_WithoutToken.Inputs inputs, CancellationToken cancellationToken) { return await _GetPaymentLink_WithoutToken.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetPaymentLinkHistory.Outputs>>> GetPaymentLinkHistory(GetPaymentLinkHistory.Inputs inputs, CancellationToken cancellationToken) { return await _GetPaymentLinkHistory.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetPaymentLink.Outputs>>> GetPaymentLink(GetPaymentLink.Inputs inputs, CancellationToken cancellationToken) { return await _GetPaymentLink.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_PaymentLink(Insert_PaymentLink.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_PaymentLink.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_PaymentLink(Update_PaymentLink.Inputs inputs, CancellationToken cancellationToken) { return await _Update_PaymentLink.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_PaymentLinkHistory(Insert_PaymentLinkHistory.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_PaymentLinkHistory.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_PaymentLinkHistory(Delete_PaymentLinkHistory.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_PaymentLinkHistory.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_PaymentLink(Delete_PaymentLink.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_PaymentLink.Execute(inputs, cancellationToken); }
     
    }
}
