﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Paypal;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class PaypalContext: IPaypalContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_OrderPaypalBuyByCustomer.Inputs, Insert_OrderPaypalBuyByCustomer.Outputs> _Insert_OrderPaypalBuyByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPaypalSellByCustomer.Inputs, Insert_OrderPaypalSellByCustomer.Outputs> _Insert_OrderPaypalSellByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPaypalChargeByCustomer.Inputs, Insert_OrderPaypalChargeByCustomer.Outputs> _Insert_OrderPaypalChargeByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPaypalChargeByCompany.Inputs, Insert_OrderPaypalChargeByCompany.Outputs> _Insert_OrderPaypalChargeByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPaypalBuyByCompany.Inputs, Insert_OrderPaypalBuyByCompany.Outputs> _Insert_OrderPaypalBuyByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPaypalSellByCompany.Inputs, Insert_OrderPaypalSellByCompany.Outputs> _Insert_OrderPaypalSellByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPaypalBuyByAdmin.Inputs, Insert_OrderPaypalBuyByAdmin.Outputs> _Insert_OrderPaypalBuyByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPaypalSellByAdmin.Inputs, Insert_OrderPaypalSellByAdmin.Outputs> _Insert_OrderPaypalSellByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPaypalChargeByAdmin.Inputs, Insert_OrderPaypalChargeByAdmin.Outputs> _Insert_OrderPaypalChargeByAdmin;

        private readonly DP.DapperORM.BaseSP<Get_OrderPaypalBuy_Price.Inputs, Get_OrderPaypalBuy_Price.Outputs> _Get_OrderPaypalBuy_Price;
        
        private readonly DP.DapperORM.BaseSP<Get_OrderPaypalBuy_Price_Servant.Inputs, Get_OrderPaypalBuy_Price_Servant.Outputs> _Get_OrderPaypalBuy_Price_Servant;
        
        private readonly DP.DapperORM.BaseSP<Get_OrderPaypalCharge_Price.Inputs, Get_OrderPaypalCharge_Price.Outputs> _Get_OrderPaypalCharge_Price;
        
        private readonly DP.DapperORM.BaseSP<Get_OrderPaypalCharge_Price_Servant.Inputs, Get_OrderPaypalCharge_Price_Servant.Outputs> _Get_OrderPaypalCharge_Price_Servant;
        
        private readonly DP.DapperORM.BaseSP<Get_OrderPaypalSell_Price.Inputs, Get_OrderPaypalSell_Price.Outputs> _Get_OrderPaypalSell_Price;
        
        private readonly DP.DapperORM.BaseSP<Get_OrderPaypalSell_Price_Servant.Inputs, Get_OrderPaypalSell_Price_Servant.Outputs> _Get_OrderPaypalSell_Price_Servant;
        
        private readonly DP.DapperORM.BaseSP<GetOrder_PaypalBuy.Inputs, GetOrder_PaypalBuy.Outputs> _GetOrder_PaypalBuy;
        
        private readonly DP.DapperORM.BaseSP<GetOrder_PaypalCharge.Inputs, GetOrder_PaypalCharge.Outputs> _GetOrder_PaypalCharge;
        
        private readonly DP.DapperORM.BaseSP<GetOrder_PaypalSell.Inputs, GetOrder_PaypalSell.Outputs> _GetOrder_PaypalSell;
        
        private readonly DP.DapperORM.BaseSP<GetOrder_PaypalSellByAdmin.Inputs, GetOrder_PaypalSellByAdmin.Outputs> _GetOrder_PaypalSellByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_PaypalChargeByAdmin.Inputs, GetOrder_PaypalChargeByAdmin.Outputs> _GetOrder_PaypalChargeByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_PaypalBuyByAdmin.Inputs, GetOrder_PaypalBuyByAdmin.Outputs> _GetOrder_PaypalBuyByAdmin;

        public PaypalContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Insert_OrderPaypalSellByCustomer = new DP.DapperORM.BaseSP<Insert_OrderPaypalSellByCustomer.Inputs, Insert_OrderPaypalSellByCustomer.Outputs>("Order.Insert_OrderPaypalSellByCustomer", executer);
            _Insert_OrderPaypalSellByCompany = new DP.DapperORM.BaseSP<Insert_OrderPaypalSellByCompany.Inputs, Insert_OrderPaypalSellByCompany.Outputs>("Order.Insert_OrderPaypalSellByCompany", executer);
            _Insert_OrderPaypalChargeByCompany = new DP.DapperORM.BaseSP<Insert_OrderPaypalChargeByCompany.Inputs, Insert_OrderPaypalChargeByCompany.Outputs>("Order.Insert_OrderPaypalChargeByCompany", executer);
            _Insert_OrderPaypalBuyByCompany = new DP.DapperORM.BaseSP<Insert_OrderPaypalBuyByCompany.Inputs, Insert_OrderPaypalBuyByCompany.Outputs>("Order.Insert_OrderPaypalBuyByCompany", executer);
            _Insert_OrderPaypalSellByAdmin = new DP.DapperORM.BaseSP<Insert_OrderPaypalSellByAdmin.Inputs, Insert_OrderPaypalSellByAdmin.Outputs>("Order.Insert_OrderPaypalSellByAdmin", executer);
            _Insert_OrderPaypalBuyByAdmin = new DP.DapperORM.BaseSP<Insert_OrderPaypalBuyByAdmin.Inputs, Insert_OrderPaypalBuyByAdmin.Outputs>("Order.Insert_OrderPaypalBuyByAdmin", executer);
            _Insert_OrderPaypalChargeByAdmin = new DP.DapperORM.BaseSP<Insert_OrderPaypalChargeByAdmin.Inputs, Insert_OrderPaypalChargeByAdmin.Outputs>("Order.Insert_OrderPaypalChargeByAdmin", executer);
            _Insert_OrderPaypalBuyByCustomer = new DP.DapperORM.BaseSP<Insert_OrderPaypalBuyByCustomer.Inputs, Insert_OrderPaypalBuyByCustomer.Outputs>("Order.Insert_OrderPaypalBuyByCustomer", executer);
            _Insert_OrderPaypalChargeByCustomer = new DP.DapperORM.BaseSP<Insert_OrderPaypalChargeByCustomer.Inputs, Insert_OrderPaypalChargeByCustomer.Outputs>("Order.Insert_OrderPaypalChargeByCustomer", executer);

            _Get_OrderPaypalBuy_Price = new DP.DapperORM.BaseSP<Get_OrderPaypalBuy_Price.Inputs, Get_OrderPaypalBuy_Price.Outputs>("Order.Get_OrderPaypalBuy_Price", executer);
            _Get_OrderPaypalSell_Price = new DP.DapperORM.BaseSP<Get_OrderPaypalSell_Price.Inputs, Get_OrderPaypalSell_Price.Outputs>("Order.Get_OrderPaypalSell_Price", executer);
            _Get_OrderPaypalCharge_Price = new DP.DapperORM.BaseSP<Get_OrderPaypalCharge_Price.Inputs, Get_OrderPaypalCharge_Price.Outputs>("Order.Get_OrderPaypalCharge_Price", executer);

            _Get_OrderPaypalBuy_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderPaypalBuy_Price_Servant.Inputs, Get_OrderPaypalBuy_Price_Servant.Outputs>("Order.Get_OrderPaypalBuy_Price_Servant", executer);
            _Get_OrderPaypalSell_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderPaypalSell_Price_Servant.Inputs, Get_OrderPaypalSell_Price_Servant.Outputs>("Order.Get_OrderPaypalSell_Price_Servant", executer);
            _Get_OrderPaypalCharge_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderPaypalCharge_Price_Servant.Inputs, Get_OrderPaypalCharge_Price_Servant.Outputs>("Order.Get_OrderPaypalCharge_Price_Servant", executer);

            _GetOrder_PaypalBuy = new DP.DapperORM.BaseSP<GetOrder_PaypalBuy.Inputs, GetOrder_PaypalBuy.Outputs>("Order.GetOrder_PaypalBuy", executer);
            _GetOrder_PaypalCharge = new DP.DapperORM.BaseSP<GetOrder_PaypalCharge.Inputs, GetOrder_PaypalCharge.Outputs>("Order.GetOrder_PaypalCharge", executer);
            _GetOrder_PaypalSell = new DP.DapperORM.BaseSP<GetOrder_PaypalSell.Inputs, GetOrder_PaypalSell.Outputs>("Order.GetOrder_PaypalSell", executer);

            _GetOrder_PaypalSellByAdmin = new DP.DapperORM.BaseSP<GetOrder_PaypalSellByAdmin.Inputs, GetOrder_PaypalSellByAdmin.Outputs>("Order.GetOrder_PaypalSellByAdmin", executer);
            _GetOrder_PaypalChargeByAdmin = new DP.DapperORM.BaseSP<GetOrder_PaypalChargeByAdmin.Inputs, GetOrder_PaypalChargeByAdmin.Outputs>("Order.GetOrder_PaypalChargeByAdmin", executer);
            _GetOrder_PaypalBuyByAdmin = new DP.DapperORM.BaseSP<GetOrder_PaypalBuyByAdmin.Inputs, GetOrder_PaypalBuyByAdmin.Outputs>("Order.GetOrder_PaypalBuyByAdmin", executer);

        }
        public async Task<DBResult<Insert_OrderPaypalSellByCustomer.Outputs>> Insert_OrderPaypalSellByCustomer(Insert_OrderPaypalSellByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaypalSellByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPaypalBuyByCustomer.Outputs>> Insert_OrderPaypalBuyByCustomer(Insert_OrderPaypalBuyByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaypalBuyByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPaypalChargeByCustomer.Outputs>> Insert_OrderPaypalChargeByCustomer(Insert_OrderPaypalChargeByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaypalChargeByCustomer.Single(inputs, cancellationToken); }

        public async Task<DBResult<Insert_OrderPaypalSellByCompany.Outputs>> Insert_OrderPaypalSellByCompany(Insert_OrderPaypalSellByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaypalSellByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPaypalChargeByCompany.Outputs>> Insert_OrderPaypalChargeByCompany(Insert_OrderPaypalChargeByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaypalChargeByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPaypalBuyByCompany.Outputs>> Insert_OrderPaypalBuyByCompany(Insert_OrderPaypalBuyByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaypalBuyByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPaypalSellByAdmin.Outputs>> Insert_OrderPaypalSellByAdmin(Insert_OrderPaypalSellByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaypalSellByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPaypalBuyByAdmin.Outputs>> Insert_OrderPaypalBuyByAdmin(Insert_OrderPaypalBuyByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaypalBuyByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPaypalChargeByAdmin.Outputs>> Insert_OrderPaypalChargeByAdmin(Insert_OrderPaypalChargeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPaypalChargeByAdmin.Single(inputs, cancellationToken); }

        public async Task<DBResult<Get_OrderPaypalBuy_Price.Outputs>> Get_OrderPaypalBuy_Price(Get_OrderPaypalBuy_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPaypalBuy_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPaypalCharge_Price.Outputs>> Get_OrderPaypalCharge_Price(Get_OrderPaypalCharge_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPaypalCharge_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPaypalSell_Price.Outputs>> Get_OrderPaypalSell_Price(Get_OrderPaypalSell_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPaypalSell_Price.Single(inputs, cancellationToken); }

        public async Task<DBResult<Get_OrderPaypalBuy_Price_Servant.Outputs>> Get_OrderPaypalBuy_Price_Servant(Get_OrderPaypalBuy_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPaypalBuy_Price_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPaypalCharge_Price_Servant.Outputs>> Get_OrderPaypalCharge_Price_Servant(Get_OrderPaypalCharge_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPaypalCharge_Price_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPaypalSell_Price_Servant.Outputs>> Get_OrderPaypalSell_Price_Servant(Get_OrderPaypalSell_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPaypalSell_Price_Servant.Single(inputs, cancellationToken); }

        public async Task<DBResult<IEnumerable<GetOrder_PaypalBuy.Outputs>>> GetOrder_PaypalBuy(GetOrder_PaypalBuy.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PaypalBuy.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PaypalCharge.Outputs>>> GetOrder_PaypalCharge(GetOrder_PaypalCharge.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PaypalCharge.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PaypalSell.Outputs>>> GetOrder_PaypalSell(GetOrder_PaypalSell.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PaypalSell.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PaypalSellByAdmin.Outputs>>> GetOrder_PaypalSellByAdmin(GetOrder_PaypalSellByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PaypalSellByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PaypalBuyByAdmin.Outputs>>> GetOrder_PaypalBuyByAdmin(GetOrder_PaypalBuyByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PaypalBuyByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PaypalChargeByAdmin.Outputs>>> GetOrder_PaypalChargeByAdmin(GetOrder_PaypalChargeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PaypalChargeByAdmin.Query(inputs, cancellationToken); }
    }
}
