﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Paypal;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class PerfectMoneyContext: IPerfectMoneyContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyChargeByAdmin.Inputs, Insert_OrderPerfectMoneyChargeByAdmin.Outputs> _Insert_OrderPerfectMoneyChargeByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPerfectMoneySellByAdmin.Inputs, Insert_OrderPerfectMoneySellByAdmin.Outputs> _Insert_OrderPerfectMoneySellByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyVoucherByAdmin.Inputs, Insert_OrderPerfectMoneyVoucherByAdmin.Outputs> _Insert_OrderPerfectMoneyVoucherByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderVoucherPerfectMoneySellByAdmin.Inputs, Insert_OrderVoucherPerfectMoneySellByAdmin.Outputs> _Insert_OrderVoucherPerfectMoneySellByAdmin;

        private readonly DP.DapperORM.BaseSP<Get_OrderPerfectMoneyCharge_Price_Servant.Inputs, Get_OrderPerfectMoneyCharge_Price_Servant.Outputs> _Get_OrderPerfectMoneyCharge_Price_Servant;
        private readonly DP.DapperORM.BaseSP<Get_OrderPerfectMoneySell_Price_Servant.Inputs, Get_OrderPerfectMoneySell_Price_Servant.Outputs> _Get_OrderPerfectMoneySell_Price_Servant;
        private readonly DP.DapperORM.BaseSP<Get_OrderPerfectMoneyVoucher_Price_Servant.Inputs, Get_OrderPerfectMoneyVoucher_Price_Servant.Outputs> _Get_OrderPerfectMoneyVoucher_Price_Servant;


        private readonly DP.DapperORM.BaseSP<Get_OrderPerfectMoneyCharge_Price.Inputs, Get_OrderPerfectMoneyCharge_Price.Outputs> _Get_OrderPerfectMoneyCharge_Price;
        private readonly DP.DapperORM.BaseSP<Get_OrderPerfectMoneyVoucher_Price.Inputs, Get_OrderPerfectMoneyVoucher_Price.Outputs> _Get_OrderPerfectMoneyVoucher_Price;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyChargeByCustomer.Inputs, Insert_OrderPerfectMoneyChargeByCustomer.Outputs> _Insert_OrderPerfectMoneyChargeByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyVoucherByCustomer.Inputs, Insert_OrderPerfectMoneyVoucherByCustomer.Outputs> _Insert_OrderPerfectMoneyVoucherByCustomer;
        private readonly DP.DapperORM.BaseSP<GetOrder_PerfectMoneyVoucher.Inputs, GetOrder_PerfectMoneyVoucher.Outputs> _GetOrder_PerfectMoneyVoucher;
        private readonly DP.DapperORM.BaseSP<GetOrder_PerfectMoneyCharge.Inputs, GetOrder_PerfectMoneyCharge.Outputs> _GetOrder_PerfectMoneyCharge;
        private readonly DP.DapperORM.BaseSP<GetOrder_PerfectMoneyChargeByAdmin.Inputs, GetOrder_PerfectMoneyChargeByAdmin.Outputs> _GetOrder_PerfectMoneyChargeByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_PerfectMoneyVoucherByAdmin.Inputs, GetOrder_PerfectMoneyVoucherByAdmin.Outputs> _GetOrder_PerfectMoneyVoucherByAdmin;
        private readonly DP.DapperORM.BaseSP<Update_OrderPerfectMoneyByCustomer.Inputs, Update_OrderPerfectMoneyByCustomer.Outputs> _Update_OrderPerfectMoneyByCustomer;
        private readonly DP.DapperORM.BaseSP<Update_OrderPerfectMoneyVoucherByCustomer.Inputs, Update_OrderPerfectMoneyVoucherByCustomer.Outputs> _Update_OrderPerfectMoneyVoucherByCustomer;
        private readonly DP.DapperORM.BaseSP<GetOrder_PerfectMoneyChargeAnonymous.Inputs, GetOrder_PerfectMoneyChargeAnonymous.Outputs> _GetOrder_PerfectMoneyChargeAnonymous;
        private readonly DP.DapperORM.BaseSP<GetOrder_PerfectMoneyVoucherAnonymous.Inputs, GetOrder_PerfectMoneyVoucherAnonymous.Outputs> _GetOrder_PerfectMoneyVoucherAnonymous;

        private readonly DP.DapperORM.BaseSP<Insert_OrderPerfectMoneySellByCustomer.Inputs, Insert_OrderPerfectMoneySellByCustomer.Outputs> _Insert_OrderPerfectMoneySellByCustomer;

        private readonly DP.DapperORM.BaseSP<Insert_OrderPerfectMoneySellByCompany.Inputs, Insert_OrderPerfectMoneySellByCompany.Outputs> _Insert_OrderPerfectMoneySellByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyChargeByCompany.Inputs, Insert_OrderPerfectMoneyChargeByCompany.Outputs> _Insert_OrderPerfectMoneyChargeByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyVoucherByCompany.Inputs, Insert_OrderPerfectMoneyVoucherByCompany.Outputs> _Insert_OrderPerfectMoneyVoucherByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderVoucherPerfectMoneySellByCompany.Inputs, Insert_OrderVoucherPerfectMoneySellByCompany.Outputs> _Insert_OrderVoucherPerfectMoneySellByCompany;
        
        private readonly DP.DapperORM.BaseSP<GetOrder_PerfectMoneySell.Inputs, GetOrder_PerfectMoneySell.Outputs> _GetOrder_PerfectMoneySell;
        private readonly DP.DapperORM.BaseSP<GetOrder_PerfectMoneySellAnonymous.Inputs, GetOrder_PerfectMoneySellAnonymous.Outputs> _GetOrder_PerfectMoneySellAnonymous;
        private readonly DP.DapperORM.BaseSP<GetOrder_PerfectMoneySellByAdmin.Inputs, GetOrder_PerfectMoneySellByAdmin.Outputs> _GetOrder_PerfectMoneySellByAdmin;
        private readonly DP.DapperORM.BaseSP<Get_OrderPerfectMoneySell_Price.Inputs, Get_OrderPerfectMoneySell_Price.Outputs> _Get_OrderPerfectMoneySell_Price;
        private readonly DP.DapperORM.BaseSP<Update_OrderPerfectMoneySellByCustomer.Inputs, Update_OrderPerfectMoneySellByCustomer.Outputs> _Update_OrderPerfectMoneySellByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderVoucherPerfectMoneySellByCustomer.Inputs, Insert_OrderVoucherPerfectMoneySellByCustomer.Outputs> _Insert_OrderVoucherPerfectMoneySellByCustomer;
        private readonly DP.DapperORM.BaseSP<Update_OrderVoucherPerfectMoneySellByCustomer.Inputs, Update_OrderVoucherPerfectMoneySellByCustomer.Outputs> _Update_OrderVoucherPerfectMoneySellByCustomer;
        private readonly DP.DapperORM.BaseSP<Get_OrderVoucherPerfectMoneySell_Price.Inputs, Get_OrderVoucherPerfectMoneySell_Price.Outputs> _Get_OrderVoucherPerfectMoneySell_Price;
        private readonly DP.DapperORM.BaseSP<GetOrder_VoucherPerfectMoneySell.Inputs, GetOrder_VoucherPerfectMoneySell.Outputs> _GetOrder_VoucherPerfectMoneySell;
        private readonly DP.DapperORM.BaseSP<GetOrder_VoucherPerfectMoneySellByAdmin.Inputs, GetOrder_VoucherPerfectMoneySellByAdmin.Outputs> _GetOrder_VoucherPerfectMoneySellByAdmin;
        private readonly DP.DapperORM.BaseSP<GetOrder_PerfectMoneyVoucherSellAnonymous.Inputs, GetOrder_PerfectMoneyVoucherSellAnonymous.Outputs> _GetOrder_PerfectMoneyVoucherSellAnonymous;

        public PerfectMoneyContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Get_OrderPerfectMoneyCharge_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderPerfectMoneyCharge_Price_Servant.Inputs, Get_OrderPerfectMoneyCharge_Price_Servant.Outputs>("Order.Get_OrderPerfectMoneyCharge_Price_Servant", executer);
            _Get_OrderPerfectMoneySell_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderPerfectMoneySell_Price_Servant.Inputs, Get_OrderPerfectMoneySell_Price_Servant.Outputs>("Order.Get_OrderPerfectMoneySell_Price_Servant", executer);
            _Get_OrderPerfectMoneyVoucher_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderPerfectMoneyVoucher_Price_Servant.Inputs, Get_OrderPerfectMoneyVoucher_Price_Servant.Outputs>("Order.Get_OrderPerfectMoneyVoucher_Price_Servant", executer);
            _Insert_OrderPerfectMoneyChargeByAdmin = new DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyChargeByAdmin.Inputs, Insert_OrderPerfectMoneyChargeByAdmin.Outputs>("Order.Insert_OrderPerfectMoneyChargeByAdmin", executer);
            _Insert_OrderPerfectMoneySellByAdmin = new DP.DapperORM.BaseSP<Insert_OrderPerfectMoneySellByAdmin.Inputs, Insert_OrderPerfectMoneySellByAdmin.Outputs>("Order.Insert_OrderPerfectMoneySellByAdmin", executer);
            _Insert_OrderPerfectMoneyVoucherByAdmin = new DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyVoucherByAdmin.Inputs, Insert_OrderPerfectMoneyVoucherByAdmin.Outputs>("Order.Insert_OrderPerfectMoneyVoucherByAdmin", executer);
            _Insert_OrderVoucherPerfectMoneySellByAdmin = new DP.DapperORM.BaseSP<Insert_OrderVoucherPerfectMoneySellByAdmin.Inputs, Insert_OrderVoucherPerfectMoneySellByAdmin.Outputs>("Order.Insert_OrderVoucherPerfectMoneySellByAdmin", executer);

            _Get_OrderPerfectMoneyCharge_Price = new DP.DapperORM.BaseSP<Get_OrderPerfectMoneyCharge_Price.Inputs, Get_OrderPerfectMoneyCharge_Price.Outputs>("Order.Get_OrderPerfectMoneyCharge_Price", executer);
            _Get_OrderPerfectMoneyVoucher_Price = new DP.DapperORM.BaseSP<Get_OrderPerfectMoneyVoucher_Price.Inputs, Get_OrderPerfectMoneyVoucher_Price.Outputs>("Order.Get_OrderPerfectMoneyVoucher_Price", executer);
            _Insert_OrderPerfectMoneyChargeByCustomer = new DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyChargeByCustomer.Inputs, Insert_OrderPerfectMoneyChargeByCustomer.Outputs>("Order.Insert_OrderPerfectMoneyChargeByCustomer", executer);
            _Insert_OrderPerfectMoneyVoucherByCustomer = new DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyVoucherByCustomer.Inputs, Insert_OrderPerfectMoneyVoucherByCustomer.Outputs>("Order.Insert_OrderPerfectMoneyVoucherByCustomer", executer);
            _GetOrder_PerfectMoneyChargeByAdmin = new DP.DapperORM.BaseSP<GetOrder_PerfectMoneyChargeByAdmin.Inputs, GetOrder_PerfectMoneyChargeByAdmin.Outputs>("Order.GetOrder_PerfectMoneyChargeByAdmin", executer);
            _GetOrder_PerfectMoneyVoucherByAdmin = new DP.DapperORM.BaseSP<GetOrder_PerfectMoneyVoucherByAdmin.Inputs, GetOrder_PerfectMoneyVoucherByAdmin.Outputs>("Order.GetOrder_PerfectMoneyVoucherByAdmin", executer);
            _GetOrder_PerfectMoneyCharge = new DP.DapperORM.BaseSP<GetOrder_PerfectMoneyCharge.Inputs, GetOrder_PerfectMoneyCharge.Outputs>("Order.GetOrder_PerfectMoneyCharge", executer);
            _GetOrder_PerfectMoneyVoucher = new DP.DapperORM.BaseSP<GetOrder_PerfectMoneyVoucher.Inputs, GetOrder_PerfectMoneyVoucher.Outputs>("Order.GetOrder_PerfectMoneyVoucher", executer);
            _Update_OrderPerfectMoneyVoucherByCustomer = new DP.DapperORM.BaseSP<Update_OrderPerfectMoneyVoucherByCustomer.Inputs, Update_OrderPerfectMoneyVoucherByCustomer.Outputs>("Order.Update_OrderPerfectMoneyVoucherByCustomer", executer);
            _Update_OrderPerfectMoneyByCustomer = new DP.DapperORM.BaseSP<Update_OrderPerfectMoneyByCustomer.Inputs, Update_OrderPerfectMoneyByCustomer.Outputs>("Order.Update_OrderPerfectMoneyByCustomer", executer);
            _GetOrder_PerfectMoneyVoucherAnonymous = new DP.DapperORM.BaseSP<GetOrder_PerfectMoneyVoucherAnonymous.Inputs, GetOrder_PerfectMoneyVoucherAnonymous.Outputs>("Order.GetOrder_PerfectMoneyVoucherAnonymous", executer);
            _GetOrder_PerfectMoneyChargeAnonymous = new DP.DapperORM.BaseSP<GetOrder_PerfectMoneyChargeAnonymous.Inputs, GetOrder_PerfectMoneyChargeAnonymous.Outputs>("Order.GetOrder_PerfectMoneyChargeAnonymous", executer);

            _Insert_OrderPerfectMoneySellByCustomer = new DP.DapperORM.BaseSP<Insert_OrderPerfectMoneySellByCustomer.Inputs, Insert_OrderPerfectMoneySellByCustomer.Outputs>("Order.Insert_OrderPerfectMoneySellByCustomer", executer);
            _Insert_OrderPerfectMoneyChargeByCompany = new DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyChargeByCompany.Inputs, Insert_OrderPerfectMoneyChargeByCompany.Outputs>("Order.Insert_OrderPerfectMoneyChargeByCompany", executer);
            _Insert_OrderPerfectMoneyVoucherByCompany = new DP.DapperORM.BaseSP<Insert_OrderPerfectMoneyVoucherByCompany.Inputs, Insert_OrderPerfectMoneyVoucherByCompany.Outputs>("Order.Insert_OrderPerfectMoneyVoucherByCompany", executer);
            _Insert_OrderVoucherPerfectMoneySellByCompany = new DP.DapperORM.BaseSP<Insert_OrderVoucherPerfectMoneySellByCompany.Inputs, Insert_OrderVoucherPerfectMoneySellByCompany.Outputs>("Order.Insert_OrderVoucherPerfectMoneySellByCompany", executer);
            _Insert_OrderPerfectMoneySellByCompany = new DP.DapperORM.BaseSP<Insert_OrderPerfectMoneySellByCompany.Inputs, Insert_OrderPerfectMoneySellByCompany.Outputs>("Order.Insert_OrderPerfectMoneySellByCompany", executer);

            _Get_OrderPerfectMoneySell_Price = new DP.DapperORM.BaseSP<Get_OrderPerfectMoneySell_Price.Inputs, Get_OrderPerfectMoneySell_Price.Outputs>("Order.Get_OrderPerfectMoneySell_Price", executer);
            _GetOrder_PerfectMoneySellByAdmin = new DP.DapperORM.BaseSP<GetOrder_PerfectMoneySellByAdmin.Inputs, GetOrder_PerfectMoneySellByAdmin.Outputs>("Order.GetOrder_PerfectMoneySellByAdmin", executer);
            _GetOrder_PerfectMoneySellAnonymous = new DP.DapperORM.BaseSP<GetOrder_PerfectMoneySellAnonymous.Inputs, GetOrder_PerfectMoneySellAnonymous.Outputs>("Order.GetOrder_PerfectMoneySellAnonymous", executer);
            _GetOrder_PerfectMoneySell = new DP.DapperORM.BaseSP<GetOrder_PerfectMoneySell.Inputs, GetOrder_PerfectMoneySell.Outputs>("Order.GetOrder_PerfectMoneySell", executer);
            _Update_OrderPerfectMoneySellByCustomer = new DP.DapperORM.BaseSP<Update_OrderPerfectMoneySellByCustomer.Inputs, Update_OrderPerfectMoneySellByCustomer.Outputs>("Order.Update_OrderPerfectMoneySellByCustomer", executer);
            _Insert_OrderVoucherPerfectMoneySellByCustomer = new DP.DapperORM.BaseSP<Insert_OrderVoucherPerfectMoneySellByCustomer.Inputs, Insert_OrderVoucherPerfectMoneySellByCustomer.Outputs>("Order.Insert_OrderVoucherPerfectMoneySellByCustomer", executer);
            _Update_OrderVoucherPerfectMoneySellByCustomer = new DP.DapperORM.BaseSP<Update_OrderVoucherPerfectMoneySellByCustomer.Inputs, Update_OrderVoucherPerfectMoneySellByCustomer.Outputs>("Order.Update_OrderVoucherPerfectMoneySellByCustomer", executer);
            _Get_OrderVoucherPerfectMoneySell_Price = new DP.DapperORM.BaseSP<Get_OrderVoucherPerfectMoneySell_Price.Inputs, Get_OrderVoucherPerfectMoneySell_Price.Outputs>("Order.Get_OrderVoucherPerfectMoneySell_Price", executer);
            _GetOrder_VoucherPerfectMoneySell = new DP.DapperORM.BaseSP<GetOrder_VoucherPerfectMoneySell.Inputs, GetOrder_VoucherPerfectMoneySell.Outputs>("Order.GetOrder_VoucherPerfectMoneySell", executer);
            _GetOrder_VoucherPerfectMoneySellByAdmin = new DP.DapperORM.BaseSP<GetOrder_VoucherPerfectMoneySellByAdmin.Inputs, GetOrder_VoucherPerfectMoneySellByAdmin.Outputs>("Order.GetOrder_VoucherPerfectMoneySellByAdmin", executer);
            _GetOrder_PerfectMoneyVoucherSellAnonymous = new DP.DapperORM.BaseSP<GetOrder_PerfectMoneyVoucherSellAnonymous.Inputs, GetOrder_PerfectMoneyVoucherSellAnonymous.Outputs>("Order.GetOrder_PerfectMoneyVoucherSellAnonymous", executer);
        }
        public async Task<DBResult<Get_OrderPerfectMoneyCharge_Price_Servant.Outputs>> Get_OrderPerfectMoneyCharge_Price_Servant(Get_OrderPerfectMoneyCharge_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPerfectMoneyCharge_Price_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPerfectMoneySell_Price_Servant.Outputs>> Get_OrderPerfectMoneySell_Price_Servant(Get_OrderPerfectMoneySell_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPerfectMoneySell_Price_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPerfectMoneyVoucher_Price_Servant.Outputs>> Get_OrderPerfectMoneyVoucher_Price_Servant(Get_OrderPerfectMoneyVoucher_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPerfectMoneyVoucher_Price_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPerfectMoneyChargeByAdmin.Outputs>> Insert_OrderPerfectMoneyChargeByAdmin(Insert_OrderPerfectMoneyChargeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPerfectMoneyChargeByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPerfectMoneySellByAdmin.Outputs>> Insert_OrderPerfectMoneySellByAdmin(Insert_OrderPerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPerfectMoneySellByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPerfectMoneyVoucherByAdmin.Outputs>> Insert_OrderPerfectMoneyVoucherByAdmin(Insert_OrderPerfectMoneyVoucherByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPerfectMoneyVoucherByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderVoucherPerfectMoneySellByAdmin.Outputs>> Insert_OrderVoucherPerfectMoneySellByAdmin(Insert_OrderVoucherPerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderVoucherPerfectMoneySellByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPerfectMoneyCharge_Price.Outputs>> Get_OrderPerfectMoneyCharge_Price(Get_OrderPerfectMoneyCharge_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPerfectMoneyCharge_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPerfectMoneyVoucher_Price.Outputs>> Get_OrderPerfectMoneyVoucher_Price(Get_OrderPerfectMoneyVoucher_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPerfectMoneyVoucher_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPerfectMoneyChargeByCustomer.Outputs>> Insert_OrderPerfectMoneyChargeByCustomer(Insert_OrderPerfectMoneyChargeByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPerfectMoneyChargeByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPerfectMoneyVoucherByCustomer.Outputs>> Insert_OrderPerfectMoneyVoucherByCustomer(Insert_OrderPerfectMoneyVoucherByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPerfectMoneyVoucherByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PerfectMoneyCharge.Outputs>>> GetOrder_PerfectMoneyCharge(GetOrder_PerfectMoneyCharge.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PerfectMoneyCharge.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PerfectMoneyVoucher.Outputs>>> GetOrder_PerfectMoneyVoucher(GetOrder_PerfectMoneyVoucher.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PerfectMoneyVoucher.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PerfectMoneyVoucherByAdmin.Outputs>>> GetOrder_PerfectMoneyVoucherByAdmin(GetOrder_PerfectMoneyVoucherByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PerfectMoneyVoucherByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PerfectMoneyChargeByAdmin.Outputs>>> GetOrder_PerfectMoneyChargeByAdmin(GetOrder_PerfectMoneyChargeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PerfectMoneyChargeByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult> Update_OrderPerfectMoneyVoucherByCustomer(Update_OrderPerfectMoneyVoucherByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Update_OrderPerfectMoneyVoucherByCustomer.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_OrderPerfectMoneyByCustomer(Update_OrderPerfectMoneyByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Update_OrderPerfectMoneyByCustomer.Execute(inputs, cancellationToken); }
        public async Task<DBResult<GetOrder_PerfectMoneyChargeAnonymous.Outputs>> GetOrder_PerfectMoneyChargeAnonymous(GetOrder_PerfectMoneyChargeAnonymous.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PerfectMoneyChargeAnonymous.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetOrder_PerfectMoneyVoucherAnonymous.Outputs>> GetOrder_PerfectMoneyVoucherAnonymous(GetOrder_PerfectMoneyVoucherAnonymous.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PerfectMoneyVoucherAnonymous.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPerfectMoneySellByCustomer.Outputs>> Insert_OrderPerfectMoneySellByCustomer(Insert_OrderPerfectMoneySellByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPerfectMoneySellByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPerfectMoneySellByCompany.Outputs>> Insert_OrderPerfectMoneySellByCompany(Insert_OrderPerfectMoneySellByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPerfectMoneySellByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPerfectMoneyChargeByCompany.Outputs>> Insert_OrderPerfectMoneyChargeByCompany(Insert_OrderPerfectMoneyChargeByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPerfectMoneyChargeByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPerfectMoneyVoucherByCompany.Outputs>> Insert_OrderPerfectMoneyVoucherByCompany(Insert_OrderPerfectMoneyVoucherByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPerfectMoneyVoucherByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderVoucherPerfectMoneySellByCompany.Outputs>> Insert_OrderVoucherPerfectMoneySellByCompany(Insert_OrderVoucherPerfectMoneySellByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderVoucherPerfectMoneySellByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PerfectMoneySell.Outputs>>> GetOrder_PerfectMoneySell(GetOrder_PerfectMoneySell.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PerfectMoneySell.Query(inputs, cancellationToken); }
        public async Task<DBResult<GetOrder_PerfectMoneySellAnonymous.Outputs>> GetOrder_PerfectMoneySellAnonymous(GetOrder_PerfectMoneySellAnonymous.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PerfectMoneySellAnonymous.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PerfectMoneySellByAdmin.Outputs>>> GetOrder_PerfectMoneySellByAdmin(GetOrder_PerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PerfectMoneySellByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPerfectMoneySell_Price.Outputs>> Get_OrderPerfectMoneySell_Price(Get_OrderPerfectMoneySell_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPerfectMoneySell_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_OrderPerfectMoneySellByCustomer.Outputs>> Update_OrderPerfectMoneySellByCustomer(Update_OrderPerfectMoneySellByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Update_OrderPerfectMoneySellByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderVoucherPerfectMoneySellByCustomer.Outputs>> Insert_OrderVoucherPerfectMoneySellByCustomer(Insert_OrderVoucherPerfectMoneySellByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderVoucherPerfectMoneySellByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_OrderVoucherPerfectMoneySellByCustomer.Outputs>> Update_OrderVoucherPerfectMoneySellByCustomer(Update_OrderVoucherPerfectMoneySellByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Update_OrderVoucherPerfectMoneySellByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderVoucherPerfectMoneySell_Price.Outputs>> Get_OrderVoucherPerfectMoneySell_Price(Get_OrderVoucherPerfectMoneySell_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderVoucherPerfectMoneySell_Price.Single(inputs, cancellationToken); }

        public async Task<DBResult<IEnumerable<GetOrder_VoucherPerfectMoneySell.Outputs>>> GetOrder_VoucherPerfectMoneySell(GetOrder_VoucherPerfectMoneySell.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_VoucherPerfectMoneySell.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_VoucherPerfectMoneySellByAdmin.Outputs>>> GetOrder_VoucherPerfectMoneySellByAdmin(GetOrder_VoucherPerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_VoucherPerfectMoneySellByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<GetOrder_PerfectMoneyVoucherSellAnonymous.Outputs>> GetOrder_PerfectMoneyVoucherSellAnonymous(GetOrder_PerfectMoneyVoucherSellAnonymous.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PerfectMoneyVoucherSellAnonymous.Single(inputs, cancellationToken); }
    }
}
