﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order.ApplicationFee;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.DP.DapperORM;

namespace Farakonesh.Logic.Database.Order
{
    public class PremiumAccountContext: IPremiumAccountContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Delete_ActivationTypePremiumAccount.Inputs, Delete_ActivationTypePremiumAccount.Outputs> _Delete_ActivationTypePremiumAccount;
        private readonly DP.DapperORM.BaseSP<Delete_CountryPremiumAccount.Inputs, Delete_CountryPremiumAccount.Outputs> _Delete_CountryPremiumAccount;
        private readonly DP.DapperORM.BaseSP<Delete_LanguagePremiumAccount.Inputs, Delete_LanguagePremiumAccount.Outputs> _Delete_LanguagePremiumAccount;
        private readonly DP.DapperORM.BaseSP<Delete_PelanPremiumAccount.Inputs, Delete_PelanPremiumAccount.Outputs> _Delete_PelanPremiumAccount;
        private readonly DP.DapperORM.BaseSP<Delete_PeriodPremiumAccount.Inputs, Delete_PeriodPremiumAccount.Outputs> _Delete_PeriodPremiumAccount;
        private readonly DP.DapperORM.BaseSP<Delete_TypePremiumAccount.Inputs, Delete_TypePremiumAccount.Outputs> _Delete_TypePremiumAccount;
        private readonly DP.DapperORM.BaseSP<Insert_ActivationTypePremiumAccount.Inputs, Insert_ActivationTypePremiumAccount.Outputs> _Insert_ActivationTypePremiumAccount;
        private readonly DP.DapperORM.BaseSP<Insert_CountryPremiumAccount.Inputs, Insert_CountryPremiumAccount.Outputs> _Insert_CountryPremiumAccount;
        private readonly DP.DapperORM.BaseSP<Insert_LanguagePremiumAccount.Inputs, Insert_LanguagePremiumAccount.Outputs> _Insert_LanguagePremiumAccount;
        private readonly DP.DapperORM.BaseSP<Insert_PelanPremiumAccount.Inputs, Insert_PelanPremiumAccount.Outputs> _Insert_PelanPremiumAccount;
        private readonly DP.DapperORM.BaseSP<Insert_PeriodPremiumAccount.Inputs, Insert_PeriodPremiumAccount.Outputs> _Insert_PeriodPremiumAccount;
        private readonly DP.DapperORM.BaseSP<Insert_TypePremiumAccount.Inputs, Insert_TypePremiumAccount.Outputs> _Insert_TypePremiumAccount;

        private readonly DP.DapperORM.BaseSP<Update_ActivationTypePremiumAccount.Inputs, Update_ActivationTypePremiumAccount.Outputs> _Update_ActivationTypePremiumAccount;
        private readonly DP.DapperORM.BaseSP<Update_CountryPremiumAccount.Inputs, Update_CountryPremiumAccount.Outputs> _Update_CountryPremiumAccount;
        private readonly DP.DapperORM.BaseSP<Update_LanguagePremiumAccount.Inputs, Update_LanguagePremiumAccount.Outputs> _Update_LanguagePremiumAccount;
        private readonly DP.DapperORM.BaseSP<Update_PelanPremiumAccount.Inputs, Update_PelanPremiumAccount.Outputs> _Update_PelanPremiumAccount;
        private readonly DP.DapperORM.BaseSP<Update_PeriodPremiumAccount.Inputs, Update_PeriodPremiumAccount.Outputs> _Update_PeriodPremiumAccount;
        private readonly DP.DapperORM.BaseSP<Update_TypePremiumAccount.Inputs, Update_TypePremiumAccount.Outputs> _Update_TypePremiumAccount;

        private readonly DP.DapperORM.BaseSP<GetActivationTypePremiumAccountList.Inputs, GetActivationTypePremiumAccountList.Outputs> _GetActivationTypePremiumAccountList;
        private readonly DP.DapperORM.BaseSP<GetCountryPremiumAccountList.Inputs, GetCountryPremiumAccountList.Outputs> _GetCountryPremiumAccountList;
        private readonly DP.DapperORM.BaseSP<GetLanguagePremiumAccountList.Inputs, GetLanguagePremiumAccountList.Outputs> _GetLanguagePremiumAccountList;
        private readonly DP.DapperORM.BaseSP<GetPelanPremiumAccountList.Inputs, GetPelanPremiumAccountList.Outputs> _GetPelanPremiumAccountList;
        private readonly DP.DapperORM.BaseSP<GetPeriodPremiumAccountList.Inputs, GetPeriodPremiumAccountList.Outputs> _GetPeriodPremiumAccountList;
        private readonly DP.DapperORM.BaseSP<GetTypePremiumAccountList.Inputs, GetTypePremiumAccountList.Outputs> _GetTypePremiumAccountList;

        private readonly DP.DapperORM.BaseSP<Get_OrderPremiumAccount_Price.Inputs, Get_OrderPremiumAccount_Price.Outputs> _Get_OrderPremiumAccount_Price;
        private readonly DP.DapperORM.BaseSP<GetOrder_PremiumAccount.Inputs, GetOrder_PremiumAccount.Outputs> _GetOrder_PremiumAccount;
        private readonly DP.DapperORM.BaseSP<GetOrder_PremiumAccountByAdmin.Inputs, GetOrder_PremiumAccountByAdmin.Outputs> _GetOrder_PremiumAccountByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPremiumAccountByCustomer.Inputs, Insert_OrderPremiumAccountByCustomer.Outputs> _Insert_OrderPremiumAccountByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPremiumAccountByCompany.Inputs, Insert_OrderPremiumAccountByCompany.Outputs> _Insert_OrderPremiumAccountByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderPremiumAccountByAdmin.Inputs, Insert_OrderPremiumAccountByAdmin.Outputs> _Insert_OrderPremiumAccountByAdmin;
        private readonly DP.DapperORM.BaseSP<GetFullPremiumAccount.Inputs, GetFullPremiumAccount.Outputs> _GetFullPremiumAccount;

        public PremiumAccountContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Delete_ActivationTypePremiumAccount = new DP.DapperORM.BaseSP<Delete_ActivationTypePremiumAccount.Inputs, Delete_ActivationTypePremiumAccount.Outputs>("Order.Delete_ActivationTypePremiumAccount", executer);
            _Delete_CountryPremiumAccount = new DP.DapperORM.BaseSP<Delete_CountryPremiumAccount.Inputs, Delete_CountryPremiumAccount.Outputs>("Order.Delete_CountryPremiumAccount", executer);
            _Delete_LanguagePremiumAccount = new DP.DapperORM.BaseSP<Delete_LanguagePremiumAccount.Inputs, Delete_LanguagePremiumAccount.Outputs>("Order.Delete_LanguagePremiumAccount", executer);
            _Delete_PelanPremiumAccount = new DP.DapperORM.BaseSP<Delete_PelanPremiumAccount.Inputs, Delete_PelanPremiumAccount.Outputs>("Order.Delete_PelanPremiumAccount", executer);
            _Delete_PeriodPremiumAccount = new DP.DapperORM.BaseSP<Delete_PeriodPremiumAccount.Inputs, Delete_PeriodPremiumAccount.Outputs>("Order.Delete_PeriodPremiumAccount", executer);
            _Delete_TypePremiumAccount = new DP.DapperORM.BaseSP<Delete_TypePremiumAccount.Inputs, Delete_TypePremiumAccount.Outputs>("Order.Delete_TypePremiumAccount", executer);
            _Insert_ActivationTypePremiumAccount = new DP.DapperORM.BaseSP<Insert_ActivationTypePremiumAccount.Inputs, Insert_ActivationTypePremiumAccount.Outputs>("Order.Insert_ActivationTypePremiumAccount", executer);
            _Insert_CountryPremiumAccount = new DP.DapperORM.BaseSP<Insert_CountryPremiumAccount.Inputs, Insert_CountryPremiumAccount.Outputs>("Order.Insert_CountryPremiumAccount", executer);
            _Insert_LanguagePremiumAccount = new DP.DapperORM.BaseSP<Insert_LanguagePremiumAccount.Inputs, Insert_LanguagePremiumAccount.Outputs>("Order.Insert_LanguagePremiumAccount", executer);
            _Insert_PelanPremiumAccount = new DP.DapperORM.BaseSP<Insert_PelanPremiumAccount.Inputs, Insert_PelanPremiumAccount.Outputs>("Order.Insert_PelanPremiumAccount", executer);
            _Insert_PeriodPremiumAccount = new DP.DapperORM.BaseSP<Insert_PeriodPremiumAccount.Inputs, Insert_PeriodPremiumAccount.Outputs>("Order.Insert_PeriodPremiumAccount", executer);
            _Insert_TypePremiumAccount = new DP.DapperORM.BaseSP<Insert_TypePremiumAccount.Inputs, Insert_TypePremiumAccount.Outputs>("Order.Insert_TypePremiumAccount", executer);

            _Update_ActivationTypePremiumAccount = new DP.DapperORM.BaseSP<Update_ActivationTypePremiumAccount.Inputs, Update_ActivationTypePremiumAccount.Outputs>("Order.Update_ActivationTypePremiumAccount", executer);
            _Update_CountryPremiumAccount = new DP.DapperORM.BaseSP<Update_CountryPremiumAccount.Inputs, Update_CountryPremiumAccount.Outputs>("Order.Update_CountryPremiumAccount", executer);
            _Update_LanguagePremiumAccount = new DP.DapperORM.BaseSP<Update_LanguagePremiumAccount.Inputs, Update_LanguagePremiumAccount.Outputs>("Order.Update_LanguagePremiumAccount", executer);
            _Update_PelanPremiumAccount = new DP.DapperORM.BaseSP<Update_PelanPremiumAccount.Inputs, Update_PelanPremiumAccount.Outputs>("Order.Update_PelanPremiumAccount", executer);
            _Update_PeriodPremiumAccount = new DP.DapperORM.BaseSP<Update_PeriodPremiumAccount.Inputs, Update_PeriodPremiumAccount.Outputs>("Order.Update_PeriodPremiumAccount", executer);
            _Update_TypePremiumAccount = new DP.DapperORM.BaseSP<Update_TypePremiumAccount.Inputs, Update_TypePremiumAccount.Outputs>("Order.Update_TypePremiumAccount", executer);

            _GetActivationTypePremiumAccountList = new DP.DapperORM.BaseSP<GetActivationTypePremiumAccountList.Inputs, GetActivationTypePremiumAccountList.Outputs>("Order.GetActivationTypePremiumAccountList", executer);
            _GetCountryPremiumAccountList = new DP.DapperORM.BaseSP<GetCountryPremiumAccountList.Inputs, GetCountryPremiumAccountList.Outputs>("Order.GetCountryPremiumAccountList", executer);
            _GetLanguagePremiumAccountList = new DP.DapperORM.BaseSP<GetLanguagePremiumAccountList.Inputs, GetLanguagePremiumAccountList.Outputs>("Order.GetLanguagePremiumAccountList", executer);
            _GetPelanPremiumAccountList = new DP.DapperORM.BaseSP<GetPelanPremiumAccountList.Inputs, GetPelanPremiumAccountList.Outputs>("Order.GetPelanPremiumAccountList", executer);
            _GetPeriodPremiumAccountList = new DP.DapperORM.BaseSP<GetPeriodPremiumAccountList.Inputs, GetPeriodPremiumAccountList.Outputs>("Order.GetPeriodPremiumAccountList", executer);
            _GetTypePremiumAccountList = new DP.DapperORM.BaseSP<GetTypePremiumAccountList.Inputs, GetTypePremiumAccountList.Outputs>("Order.GetTypePremiumAccountList", executer);

            _Insert_OrderPremiumAccountByCustomer = new DP.DapperORM.BaseSP<Insert_OrderPremiumAccountByCustomer.Inputs, Insert_OrderPremiumAccountByCustomer.Outputs>("Order.Insert_OrderPremiumAccountByCustomer", executer);
            _Insert_OrderPremiumAccountByCompany = new DP.DapperORM.BaseSP<Insert_OrderPremiumAccountByCompany.Inputs, Insert_OrderPremiumAccountByCompany.Outputs>("Order.Insert_OrderPremiumAccountByCompany", executer);
            _Insert_OrderPremiumAccountByAdmin = new DP.DapperORM.BaseSP<Insert_OrderPremiumAccountByAdmin.Inputs, Insert_OrderPremiumAccountByAdmin.Outputs>("Order.Insert_OrderPremiumAccountByAdmin", executer);
            _GetOrder_PremiumAccount = new DP.DapperORM.BaseSP<GetOrder_PremiumAccount.Inputs, GetOrder_PremiumAccount.Outputs>("Order.GetOrder_PremiumAccount", executer);
            _GetOrder_PremiumAccountByAdmin = new DP.DapperORM.BaseSP<GetOrder_PremiumAccountByAdmin.Inputs, GetOrder_PremiumAccountByAdmin.Outputs>("Order.GetOrder_PremiumAccountByAdmin", executer);
            _Get_OrderPremiumAccount_Price = new DP.DapperORM.BaseSP<Get_OrderPremiumAccount_Price.Inputs, Get_OrderPremiumAccount_Price.Outputs>("Order.Get_OrderPremiumAccount_Price", executer);
            _GetFullPremiumAccount = new BaseSP<GetFullPremiumAccount.Inputs, GetFullPremiumAccount.Outputs>("Order.GetFullPremiumAccount", executer);
        }
        public async Task<DBResult> Delete_ActivationTypePremiumAccount(Delete_ActivationTypePremiumAccount.Inputs inputs, CancellationToken cancellationToken) {return await _Delete_ActivationTypePremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_CountryPremiumAccount(Delete_CountryPremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_CountryPremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_LanguagePremiumAccount(Delete_LanguagePremiumAccount.Inputs inputs, CancellationToken cancellationToken) {return await _Delete_LanguagePremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_PelanPremiumAccount(Delete_PelanPremiumAccount.Inputs inputs, CancellationToken cancellationToken) {return await _Delete_PelanPremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_PeriodPremiumAccount(Delete_PeriodPremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_PeriodPremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_TypePremiumAccount(Delete_TypePremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_TypePremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_ActivationTypePremiumAccount(Insert_ActivationTypePremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_ActivationTypePremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CountryPremiumAccount(Insert_CountryPremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CountryPremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_LanguagePremiumAccount(Insert_LanguagePremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_LanguagePremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_PelanPremiumAccount(Insert_PelanPremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_PelanPremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_PeriodPremiumAccount(Insert_PeriodPremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_PeriodPremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_TypePremiumAccount(Insert_TypePremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_TypePremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPremiumAccountByCustomer.Outputs>> Insert_OrderPremiumAccountByCustomer(Insert_OrderPremiumAccountByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPremiumAccountByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPremiumAccountByCompany.Outputs>> Insert_OrderPremiumAccountByCompany(Insert_OrderPremiumAccountByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPremiumAccountByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderPremiumAccountByAdmin.Outputs>> Insert_OrderPremiumAccountByAdmin(Insert_OrderPremiumAccountByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderPremiumAccountByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult> Update_ActivationTypePremiumAccount(Update_ActivationTypePremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Update_ActivationTypePremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_CountryPremiumAccount(Update_CountryPremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Update_CountryPremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_LanguagePremiumAccount(Update_LanguagePremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Update_LanguagePremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_PelanPremiumAccount(Update_PelanPremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Update_PelanPremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_PeriodPremiumAccount(Update_PeriodPremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Update_PeriodPremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_TypePremiumAccount(Update_TypePremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Update_TypePremiumAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetActivationTypePremiumAccountList.Outputs>>> GetActivationTypePremiumAccountList(GetActivationTypePremiumAccountList.Inputs inputs, CancellationToken cancellationToken) { return await _GetActivationTypePremiumAccountList.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCountryPremiumAccountList.Outputs>>> GetCountryPremiumAccountList(GetCountryPremiumAccountList.Inputs inputs, CancellationToken cancellationToken) { return await _GetCountryPremiumAccountList.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetLanguagePremiumAccountList.Outputs>>> GetLanguagePremiumAccountList(GetLanguagePremiumAccountList.Inputs inputs, CancellationToken cancellationToken) { return await _GetLanguagePremiumAccountList.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetPelanPremiumAccountList.Outputs>>> GetPelanPremiumAccountList(GetPelanPremiumAccountList.Inputs inputs, CancellationToken cancellationToken) { return await _GetPelanPremiumAccountList.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetPeriodPremiumAccountList.Outputs>>> GetPeriodPremiumAccountList(GetPeriodPremiumAccountList.Inputs inputs, CancellationToken cancellationToken) {  return await _GetPeriodPremiumAccountList.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetTypePremiumAccountList.Outputs>>> GetTypePremiumAccountList(GetTypePremiumAccountList.Inputs inputs, CancellationToken cancellationToken) {return await _GetTypePremiumAccountList.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderPremiumAccount_Price.Outputs>> Get_OrderPremiumAccount_Price(Get_OrderPremiumAccount_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderPremiumAccount_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PremiumAccount.Outputs>>> GetOrder_PremiumAccount(GetOrder_PremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PremiumAccount.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_PremiumAccountByAdmin.Outputs>>> GetOrder_PremiumAccountByAdmin(GetOrder_PremiumAccountByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_PremiumAccountByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<GetFullPremiumAccount.Outputs>> GetFullPremiumAccount(GetFullPremiumAccount.Inputs inputs, CancellationToken cancellationToken) { return await _GetFullPremiumAccount.QueryMultiple(inputs, cancellationToken); }

    }
}
