﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class RamRegionServerContext: IRamRegionServerContext
    {
        private readonly DP.DapperORM.BaseSP<GetPeriodServer.Inputs, GetPeriodServer.Outputs> _GetPeriodServer;
        private readonly DP.DapperORM.BaseSP<GetRamServer.Inputs, GetRamServer.Outputs> _GetRamServer;
        private readonly DP.DapperORM.BaseSP<GetRegionServer.Inputs, GetRegionServer.Outputs> _GetRegionServer;
        private readonly DP.DapperORM.BaseSP<Insert_ServerPeriod.Inputs, Insert_ServerPeriod.Outputs> _Insert_ServerPeriod;
        private readonly DP.DapperORM.BaseSP<Insert_ServerRam.Inputs, Insert_ServerRam.Outputs> _Insert_ServerRam;
        private readonly DP.DapperORM.BaseSP<Insert_ServerRegion.Inputs, Insert_ServerRegion.Outputs> _Insert_ServerRegion;
        private readonly DP.DapperORM.BaseSP<Update_ServerPeriod.Inputs, Update_ServerPeriod.Outputs> _Update_ServerPeriod;
        private readonly DP.DapperORM.BaseSP<Update_ServerRam.Inputs, Update_ServerRam.Outputs> _Update_ServerRam;
        private readonly DP.DapperORM.BaseSP<Update_ServerRegion.Inputs, Update_ServerRegion.Outputs> _Update_ServerRegion;
        private readonly DP.DapperORM.BaseSP<Delete_ServerPeriod.Inputs, Delete_ServerPeriod.Outputs> _Delete_ServerPeriod;
        private readonly DP.DapperORM.BaseSP<Delete_ServerRam.Inputs, Delete_ServerRam.Outputs> _Delete_ServerRam;
        private readonly DP.DapperORM.BaseSP<Delete_ServerRegion.Inputs, Delete_ServerRegion.Outputs> _Delete_ServerRegion;
        private readonly DP.DapperORM.BaseSP<GetRegionServerByRamId.Inputs, GetRegionServerByRamId.Outputs> _GetRegionServerByRamId;
        private readonly DP.DapperORM.BaseSP<Insert_ServerRegionRam.Inputs, Insert_ServerRegionRam.Outputs> _Insert_ServerRegionRam;
        private readonly DP.DapperORM.BaseSP<Delete_ServerRegionRam.Inputs, Delete_ServerRegionRam.Outputs> _Delete_ServerRegionRam;

        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        public RamRegionServerContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetPeriodServer = new DP.DapperORM.BaseSP<GetPeriodServer.Inputs, GetPeriodServer.Outputs>("Order.GetPeriodServer", executer);
            _GetRamServer = new DP.DapperORM.BaseSP<GetRamServer.Inputs, GetRamServer.Outputs>("Order.GetRamServer", executer);
            _GetRegionServer = new DP.DapperORM.BaseSP<GetRegionServer.Inputs, GetRegionServer.Outputs>("Order.GetRegionServer", executer);
            _Insert_ServerPeriod = new DP.DapperORM.BaseSP<Insert_ServerPeriod.Inputs, Insert_ServerPeriod.Outputs>("Order.Insert_ServerPeriod", executer);
            _Insert_ServerRam = new DP.DapperORM.BaseSP<Insert_ServerRam.Inputs, Insert_ServerRam.Outputs>("Order.Insert_ServerRam", executer);
            _Insert_ServerRegion = new DP.DapperORM.BaseSP<Insert_ServerRegion.Inputs, Insert_ServerRegion.Outputs>("Order.Insert_ServerRegion", executer);
            _Update_ServerPeriod = new DP.DapperORM.BaseSP<Update_ServerPeriod.Inputs, Update_ServerPeriod.Outputs>("Order.Update_ServerPeriod", executer);
            _Update_ServerRam = new DP.DapperORM.BaseSP<Update_ServerRam.Inputs, Update_ServerRam.Outputs>("Order.Update_ServerRam", executer);
            _Update_ServerRegion = new DP.DapperORM.BaseSP<Update_ServerRegion.Inputs, Update_ServerRegion.Outputs>("Order.Update_ServerRegion", executer);
            _Delete_ServerPeriod = new DP.DapperORM.BaseSP<Delete_ServerPeriod.Inputs, Delete_ServerPeriod.Outputs>("Order.Delete_ServerPeriod", executer);
            _Delete_ServerRam = new DP.DapperORM.BaseSP<Delete_ServerRam.Inputs, Delete_ServerRam.Outputs>("Order.Delete_ServerRam", executer);
            _Delete_ServerRegion = new DP.DapperORM.BaseSP<Delete_ServerRegion.Inputs, Delete_ServerRegion.Outputs>("Order.Delete_ServerRegion", executer);
            _GetRegionServerByRamId = new DP.DapperORM.BaseSP<GetRegionServerByRamId.Inputs, GetRegionServerByRamId.Outputs>("Order.GetRegionServerByRamId", executer);
            _Delete_ServerRegionRam = new DP.DapperORM.BaseSP<Delete_ServerRegionRam.Inputs, Delete_ServerRegionRam.Outputs>("Order.Delete_ServerRegionRam", executer);
            _Insert_ServerRegionRam = new DP.DapperORM.BaseSP<Insert_ServerRegionRam.Inputs, Insert_ServerRegionRam.Outputs>("Order.Insert_ServerRegionRam", executer);
        }

        public async Task<DBResult<IEnumerable<GetRamServer.Outputs>>> GetRamServer(GetRamServer.Inputs inputs, CancellationToken cancellationToken) { return await _GetRamServer.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetRegionServerByRamId.Outputs>>> GetRegionServerByRamId(GetRegionServerByRamId.Inputs inputs, CancellationToken cancellationToken) { return await _GetRegionServerByRamId.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetPeriodServer.Outputs>>> GetPeriodServer(GetPeriodServer.Inputs inputs, CancellationToken cancellationToken) { return await _GetPeriodServer.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetRegionServer.Outputs>>> GetRegionServer(GetRegionServer.Inputs inputs, CancellationToken cancellationToken) { return await _GetRegionServer.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_ServerPeriod(Insert_ServerPeriod.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_ServerPeriod.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_ServerRam(Insert_ServerRam.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_ServerRam.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_ServerRegion(Insert_ServerRegion.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_ServerRegion.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_ServerPeriod(Update_ServerPeriod.Inputs inputs, CancellationToken cancellationToken) { return await _Update_ServerPeriod.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_ServerRam(Update_ServerRam.Inputs inputs, CancellationToken cancellationToken) { return await _Update_ServerRam.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_ServerRegion(Update_ServerRegion.Inputs inputs, CancellationToken cancellationToken) { return await _Update_ServerRegion.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_ServerPeriod(Delete_ServerPeriod.Inputs inputs, CancellationToken cancellationToken) {return await _Delete_ServerPeriod.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_ServerRam(Delete_ServerRam.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_ServerRam.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_ServerRegion(Delete_ServerRegion.Inputs inputs, CancellationToken cancellationToken) {return await _Delete_ServerRegion.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_ServerRegionRam(Delete_ServerRegionRam.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_ServerRegionRam.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_ServerRegionRam(Insert_ServerRegionRam.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_ServerRegionRam.Execute(inputs, cancellationToken); }

    }
}
