﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Scenario;
namespace Farakonesh.Logic.Database.Order
{
    public class ScenarioContext: IScenarioContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<DeleteScenario.Inputs, DeleteScenario.Outputs> _DeleteScenario;
        private readonly DP.DapperORM.BaseSP<GetScenarioByAdmin.Inputs, GetScenarioByAdmin.Outputs> _GetScenarioByAdmin;
        private readonly DP.DapperORM.BaseSP<GetScenario.Inputs, GetScenario.Outputs> _GetScenario;
        private readonly DP.DapperORM.BaseSP<InsertScenarioOrderTypeList.Inputs, InsertScenarioOrderTypeList.Outputs> _InsertScenarioOrderTypeList;
        private readonly DP.DapperORM.BaseSP<InsertScenario.Inputs, InsertScenario.Outputs> _InsertScenario;
        private readonly DP.DapperORM.BaseSP<UpdateScenario.Inputs, UpdateScenario.Outputs> _UpdateScenario;
        private readonly DP.DapperORM.BaseSP<UpdateScenarioGroup.Inputs, UpdateScenarioGroup.Outputs> _UpdateScenarioGroup;
        private readonly DP.DapperORM.BaseSP<InsertScenarioGroup.Inputs, InsertScenarioGroup.Outputs> _InsertScenarioGroup;
        private readonly DP.DapperORM.BaseSP<GetScenarioGroupByAdmin.Inputs, GetScenarioGroupByAdmin.Outputs> _GetScenarioGroupByAdmin;
        private readonly DP.DapperORM.BaseSP<DeleteScenarioGroup.Inputs, DeleteScenarioGroup.Outputs> _DeleteScenarioGroup;


        public ScenarioContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _DeleteScenario = new DP.DapperORM.BaseSP<DeleteScenario.Inputs, DeleteScenario.Outputs>("Order.DeleteScenario", executer);
            _GetScenarioByAdmin = new DP.DapperORM.BaseSP<GetScenarioByAdmin.Inputs, GetScenarioByAdmin.Outputs>("Order.GetScenarioByAdmin", executer);
            _GetScenario = new DP.DapperORM.BaseSP<GetScenario.Inputs, GetScenario.Outputs>("Order.GetScenario", executer);
            _InsertScenarioOrderTypeList = new DP.DapperORM.BaseSP<InsertScenarioOrderTypeList.Inputs, InsertScenarioOrderTypeList.Outputs>("Order.InsertScenarioOrderTypeList", executer);
            _InsertScenario = new DP.DapperORM.BaseSP<InsertScenario.Inputs, InsertScenario.Outputs>("Order.InsertScenario", executer);
            _UpdateScenario = new DP.DapperORM.BaseSP<UpdateScenario.Inputs, UpdateScenario.Outputs>("Order.UpdateScenario", executer);
            _UpdateScenarioGroup = new DP.DapperORM.BaseSP<UpdateScenarioGroup.Inputs, UpdateScenarioGroup.Outputs>("Order.UpdateScenarioGroup", executer);
            _InsertScenarioGroup = new DP.DapperORM.BaseSP<InsertScenarioGroup.Inputs, InsertScenarioGroup.Outputs>("Order.InsertScenarioGroup", executer);
            _DeleteScenarioGroup = new DP.DapperORM.BaseSP<DeleteScenarioGroup.Inputs, DeleteScenarioGroup.Outputs>("Order.DeleteScenarioGroup", executer);
            _GetScenarioGroupByAdmin = new DP.DapperORM.BaseSP<GetScenarioGroupByAdmin.Inputs, GetScenarioGroupByAdmin.Outputs>("Order.GetScenarioGroupByAdmin", executer);
        }
        public async Task<DBResult> DeleteScenario(DeleteScenario.Inputs inputs, CancellationToken cancellationToken) { return await _DeleteScenario.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetScenarioByAdmin.Outputs>>> GetScenarioByAdmin(GetScenarioByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetScenarioByAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetScenario.Outputs>>> GetScenario(GetScenario.Inputs inputs, CancellationToken cancellationToken) { return await _GetScenario.Query(inputs, cancellationToken); }
        public async Task<DBResult> InsertScenario(InsertScenario.Inputs inputs, CancellationToken cancellationToken) { return await _InsertScenario.Execute(inputs, cancellationToken); }
        public async Task<DBResult> InsertScenarioOrderTypeList(InsertScenarioOrderTypeList.Inputs inputs, CancellationToken cancellationToken) { return await _InsertScenarioOrderTypeList.Execute(inputs, cancellationToken); }
        public async Task<DBResult> UpdateScenario(UpdateScenario.Inputs inputs, CancellationToken cancellationToken) { return await _UpdateScenario.Execute(inputs, cancellationToken); }
        public async Task<DBResult> UpdateScenarioGroup(UpdateScenarioGroup.Inputs inputs, CancellationToken cancellationToken) { return await _UpdateScenarioGroup.Execute(inputs, cancellationToken); }
        public async Task<DBResult> InsertScenarioGroup(InsertScenarioGroup.Inputs inputs, CancellationToken cancellationToken) { return await _InsertScenarioGroup.Execute(inputs, cancellationToken); }
        public async Task<DBResult> DeleteScenarioGroup(DeleteScenarioGroup.Inputs inputs, CancellationToken cancellationToken) { return await _DeleteScenarioGroup.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetScenarioGroupByAdmin.Outputs>>> GetScenarioGroupByAdmin(GetScenarioGroupByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetScenarioGroupByAdmin.Query(inputs, cancellationToken); }
    }
}
