﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.SendRemittanceToIran;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class SendRemittanceToIranCotext: ISendRemittanceToIranCotext
    {
        #region properties
        private string _connectionString { get; set; }
        private readonly IFileService _fileServices;
   
        #endregion properties

        private readonly DP.DapperORM.BaseSP<Get_OrderSendRemittanceToIran_Price.Inputs, Get_OrderSendRemittanceToIran_Price.Outputs> _Get_OrderSendRemittanceToIran_Price;
        private readonly DP.DapperORM.BaseSP<Get_OrderSendRemittanceToIran_Price_Servant.Inputs, Get_OrderSendRemittanceToIran_Price_Servant.Outputs> _Get_OrderSendRemittanceToIran_Price_Servant;
        private readonly DP.DapperORM.BaseSP<GetOrder_SendRemittanceToIran.Inputs, GetOrder_SendRemittanceToIran.Outputs> _GetOrder_SendRemittanceToIran;
        private readonly DP.DapperORM.BaseSP<GetOrder_SendRemittanceToIranByAdmin.Inputs, GetOrder_SendRemittanceToIranByAdmin.Outputs> _GetOrder_SendRemittanceToIranByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderSendRemittanceToIranByCustomer.Inputs, Insert_OrderSendRemittanceToIranByCustomer.Outputs> _Insert_OrderSendRemittanceToIranByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderSendRemittanceToIranByCompany.Inputs, Insert_OrderSendRemittanceToIranByCompany.Outputs> _Insert_OrderSendRemittanceToIranByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderSendRemittanceToIranByAdmin.Inputs, Insert_OrderSendRemittanceToIranByAdmin.Outputs> _Insert_OrderSendRemittanceToIranByAdmin;

        public SendRemittanceToIranCotext(IConfiguration configuration, IFileService fileServices)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _fileServices = fileServices;

            _Get_OrderSendRemittanceToIran_Price = new DP.DapperORM.BaseSP<Get_OrderSendRemittanceToIran_Price.Inputs, Get_OrderSendRemittanceToIran_Price.Outputs>("Order.Get_OrderSendRemittanceToIran_Price", executer);
            _Get_OrderSendRemittanceToIran_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderSendRemittanceToIran_Price_Servant.Inputs, Get_OrderSendRemittanceToIran_Price_Servant.Outputs>("Order.Get_OrderSendRemittanceToIran_Price_Servant", executer);
            _GetOrder_SendRemittanceToIranByAdmin = new DP.DapperORM.BaseSP<GetOrder_SendRemittanceToIranByAdmin.Inputs, GetOrder_SendRemittanceToIranByAdmin.Outputs>("Order.GetOrder_SendRemittanceToIranByAdmin", executer);
            _GetOrder_SendRemittanceToIran = new DP.DapperORM.BaseSP<GetOrder_SendRemittanceToIran.Inputs, GetOrder_SendRemittanceToIran.Outputs>("Order.GetOrder_SendRemittanceToIran", executer);
            _Insert_OrderSendRemittanceToIranByCustomer = new DP.DapperORM.BaseSP<Insert_OrderSendRemittanceToIranByCustomer.Inputs, Insert_OrderSendRemittanceToIranByCustomer.Outputs>("Order.Insert_OrderSendRemittanceToIranByCustomer", executer);
            _Insert_OrderSendRemittanceToIranByCompany = new DP.DapperORM.BaseSP<Insert_OrderSendRemittanceToIranByCompany.Inputs, Insert_OrderSendRemittanceToIranByCompany.Outputs>("Order.Insert_OrderSendRemittanceToIranByCompany", executer);
            _Insert_OrderSendRemittanceToIranByAdmin = new DP.DapperORM.BaseSP<Insert_OrderSendRemittanceToIranByAdmin.Inputs, Insert_OrderSendRemittanceToIranByAdmin.Outputs>("Order.Insert_OrderSendRemittanceToIranByAdmin", executer);

        }
        public async Task<DBResult<Get_OrderSendRemittanceToIran_Price.Outputs>> Get_OrderSendRemittanceToIran_Price(Get_OrderSendRemittanceToIran_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderSendRemittanceToIran_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderSendRemittanceToIran_Price_Servant.Outputs>> Get_OrderSendRemittanceToIran_Price_Servant(Get_OrderSendRemittanceToIran_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderSendRemittanceToIran_Price_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_SendRemittanceToIran.Outputs>>> GetOrder_SendRemittanceToIran(GetOrder_SendRemittanceToIran.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_SendRemittanceToIran.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_SendRemittanceToIranByAdmin.Outputs>>> GetOrder_SendRemittanceToIranByAdmin(GetOrder_SendRemittanceToIranByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_SendRemittanceToIranByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderSendRemittanceToIranByCustomer.Outputs>> Insert_OrderSendRemittanceToIranByCustomer(Insert_OrderSendRemittanceToIranByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderSendRemittanceToIranByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderSendRemittanceToIranByCompany.Outputs>> Insert_OrderSendRemittanceToIranByCompany(Insert_OrderSendRemittanceToIranByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderSendRemittanceToIranByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderSendRemittanceToIranByAdmin.Outputs>> Insert_OrderSendRemittanceToIranByAdmin(Insert_OrderSendRemittanceToIranByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderSendRemittanceToIranByAdmin.Single(inputs, cancellationToken); }

    }
}
