﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Swift;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class SwiftTransfreContext : ISwiftTransfreContext
    {
        private readonly RedisService _redis;
        private readonly IFileService _fileServices;
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<GetOrder_SwiftTransfer.Inputs, GetOrder_SwiftTransfer.Outputs> _GetOrder_SwiftTransfer;
        private readonly DP.DapperORM.BaseSP<GetOrder_SwiftTransferByAdmin.Inputs, GetOrder_SwiftTransferByAdmin.Outputs> _GetOrder_SwiftTransferByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderSwiftTransferByAdmin.Inputs, Insert_OrderSwiftTransferByAdmin.Outputs> _Insert_OrderSwiftTransferByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderSwiftTransferByCustomer.Inputs, Insert_OrderSwiftTransferByCustomer.Outputs> _Insert_OrderSwiftTransferByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderSwiftTransferByCompany.Inputs, Insert_OrderSwiftTransferByCompany.Outputs> _Insert_OrderSwiftTransferByCompany;
        private readonly DP.DapperORM.BaseSP<Get_OrderSwiftTransfer_Price.Inputs, Get_OrderSwiftTransfer_Price.Outputs> _Get_OrderSwiftTransfer_Price;
        private readonly DP.DapperORM.BaseSP<Get_OrderSwiftTransfer_Price_Servant.Inputs, Get_OrderSwiftTransfer_Price_Servant.Outputs> _Get_OrderSwiftTransfer_Price_Servant;
        public SwiftTransfreContext(IConfiguration configuration, RedisService redis, IFileService fileServices)
        {
            _fileServices = fileServices;
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetOrder_SwiftTransfer = new DP.DapperORM.BaseSP<GetOrder_SwiftTransfer.Inputs, GetOrder_SwiftTransfer.Outputs>("Order.GetOrder_SwiftTransfer", executer);
            _GetOrder_SwiftTransferByAdmin = new DP.DapperORM.BaseSP<GetOrder_SwiftTransferByAdmin.Inputs, GetOrder_SwiftTransferByAdmin.Outputs>("Order.GetOrder_SwiftTransferByAdmin", executer);
            _Insert_OrderSwiftTransferByAdmin = new DP.DapperORM.BaseSP<Insert_OrderSwiftTransferByAdmin.Inputs, Insert_OrderSwiftTransferByAdmin.Outputs>("Order.Insert_OrderSwiftTransferByAdmin", executer);
            _Insert_OrderSwiftTransferByCustomer = new DP.DapperORM.BaseSP<Insert_OrderSwiftTransferByCustomer.Inputs, Insert_OrderSwiftTransferByCustomer.Outputs>("Order.Insert_OrderSwiftTransferByCustomer", executer);
            _Insert_OrderSwiftTransferByCompany = new DP.DapperORM.BaseSP<Insert_OrderSwiftTransferByCompany.Inputs, Insert_OrderSwiftTransferByCompany.Outputs>("Order.Insert_OrderSwiftTransferByCompany", executer);


            _Get_OrderSwiftTransfer_Price = new DP.DapperORM.BaseSP<Get_OrderSwiftTransfer_Price.Inputs, Get_OrderSwiftTransfer_Price.Outputs>("Order.Get_OrderSwiftTransfer_Price", executer);
            _Get_OrderSwiftTransfer_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderSwiftTransfer_Price_Servant.Inputs, Get_OrderSwiftTransfer_Price_Servant.Outputs>("Order.Get_OrderSwiftTransfer_Price_Servant", executer);
        }

        public async Task<DBResult<IEnumerable<GetOrder_SwiftTransfer.Outputs>>> GetOrder_SwiftTransfer(GetOrder_SwiftTransfer.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_SwiftTransfer.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_SwiftTransferByAdmin.Outputs>>> GetOrder_SwiftTransferByAdmin(GetOrder_SwiftTransferByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_SwiftTransferByAdmin.Query(inputs, cancellationToken); }

        public async Task<DBResult<Insert_OrderSwiftTransferByAdmin.Outputs>> Insert_OrderSwiftTransferByAdmin(Insert_OrderSwiftTransferByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderSwiftTransferByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderSwiftTransferByCustomer.Outputs>> Insert_OrderSwiftTransferByCustomer(Insert_OrderSwiftTransferByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderSwiftTransferByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderSwiftTransferByCompany.Outputs>> Insert_OrderSwiftTransferByCompany(Insert_OrderSwiftTransferByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderSwiftTransferByCompany.Single(inputs, cancellationToken); }


        public async Task<DBResult<Get_OrderSwiftTransfer_Price.Outputs>> Get_OrderSwiftTransfer_Price(Get_OrderSwiftTransfer_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            return await _Get_OrderSwiftTransfer_Price.Single(inputs, cancellationToken);
        }
        public async Task<DBResult<Get_OrderSwiftTransfer_Price_Servant.Outputs>> Get_OrderSwiftTransfer_Price_Servant(Get_OrderSwiftTransfer_Price_Servant.Inputs inputs, CancellationToken cancellationToken)
        {
            return await _Get_OrderSwiftTransfer_Price_Servant.Single(inputs, cancellationToken);
        }

    }
}
