﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class TransActionContext : ITransActionContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<GetTransActionsByAdmin.Inputs, GetTransActionsByAdmin.Outputs> _GetTransActionsByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_TransactionByAdmin.Inputs, Insert_TransactionByAdmin.Outputs> _Insert_TransactionByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_Transaction_Wallet.Inputs, Insert_Transaction_Wallet.Outputs> _Insert_Transaction_Wallet;
        private readonly DP.DapperORM.BaseSP<Update_Transaction_Wallet.Inputs, Update_Transaction_Wallet.Outputs> _Update_Transaction_Wallet;
        private readonly DP.DapperORM.BaseSP<Update_Transaction_Wallet_Order.Inputs, Update_Transaction_Wallet_Order.Outputs> _Update_Transaction_Wallet_Order;
        private readonly DP.DapperORM.BaseSP<Check_TransAction_Wallet.Inputs, Check_TransAction_Wallet.Outputs> _Check_TransAction_Wallet;

        private readonly DP.DapperORM.BaseSP<Insert_Transaction_WithoutToken.Inputs, Insert_Transaction_WithoutToken.Outputs> _Insert_Transaction_WithoutToken;
        private readonly DP.DapperORM.BaseSP<Get_Order_Transaction_WithouToken.Inputs, Get_Order_Transaction_WithouToken.Outputs> _Get_Order_Transaction_WithouToken;
        private readonly DP.DapperORM.BaseSP<Update_Transaction_Free_Order_WithoutToken.Inputs, Update_Transaction_Free_Order_WithoutToken.Outputs> _Update_Transaction_Free_Order_WithoutToken;
        private readonly DP.DapperORM.BaseSP<GetTransActions.Inputs, GetTransActions.Outputs> _GetTransActions;
        private readonly DP.DapperORM.BaseSP<Insert_Transaction.Inputs, Insert_Transaction.Outputs> _Insert_Transaction;
        private readonly DP.DapperORM.BaseSP<Update_Transaction.Inputs, Update_Transaction.Outputs> _Update_Transaction;
        private readonly DP.DapperORM.BaseSP<GetTransActionByPaidCode.Inputs, GetTransActionByPaidCode.Outputs> _GetTransActionByPaidCode;
        private readonly DP.DapperORM.BaseSP<GetTransActionsIsPaid.Inputs, GetTransActionsIsPaid.Outputs> _GetTransActionsIsPaid;
        private readonly DP.DapperORM.BaseSP<Update_Transaction_Free_Order.Inputs, Update_Transaction_Free_Order.Outputs> _Update_Transaction_Free_Order;
        private readonly DP.DapperORM.BaseSP<Check_Duplicate_Transaction.Inputs, Check_Duplicate_Transaction.Outputs> _Check_Duplicate_Transaction;
        private readonly DP.DapperORM.BaseSP<Check_Duplicate_Transaction_Wallet.Inputs, Check_Duplicate_Transaction_Wallet.Outputs> _Check_Duplicate_Transaction_Wallet;
        private readonly DP.DapperORM.BaseSP<Insert_TransactionCryptocurrency.Inputs, Insert_TransactionCryptocurrency.Outputs> _Insert_TransactionCryptocurrency;
        private readonly DP.DapperORM.BaseSP<Update_TransactionCryptocurrency.Inputs, Update_TransactionCryptocurrency.Outputs> _Update_TransactionCryptocurrency;
        private readonly DP.DapperORM.BaseSP<Change_Status_Transaction.Inputs, Change_Status_Transaction.Outputs> _Change_Status_Transaction;

        public TransActionContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetTransActionsByAdmin = new DP.DapperORM.BaseSP<GetTransActionsByAdmin.Inputs, GetTransActionsByAdmin.Outputs>("Order.GetTransActionsByAdmin", executer);
            _Insert_TransactionByAdmin = new DP.DapperORM.BaseSP<Insert_TransactionByAdmin.Inputs, Insert_TransactionByAdmin.Outputs>("Order.Insert_TransactionByAdmin", executer);
            _Insert_Transaction_Wallet = new DP.DapperORM.BaseSP<Insert_Transaction_Wallet.Inputs, Insert_Transaction_Wallet.Outputs>("Order.Insert_Transaction_Wallet", executer);
            _Update_Transaction_Wallet = new DP.DapperORM.BaseSP<Update_Transaction_Wallet.Inputs, Update_Transaction_Wallet.Outputs>("Order.Update_Transaction_Wallet", executer);
            _Update_Transaction_Wallet_Order = new DP.DapperORM.BaseSP<Update_Transaction_Wallet_Order.Inputs, Update_Transaction_Wallet_Order.Outputs>("Order.Update_Transaction_Wallet_Order", executer);
            _Insert_Transaction_WithoutToken = new DP.DapperORM.BaseSP<Insert_Transaction_WithoutToken.Inputs, Insert_Transaction_WithoutToken.Outputs>("Order.Insert_Transaction_WithoutToken", executer);
            _Get_Order_Transaction_WithouToken = new DP.DapperORM.BaseSP<Get_Order_Transaction_WithouToken.Inputs, Get_Order_Transaction_WithouToken.Outputs>("Order.Get_Order_Transaction_WithouToken", executer);
            _Check_TransAction_Wallet = new DP.DapperORM.BaseSP<Check_TransAction_Wallet.Inputs, Check_TransAction_Wallet.Outputs>("Order.Check_TransAction_Wallet", executer);
            _Update_Transaction_Free_Order_WithoutToken = new DP.DapperORM.BaseSP<Update_Transaction_Free_Order_WithoutToken.Inputs, Update_Transaction_Free_Order_WithoutToken.Outputs>("Order.Update_Transaction_Free_Order_WithoutToken", executer);
            _GetTransActions = new DP.DapperORM.BaseSP<GetTransActions.Inputs, GetTransActions.Outputs>("Order.GetTransActions", executer);
            _Insert_Transaction = new DP.DapperORM.BaseSP<Insert_Transaction.Inputs, Insert_Transaction.Outputs>("Order.Insert_Transaction", executer);
            _Update_Transaction = new DP.DapperORM.BaseSP<Update_Transaction.Inputs, Update_Transaction.Outputs>("Order.Update_Transaction", executer);
            _GetTransActionByPaidCode = new DP.DapperORM.BaseSP<GetTransActionByPaidCode.Inputs, GetTransActionByPaidCode.Outputs>("Order.GetTransActionByPaidCode", executer);
            _GetTransActionsIsPaid = new DP.DapperORM.BaseSP<GetTransActionsIsPaid.Inputs, GetTransActionsIsPaid.Outputs>("Order.GetTransActionsIsPaid", executer);
            _Update_Transaction_Free_Order = new DP.DapperORM.BaseSP<Update_Transaction_Free_Order.Inputs, Update_Transaction_Free_Order.Outputs>("Order.Update_Transaction_Free_Order", executer);
            _Check_Duplicate_Transaction = new DP.DapperORM.BaseSP<Check_Duplicate_Transaction.Inputs, Check_Duplicate_Transaction.Outputs>("Order.Check_Duplicate_Transaction", executer);
            _Check_Duplicate_Transaction_Wallet = new DP.DapperORM.BaseSP<Check_Duplicate_Transaction_Wallet.Inputs, Check_Duplicate_Transaction_Wallet.Outputs>("Order.Check_Duplicate_Transaction_Wallet", executer);
            _Insert_TransactionCryptocurrency = new DP.DapperORM.BaseSP<Insert_TransactionCryptocurrency.Inputs, Insert_TransactionCryptocurrency.Outputs>("Order.Insert_TransactionCryptocurrency", executer);
            _Update_TransactionCryptocurrency = new DP.DapperORM.BaseSP<Update_TransactionCryptocurrency.Inputs, Update_TransactionCryptocurrency.Outputs>("Order.Update_TransactionCryptocurrency", executer);
            _Change_Status_Transaction = new DP.DapperORM.BaseSP<Change_Status_Transaction.Inputs, Change_Status_Transaction.Outputs>("Order.Change_Status_Transaction", executer);
        }

        public async Task<DBResult<IEnumerable<GetTransActionsByAdmin.Outputs>>> GetTransActionsByAdmin(GetTransActionsByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetTransActionsByAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_TransactionByAdmin(Insert_TransactionByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_TransactionByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Transaction_Wallet.Outputs>> Insert_Transaction_Wallet(Insert_Transaction_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Transaction_Wallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Transaction_WithoutToken.Outputs>> Insert_Transaction_WithoutToken(Insert_Transaction_WithoutToken.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Transaction_WithoutToken.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Transaction_Wallet.Outputs>> Update_Transaction_Wallet(Update_Transaction_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Transaction_Wallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Transaction_Wallet_Order.Outputs>> Update_Transaction_Wallet_Order(Update_Transaction_Wallet_Order.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Transaction_Wallet_Order.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Order_Transaction_WithouToken.Outputs>> Get_Order_Transaction_WithouToken(Get_Order_Transaction_WithouToken.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Order_Transaction_WithouToken.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Transaction_Free_Order_WithoutToken.Outputs>> Update_Transaction_Free_Order_WithoutToken(Update_Transaction_Free_Order_WithoutToken.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Transaction_Free_Order_WithoutToken.Single(inputs, cancellationToken); }
        public async Task<DBResult<Check_TransAction_Wallet.Outputs>> Check_TransAction_Wallet(Check_TransAction_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Check_TransAction_Wallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetTransActions.Outputs>>> GetTransActions(GetTransActions.Inputs inputs, CancellationToken cancellationToken) { return await _GetTransActions.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Transaction.Outputs>> Insert_Transaction(Insert_Transaction.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Transaction.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Transaction.Outputs>> Update_Transaction(Update_Transaction.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Transaction.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetTransActionByPaidCode.Outputs>> GetTransActionByPaidCode(GetTransActionByPaidCode.Inputs inputs, CancellationToken cancellationToken) { return await _GetTransActionByPaidCode.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetTransActionsIsPaid.Outputs>> GetTransActionsIsPaid(GetTransActionsIsPaid.Inputs inputs, CancellationToken cancellationToken) { return await _GetTransActionsIsPaid.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Transaction_Free_Order.Outputs>> Update_Transaction_Free_Order(Update_Transaction_Free_Order.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Transaction_Free_Order.Single(inputs, cancellationToken); }
        public async Task<DBResult<Check_Duplicate_Transaction.Outputs>> Check_Duplicate_Transaction(Check_Duplicate_Transaction.Inputs inputs, CancellationToken cancellationToken) { return await _Check_Duplicate_Transaction.Single(inputs, cancellationToken); }
        public async Task<DBResult<Check_Duplicate_Transaction_Wallet.Outputs>> Check_Duplicate_Transaction_Wallet(Check_Duplicate_Transaction_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Check_Duplicate_Transaction_Wallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_TransactionCryptocurrency.Outputs>> Insert_TransactionCryptocurrency(Insert_TransactionCryptocurrency.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_TransactionCryptocurrency.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_TransactionCryptocurrency.Outputs>> Update_TransactionCryptocurrency(Update_TransactionCryptocurrency.Inputs inputs, CancellationToken cancellationToken) { return await _Update_TransactionCryptocurrency.Single(inputs, cancellationToken); }
        public async Task<DBResult> Change_Status_Transaction(Change_Status_Transaction.Inputs inputs, CancellationToken cancellationToken) { return await _Change_Status_Transaction.Execute(inputs, cancellationToken); }
    }
}
