﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IServices.IApp;
using Farakonesh.Logic.Services.App;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using Farakonesh.Models.Database.StoredProcedures.App.Order.VirtualServers;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class VirtualServerContext: IVirtualServerContext
    {
        #region properties
        private string _connectionString { get; set; }
        private readonly IFileService _fileServices;
     
        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_OrderVirtualServerAccountRenewalByAdmin.Inputs, Insert_OrderVirtualServerAccountRenewalByAdmin.Outputs> _Insert_OrderVirtualServerAccountRenewalByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderVirtualServerByAdmin.Inputs, Insert_OrderVirtualServerByAdmin.Outputs> _Insert_OrderVirtualServerByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderVirtualServerByCustomer.Inputs, Insert_OrderVirtualServerByCustomer.Outputs> _Insert_OrderVirtualServerByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderVirtualServerAccountRenewalByCompany.Inputs, Insert_OrderVirtualServerAccountRenewalByCompany.Outputs> _Insert_OrderVirtualServerAccountRenewalByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderVirtualServerByCompany.Inputs, Insert_OrderVirtualServerByCompany.Outputs> _Insert_OrderVirtualServerByCompany;
        private readonly DP.DapperORM.BaseSP<Get_OrderVirtualServers_Price.Inputs, Get_OrderVirtualServers_Price.Outputs> _Get_OrderVirtualServers_Price;
        private readonly DP.DapperORM.BaseSP<GetOrder_VirtualServers.Inputs, GetOrder_VirtualServers.Outputs> _GetOrder_VirtualServers;
        private readonly DP.DapperORM.BaseSP<GetOrder_VirtualServersByAdmin.Inputs, GetOrder_VirtualServersByAdmin.Outputs> _GetOrder_VirtualServersByAdmin;
        private readonly DP.DapperORM.BaseSP<Update_OrderVirtualServerByAdmin.Inputs, Update_OrderVirtualServerByAdmin.Outputs> _Update_OrderVirtualServerByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderVirtualServerAccountRenewalByCustomer.Inputs, Insert_OrderVirtualServerAccountRenewalByCustomer.Outputs> _Insert_OrderVirtualServerAccountRenewalByCustomer;
        private readonly DP.DapperORM.BaseSP<Get_OrderVirtualServers_AccountRenewal_Price.Inputs, Get_OrderVirtualServers_AccountRenewal_Price.Outputs> _Get_OrderVirtualServers_AccountRenewal_Price;

        public VirtualServerContext(IConfiguration configuration, IFileService fileServices)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _fileServices = fileServices;
            _GetOrder_VirtualServers = new DP.DapperORM.BaseSP<GetOrder_VirtualServers.Inputs, GetOrder_VirtualServers.Outputs>("Order.GetOrder_VirtualServers", executer);
            _GetOrder_VirtualServersByAdmin = new DP.DapperORM.BaseSP<GetOrder_VirtualServersByAdmin.Inputs, GetOrder_VirtualServersByAdmin.Outputs>("Order.GetOrder_VirtualServersByAdmin", executer);
            _Insert_OrderVirtualServerByCustomer = new DP.DapperORM.BaseSP<Insert_OrderVirtualServerByCustomer.Inputs, Insert_OrderVirtualServerByCustomer.Outputs>("Order.Insert_OrderVirtualServerByCustomer", executer);
            _Insert_OrderVirtualServerByCompany = new DP.DapperORM.BaseSP<Insert_OrderVirtualServerByCompany.Inputs, Insert_OrderVirtualServerByCompany.Outputs>("Order.Insert_OrderVirtualServerByCompany", executer);
            _Get_OrderVirtualServers_Price = new DP.DapperORM.BaseSP<Get_OrderVirtualServers_Price.Inputs, Get_OrderVirtualServers_Price.Outputs>("Order.Get_OrderVirtualServers_Price", executer);
            _Update_OrderVirtualServerByAdmin = new DP.DapperORM.BaseSP<Update_OrderVirtualServerByAdmin.Inputs, Update_OrderVirtualServerByAdmin.Outputs>("Order.Update_OrderVirtualServerByAdmin", executer);
            _Get_OrderVirtualServers_AccountRenewal_Price = new DP.DapperORM.BaseSP<Get_OrderVirtualServers_AccountRenewal_Price.Inputs, Get_OrderVirtualServers_AccountRenewal_Price.Outputs>("Order.Get_OrderVirtualServers_AccountRenewal_Price", executer);
            _Insert_OrderVirtualServerAccountRenewalByCustomer = new DP.DapperORM.BaseSP<Insert_OrderVirtualServerAccountRenewalByCustomer.Inputs, Insert_OrderVirtualServerAccountRenewalByCustomer.Outputs>("Order.Insert_OrderVirtualServerAccountRenewalByCustomer", executer);
            _Insert_OrderVirtualServerAccountRenewalByCompany = new DP.DapperORM.BaseSP<Insert_OrderVirtualServerAccountRenewalByCompany.Inputs, Insert_OrderVirtualServerAccountRenewalByCompany.Outputs>("Order.Insert_OrderVirtualServerAccountRenewalByCompany", executer);
            _Insert_OrderVirtualServerAccountRenewalByAdmin = new DP.DapperORM.BaseSP<Insert_OrderVirtualServerAccountRenewalByAdmin.Inputs, Insert_OrderVirtualServerAccountRenewalByAdmin.Outputs>("Order.Insert_OrderVirtualServerAccountRenewalByAdmin", executer);
            _Insert_OrderVirtualServerByAdmin = new DP.DapperORM.BaseSP<Insert_OrderVirtualServerByAdmin.Inputs, Insert_OrderVirtualServerByAdmin.Outputs>("Order.Insert_OrderVirtualServerByAdmin", executer);
        }
        public async Task<DBResult<IEnumerable<GetOrder_VirtualServers.Outputs>>> GetOrder_VirtualServers(GetOrder_VirtualServers.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_VirtualServers.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_VirtualServersByAdmin.Outputs>>> GetOrder_VirtualServersByAdmin(GetOrder_VirtualServersByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_VirtualServersByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderVirtualServers_Price.Outputs>> Get_OrderVirtualServers_Price(Get_OrderVirtualServers_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderVirtualServers_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderVirtualServerByCustomer.Outputs>> Insert_OrderVirtualServerByCustomer(Insert_OrderVirtualServerByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderVirtualServerByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderVirtualServerByCompany.Outputs>> Insert_OrderVirtualServerByCompany(Insert_OrderVirtualServerByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderVirtualServerByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderVirtualServerAccountRenewalByCompany.Outputs>> Insert_OrderVirtualServerAccountRenewalByCompany(Insert_OrderVirtualServerAccountRenewalByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderVirtualServerAccountRenewalByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderVirtualServerByAdmin.Outputs>> Insert_OrderVirtualServerByAdmin(Insert_OrderVirtualServerByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderVirtualServerByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderVirtualServerAccountRenewalByCustomer.Outputs>> Insert_OrderVirtualServerAccountRenewalByCustomer(Insert_OrderVirtualServerAccountRenewalByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderVirtualServerAccountRenewalByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderVirtualServerAccountRenewalByAdmin.Outputs>> Insert_OrderVirtualServerAccountRenewalByAdmin(Insert_OrderVirtualServerAccountRenewalByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderVirtualServerAccountRenewalByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderVirtualServers_AccountRenewal_Price.Outputs>> Get_OrderVirtualServers_AccountRenewal_Price(Get_OrderVirtualServers_AccountRenewal_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderVirtualServers_AccountRenewal_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult> Update_OrderVirtualServerByAdmin(Update_OrderVirtualServerByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Update_OrderVirtualServerByAdmin.Execute(inputs, cancellationToken); }
    }
}
