﻿using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order.WeightFee;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Wise;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class WeightFeeContext : IWeightFeeContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Get_WeightFee.Inputs, Get_WeightFee.Outputs> _Get_WeightFee;
        private readonly DP.DapperORM.BaseSP<Insert_WeightFee.Inputs, Insert_WeightFee.Outputs> _Insert_WeightFee;
        private readonly DP.DapperORM.BaseSP<Update_WeightFee.Inputs, Update_WeightFee.Outputs> _Update_WeightFee;
        private readonly DP.DapperORM.BaseSP<Delete_WeightFee.Inputs, Delete_WeightFee.Outputs> _Delete_WeightFee;
        public WeightFeeContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Get_WeightFee = new DP.DapperORM.BaseSP<Get_WeightFee.Inputs, Get_WeightFee.Outputs>("Order.Get_WeightFee", executer);
            _Insert_WeightFee = new DP.DapperORM.BaseSP<Insert_WeightFee.Inputs, Insert_WeightFee.Outputs>("Order.Insert_WeightFee", executer);
            _Update_WeightFee = new DP.DapperORM.BaseSP<Update_WeightFee.Inputs, Update_WeightFee.Outputs>("Order.Update_WeightFee", executer);
            _Delete_WeightFee = new DP.DapperORM.BaseSP<Delete_WeightFee.Inputs, Delete_WeightFee.Outputs>("Order.Delete_WeightFee", executer);
        }
        public async Task<DBResult<IEnumerable<Get_WeightFee.Outputs>>> Get_WeightFee(Get_WeightFee.Inputs inputs, CancellationToken cancellationToken) { return await _Get_WeightFee.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_WeightFee(Insert_WeightFee.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_WeightFee.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_WeightFee(Update_WeightFee.Inputs inputs, CancellationToken cancellationToken) { return await _Update_WeightFee.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_WeightFee(Delete_WeightFee.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_WeightFee.Execute(inputs, cancellationToken); }

    }
}
