﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Wise;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Order
{
    public class WiseContext: IWiseContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<GetOrder_WiseSell.Inputs, GetOrder_WiseSell.Outputs> _GetOrder_WiseSell;
        private readonly DP.DapperORM.BaseSP<GetOrder_WiseSellByAdmin.Inputs, GetOrder_WiseSellByAdmin.Outputs> _GetOrder_WiseSellByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderWiseSellByCustomer.Inputs, Insert_OrderWiseSellByCustomer.Outputs> _Insert_OrderWiseSellByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderWiseSellByCompany.Inputs, Insert_OrderWiseSellByCompany.Outputs> _Insert_OrderWiseSellByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_OrderWiseSellByAdmin.Inputs, Insert_OrderWiseSellByAdmin.Outputs> _Insert_OrderWiseSellByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_OrderWiseAccountChargeByAdmin.Inputs, Insert_OrderWiseAccountChargeByAdmin.Outputs> _Insert_OrderWiseAccountChargeByAdmin;
        private readonly DP.DapperORM.BaseSP<Update_OrderWiseSellByCustomer.Inputs, Update_OrderWiseSellByCustomer.Outputs> _Update_OrderWiseSellByCustomer;
        private readonly DP.DapperORM.BaseSP<Get_OrderWiseSell_Price.Inputs, Get_OrderWiseSell_Price.Outputs> _Get_OrderWiseSell_Price;
        private readonly DP.DapperORM.BaseSP<Get_OrderWiseSell_Price_Servant.Inputs, Get_OrderWiseSell_Price_Servant.Outputs> _Get_OrderWiseSell_Price_Servant;
        private readonly DP.DapperORM.BaseSP<Get_OrderWiseAccountCharge_Price_Servant.Inputs, Get_OrderWiseAccountCharge_Price_Servant.Outputs> _Get_OrderWiseAccountCharge_Price_Servant;
        private readonly DP.DapperORM.BaseSP<Insert_OrderWiseAccountChargeByCustomer.Inputs, Insert_OrderWiseAccountChargeByCustomer.Outputs> _Insert_OrderWiseAccountChargeByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_OrderWiseAccountChargeByCompany.Inputs, Insert_OrderWiseAccountChargeByCompany.Outputs> _Insert_OrderWiseAccountChargeByCompany;
        private readonly DP.DapperORM.BaseSP<GetOrder_WiseAccountCharge.Inputs, GetOrder_WiseAccountCharge.Outputs> _GetOrder_WiseAccountCharge;
        private readonly DP.DapperORM.BaseSP<GetOrder_WiseAccountChargeByAdmin.Inputs, GetOrder_WiseAccountChargeByAdmin.Outputs> _GetOrder_WiseAccountChargeByAdmin;
        private readonly DP.DapperORM.BaseSP<Get_OrderWiseAccountCharge_Price.Inputs, Get_OrderWiseAccountCharge_Price.Outputs> _Get_OrderWiseAccountCharge_Price;
        private readonly DP.DapperORM.BaseSP<GetOrder_WiseAccountChargeAnonymous.Inputs, GetOrder_WiseAccountChargeAnonymous.Outputs> _GetOrder_WiseAccountChargeAnonymous;
        private readonly DP.DapperORM.BaseSP<Update_OrderWiseChargeByCustomer.Inputs, Update_OrderWiseChargeByCustomer.Outputs> _Update_OrderWiseChargeByCustomer;
        public WiseContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetOrder_WiseSell = new DP.DapperORM.BaseSP<GetOrder_WiseSell.Inputs, GetOrder_WiseSell.Outputs>("Order.GetOrder_WiseSell", executer);
            _GetOrder_WiseSellByAdmin = new DP.DapperORM.BaseSP<GetOrder_WiseSellByAdmin.Inputs, GetOrder_WiseSellByAdmin.Outputs>("Order.GetOrder_WiseSellByAdmin", executer);
            _Get_OrderWiseSell_Price = new DP.DapperORM.BaseSP<Get_OrderWiseSell_Price.Inputs, Get_OrderWiseSell_Price.Outputs>("Order.Get_OrderWiseSell_Price", executer);
            _Get_OrderWiseSell_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderWiseSell_Price_Servant.Inputs, Get_OrderWiseSell_Price_Servant.Outputs>("Order.Get_OrderWiseSell_Price_Servant", executer);
            _Get_OrderWiseAccountCharge_Price_Servant = new DP.DapperORM.BaseSP<Get_OrderWiseAccountCharge_Price_Servant.Inputs, Get_OrderWiseAccountCharge_Price_Servant.Outputs>("Order.Get_OrderWiseAccountCharge_Price_Servant", executer);
            _Insert_OrderWiseSellByCustomer = new DP.DapperORM.BaseSP<Insert_OrderWiseSellByCustomer.Inputs, Insert_OrderWiseSellByCustomer.Outputs>("Order.Insert_OrderWiseSellByCustomer", executer);
            _Insert_OrderWiseSellByCompany = new DP.DapperORM.BaseSP<Insert_OrderWiseSellByCompany.Inputs, Insert_OrderWiseSellByCompany.Outputs>("Order.Insert_OrderWiseSellByCompany", executer);
            _Insert_OrderWiseSellByAdmin = new DP.DapperORM.BaseSP<Insert_OrderWiseSellByAdmin.Inputs, Insert_OrderWiseSellByAdmin.Outputs>("Order.Insert_OrderWiseSellByAdmin", executer);
            _Insert_OrderWiseAccountChargeByAdmin = new DP.DapperORM.BaseSP<Insert_OrderWiseAccountChargeByAdmin.Inputs, Insert_OrderWiseAccountChargeByAdmin.Outputs>("Order.Insert_OrderWiseAccountChargeByAdmin", executer);
            _Update_OrderWiseSellByCustomer = new DP.DapperORM.BaseSP<Update_OrderWiseSellByCustomer.Inputs, Update_OrderWiseSellByCustomer.Outputs>("Order.Update_OrderWiseSellByCustomer", executer);

            _Insert_OrderWiseAccountChargeByCustomer = new DP.DapperORM.BaseSP<Insert_OrderWiseAccountChargeByCustomer.Inputs, Insert_OrderWiseAccountChargeByCustomer.Outputs>("Order.Insert_OrderWiseAccountChargeByCustomer", executer);
            _Insert_OrderWiseAccountChargeByCompany = new DP.DapperORM.BaseSP<Insert_OrderWiseAccountChargeByCompany.Inputs, Insert_OrderWiseAccountChargeByCompany.Outputs>("Order.Insert_OrderWiseAccountChargeByCompany", executer);
            _GetOrder_WiseAccountCharge = new DP.DapperORM.BaseSP<GetOrder_WiseAccountCharge.Inputs, GetOrder_WiseAccountCharge.Outputs>("Order.GetOrder_WiseAccountCharge", executer);
            _GetOrder_WiseAccountChargeByAdmin = new DP.DapperORM.BaseSP<GetOrder_WiseAccountChargeByAdmin.Inputs, GetOrder_WiseAccountChargeByAdmin.Outputs>("Order.GetOrder_WiseAccountChargeByAdmin", executer);
            _Get_OrderWiseAccountCharge_Price = new DP.DapperORM.BaseSP<Get_OrderWiseAccountCharge_Price.Inputs, Get_OrderWiseAccountCharge_Price.Outputs>("Order.Get_OrderWiseAccountCharge_Price", executer);
            _GetOrder_WiseAccountChargeAnonymous = new DP.DapperORM.BaseSP<GetOrder_WiseAccountChargeAnonymous.Inputs, GetOrder_WiseAccountChargeAnonymous.Outputs>("Order.GetOrder_WiseAccountChargeAnonymous", executer);
            _Update_OrderWiseChargeByCustomer = new DP.DapperORM.BaseSP<Update_OrderWiseChargeByCustomer.Inputs, Update_OrderWiseChargeByCustomer.Outputs>("Order.Update_OrderWiseChargeByCustomer", executer);

        }
        public async Task<DBResult<Insert_OrderWiseSellByCustomer.Outputs>> Insert_OrderWiseSellByCustomer(Insert_OrderWiseSellByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderWiseSellByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderWiseSellByCompany.Outputs>> Insert_OrderWiseSellByCompany(Insert_OrderWiseSellByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderWiseSellByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderWiseSellByAdmin.Outputs>> Insert_OrderWiseSellByAdmin(Insert_OrderWiseSellByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderWiseSellByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderWiseAccountChargeByAdmin.Outputs>> Insert_OrderWiseAccountChargeByAdmin(Insert_OrderWiseAccountChargeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderWiseAccountChargeByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_OrderWiseSellByCustomer.Outputs>> Update_OrderWiseSellByCustomer(Update_OrderWiseSellByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Update_OrderWiseSellByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_WiseSell.Outputs>>> GetOrder_WiseSell(GetOrder_WiseSell.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_WiseSell.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_WiseSellByAdmin.Outputs>>> GetOrder_WiseSellByAdmin(GetOrder_WiseSellByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_WiseSellByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderWiseSell_Price.Outputs>> Get_OrderWiseSell_Price(Get_OrderWiseSell_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderWiseSell_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderWiseSell_Price_Servant.Outputs>> Get_OrderWiseSell_Price_Servant(Get_OrderWiseSell_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderWiseSell_Price_Servant.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderWiseAccountCharge_Price_Servant.Outputs>> Get_OrderWiseAccountCharge_Price_Servant(Get_OrderWiseAccountCharge_Price_Servant.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderWiseAccountCharge_Price_Servant.Single(inputs, cancellationToken); }

        public async Task<DBResult<Insert_OrderWiseAccountChargeByCustomer.Outputs>> Insert_OrderWiseAccountChargeByCustomer(Insert_OrderWiseAccountChargeByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderWiseAccountChargeByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_OrderWiseAccountChargeByCompany.Outputs>> Insert_OrderWiseAccountChargeByCompany(Insert_OrderWiseAccountChargeByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_OrderWiseAccountChargeByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_OrderWiseAccountCharge_Price.Outputs>> Get_OrderWiseAccountCharge_Price(Get_OrderWiseAccountCharge_Price.Inputs inputs, CancellationToken cancellationToken) { return await _Get_OrderWiseAccountCharge_Price.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_WiseAccountCharge.Outputs>>> GetOrder_WiseAccountCharge(GetOrder_WiseAccountCharge.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_WiseAccountCharge.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetOrder_WiseAccountChargeByAdmin.Outputs>>> GetOrder_WiseAccountChargeByAdmin(GetOrder_WiseAccountChargeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_WiseAccountChargeByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<GetOrder_WiseAccountChargeAnonymous.Outputs>> GetOrder_WiseAccountChargeAnonymous(GetOrder_WiseAccountChargeAnonymous.Inputs inputs, CancellationToken cancellationToken) { return await _GetOrder_WiseAccountChargeAnonymous.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_OrderWiseChargeByCustomer.Outputs>> Update_OrderWiseChargeByCustomer(Update_OrderWiseChargeByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Update_OrderWiseChargeByCustomer.Single(inputs, cancellationToken); }
    }
}
