﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.DP.DapperORM;

namespace Farakonesh.Logic.Database
{
    public class QueueContext:IQueueContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Insert_Sms.Inputs, Insert_Sms.Outputs> _Insert_Sms;
        private readonly DP.DapperORM.BaseSP<Update_Sms.Inputs, Update_Sms.Outputs> _Update_Sms;
        private readonly DP.DapperORM.BaseSP<Insert_Email.Inputs, Insert_Email.Outputs> _Insert_Email;
        private readonly DP.DapperORM.BaseSP<Update_Email.Inputs, Update_Email.Outputs> _Update_Email;
        private readonly DP.DapperORM.BaseSP<Insert_Token.Inputs, Insert_Token.Outputs> _Insert_Token;
        private readonly DP.DapperORM.BaseSP<Get_Tokens.Inputs, Get_Tokens.Outputs> _Get_Tokens;
        private readonly DP.DapperORM.BaseSP<Get_Last_Token.Inputs, Get_Last_Token.Outputs> _Get_Last_Token;
        private readonly DP.DapperORM.BaseSP<Get_Alarms.Inputs, Get_Alarms.Outputs> _Get_Alarms;
        private readonly DP.DapperORM.BaseSP<Insert_Alarm.Inputs, Insert_Alarm.Outputs> _Insert_Alarm;
        private readonly DP.DapperORM.BaseSP<Update_Alarm.Inputs, Update_Alarm.Outputs> _Update_Alarm;
        private readonly DP.DapperORM.BaseSP<Delete_Alarm.Inputs, Delete_Alarm.Outputs> _Delete_Alarm;
        private readonly DP.DapperORM.BaseSP<Delete_Alarm_User.Inputs, Delete_Alarm_User.Outputs> _Delete_Alarm_User;
        private readonly DP.DapperORM.BaseSP<Insert_Chat.Inputs, Insert_Chat.Outputs> _Insert_Chat;
        private readonly DP.DapperORM.BaseSP<Get_Chat.Inputs, Get_Chat.Outputs> _Get_Chat;
        private readonly DP.DapperORM.BaseSP<Get_Emails.Inputs, Get_Emails.Outputs> _Get_Emails;
        private readonly DP.DapperORM.BaseSP<Get_SMS.Inputs, Get_SMS.Outputs> _Get_SMS;
        private readonly DP.DapperORM.BaseSP<Get_Messengers.Inputs, Get_Messengers.Outputs> _Get_Messengers;
        private readonly DP.DapperORM.BaseSP<Insert_Messengers.Inputs, Insert_Messengers.Outputs> _Insert_Messengers;
        private readonly DP.DapperORM.BaseSP<Update_Messengers.Inputs, Update_Messengers.Outputs> _Update_Messengers;
        private readonly DP.DapperORM.BaseSP<Insert_Calendar.Inputs, Insert_Calendar.Outputs> _Insert_Calendar;
        private readonly DP.DapperORM.BaseSP<Get_Calendar.Inputs, Get_Calendar.Outputs> _Get_Calendar;
        private readonly DP.DapperORM.BaseSP<Get_TelegramState.Inputs, Get_TelegramState.Outputs> _Get_TelegramState;
        private readonly DP.DapperORM.BaseSP<Update_TelegramState.Inputs, Update_TelegramState.Outputs> _Update_TelegramState;
        private readonly DP.DapperORM.BaseSP<Connect_To_MessengersByCustomer.Inputs, Connect_To_MessengersByCustomer.Outputs> _Connect_To_MessengersByCustomer;
        private readonly DP.DapperORM.BaseSP<Update_Connect_To_MessengersByCustomer.Inputs, Update_Connect_To_MessengersByCustomer.Outputs> _Update_Connect_To_MessengersByCustomer;
        private readonly DP.DapperORM.BaseSP<Disconnect_To_MessengersByCustomer.Inputs, Disconnect_To_MessengersByCustomer.Outputs> _Disconnect_To_MessengersByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_MessengersByHook.Inputs, Insert_MessengersByHook.Outputs> _Insert_MessengersByHook;
        private readonly DP.DapperORM.BaseSP<Insert_TelegramBotChannel.Inputs, Insert_TelegramBotChannel.Outputs> _Insert_TelegramBotChannel;
        private readonly DP.DapperORM.BaseSP<Insert_TelegramBotChannelByHook.Inputs, Insert_TelegramBotChannelByHook.Outputs> _Insert_TelegramBotChannelByHook;
        private readonly DP.DapperORM.BaseSP<Update_TelegramBotChannel.Inputs, Update_TelegramBotChannel.Outputs> _Update_TelegramBotChannel;
        private readonly DP.DapperORM.BaseSP<Delete_TelegramBotChannel.Inputs, Delete_TelegramBotChannel.Outputs> _Delete_TelegramBotChannel;
        private readonly DP.DapperORM.BaseSP<Get_TelegramBotChannel.Inputs, Get_TelegramBotChannel.Outputs> _Get_TelegramBotChannel;
        private readonly DP.DapperORM.BaseSP<Get_TelegramBotChannelConnectionAction.Inputs, Get_TelegramBotChannelConnectionAction.Outputs> _Get_TelegramBotChannelConnectionAction;
        private readonly DP.DapperORM.BaseSP<Get_TelegramBotChannelConnectionAction_WithoutToken.Inputs, Get_TelegramBotChannelConnectionAction_WithoutToken.Outputs> _Get_TelegramBotChannelConnectionAction_WithoutToken;
        private readonly DP.DapperORM.BaseSP<Insert_TelegramBotChannelConnectionAction.Inputs, Insert_TelegramBotChannelConnectionAction.Outputs> _Insert_TelegramBotChannelConnectionAction;
        private readonly DP.DapperORM.BaseSP<Update_TelegramBotChannelConnectionAction.Inputs, Update_TelegramBotChannelConnectionAction.Outputs> _Update_TelegramBotChannelConnectionAction;
        private readonly DP.DapperORM.BaseSP<Delete_TelegramBotChannelConnectionAction.Inputs, Delete_TelegramBotChannelConnectionAction.Outputs> _Delete_TelegramBotChannelConnectionAction;
        private readonly DP.DapperORM.BaseSP<Get_Payment.Inputs, Get_Payment.Outputs> _Get_Payment;
        public QueueContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Update_TelegramState = new DP.DapperORM.BaseSP<Update_TelegramState.Inputs, Update_TelegramState.Outputs>("Queue.Update_TelegramState", executer);
            _Get_TelegramState = new DP.DapperORM.BaseSP<Get_TelegramState.Inputs, Get_TelegramState.Outputs>("Queue.Get_TelegramState", executer);
            _Get_Calendar = new DP.DapperORM.BaseSP<Get_Calendar.Inputs, Get_Calendar.Outputs>("Queue.Get_Calendar", executer);
            _Insert_Calendar = new DP.DapperORM.BaseSP<Insert_Calendar.Inputs, Insert_Calendar.Outputs>("Queue.Insert_Calendar", executer);
            _Insert_Sms = new DP.DapperORM.BaseSP<Insert_Sms.Inputs, Insert_Sms.Outputs>("Queue.Insert_Sms", executer);
            _Update_Sms = new DP.DapperORM.BaseSP<Update_Sms.Inputs, Update_Sms.Outputs>("Queue.Update_Sms", executer);
            _Insert_Email = new DP.DapperORM.BaseSP<Insert_Email.Inputs, Insert_Email.Outputs>("Queue.Insert_Email", executer);
            _Update_Email = new DP.DapperORM.BaseSP<Update_Email.Inputs, Update_Email.Outputs>("Queue.Update_Email", executer);
            _Insert_Token = new DP.DapperORM.BaseSP<Insert_Token.Inputs, Insert_Token.Outputs>("Queue.Insert_Token", executer);
            _Get_Tokens = new DP.DapperORM.BaseSP<Get_Tokens.Inputs, Get_Tokens.Outputs>("Queue.Get_Tokens", executer);
            _Get_Last_Token = new DP.DapperORM.BaseSP<Get_Last_Token.Inputs, Get_Last_Token.Outputs>("Queue.Get_Last_Token", executer);
            _Get_Alarms = new DP.DapperORM.BaseSP<Get_Alarms.Inputs, Get_Alarms.Outputs>("Queue.Get_Alarms", executer);
            _Insert_Alarm = new DP.DapperORM.BaseSP<Insert_Alarm.Inputs, Insert_Alarm.Outputs>("Queue.Insert_Alarm", executer);
            _Update_Alarm = new DP.DapperORM.BaseSP<Update_Alarm.Inputs, Update_Alarm.Outputs>("Queue.Update_Alarm", executer);
            _Delete_Alarm = new DP.DapperORM.BaseSP<Delete_Alarm.Inputs, Delete_Alarm.Outputs>("Queue.Delete_Alarm", executer);
            _Delete_Alarm_User = new DP.DapperORM.BaseSP<Delete_Alarm_User.Inputs, Delete_Alarm_User.Outputs>("Queue.Delete_Alarm_User", executer);
            _Insert_Chat = new DP.DapperORM.BaseSP<Insert_Chat.Inputs, Insert_Chat.Outputs>("Queue.Insert_Chat", executer);
            _Get_Emails = new DP.DapperORM.BaseSP<Get_Emails.Inputs, Get_Emails.Outputs>("Queue.Get_Emails", executer);
            _Get_Chat = new DP.DapperORM.BaseSP<Get_Chat.Inputs, Get_Chat.Outputs>("Queue.Get_Chat", executer);
            _Get_SMS = new DP.DapperORM.BaseSP<Get_SMS.Inputs, Get_SMS.Outputs>("Queue.Get_SMS", executer);
            _Get_Messengers = new DP.DapperORM.BaseSP<Get_Messengers.Inputs, Get_Messengers.Outputs>("Queue.Get_Messengers", executer);
            _Insert_Messengers = new DP.DapperORM.BaseSP<Insert_Messengers.Inputs, Insert_Messengers.Outputs>("Queue.Insert_Messengers", executer);
            _Update_Messengers = new DP.DapperORM.BaseSP<Update_Messengers.Inputs, Update_Messengers.Outputs>("Queue.Update_Messengers", executer);
            _Connect_To_MessengersByCustomer = new DP.DapperORM.BaseSP<Connect_To_MessengersByCustomer.Inputs, Connect_To_MessengersByCustomer.Outputs>("Queue.Connect_To_MessengersByCustomer", executer);
            _Update_Connect_To_MessengersByCustomer = new DP.DapperORM.BaseSP<Update_Connect_To_MessengersByCustomer.Inputs, Update_Connect_To_MessengersByCustomer.Outputs>("Queue.Update_Connect_To_MessengersByCustomer", executer);
            _Disconnect_To_MessengersByCustomer = new DP.DapperORM.BaseSP<Disconnect_To_MessengersByCustomer.Inputs, Disconnect_To_MessengersByCustomer.Outputs>("Queue.Disconnect_To_MessengersByCustomer", executer);
            _Insert_MessengersByHook = new DP.DapperORM.BaseSP<Insert_MessengersByHook.Inputs, Insert_MessengersByHook.Outputs>("Queue.Insert_MessengersByHook", executer);
            _Insert_TelegramBotChannelByHook = new DP.DapperORM.BaseSP<Insert_TelegramBotChannelByHook.Inputs, Insert_TelegramBotChannelByHook.Outputs>("Queue.Insert_TelegramBotChannelByHook", executer);
            _Insert_TelegramBotChannel = new DP.DapperORM.BaseSP<Insert_TelegramBotChannel.Inputs, Insert_TelegramBotChannel.Outputs>("Queue.Insert_TelegramBotChannel", executer);
            _Update_TelegramBotChannel = new DP.DapperORM.BaseSP<Update_TelegramBotChannel.Inputs, Update_TelegramBotChannel.Outputs>("Queue.Update_TelegramBotChannel", executer);
            _Delete_TelegramBotChannel = new DP.DapperORM.BaseSP<Delete_TelegramBotChannel.Inputs, Delete_TelegramBotChannel.Outputs>("Queue.Delete_TelegramBotChannel", executer);
            _Get_TelegramBotChannel = new DP.DapperORM.BaseSP<Get_TelegramBotChannel.Inputs, Get_TelegramBotChannel.Outputs>("Queue.Get_TelegramBotChannel", executer);
            _Get_TelegramBotChannelConnectionAction = new DP.DapperORM.BaseSP<Get_TelegramBotChannelConnectionAction.Inputs, Get_TelegramBotChannelConnectionAction.Outputs>("Queue.Get_TelegramBotChannelConnectionAction", executer);
            _Get_TelegramBotChannelConnectionAction_WithoutToken = new DP.DapperORM.BaseSP<Get_TelegramBotChannelConnectionAction_WithoutToken.Inputs, Get_TelegramBotChannelConnectionAction_WithoutToken.Outputs>("Queue.Get_TelegramBotChannelConnectionAction_WithoutToken", executer);
            _Insert_TelegramBotChannelConnectionAction = new BaseSP<Insert_TelegramBotChannelConnectionAction.Inputs, Insert_TelegramBotChannelConnectionAction.Outputs>("Queue.Insert_TelegramBotChannelConnectionAction", executer);
            _Update_TelegramBotChannelConnectionAction = new BaseSP<Update_TelegramBotChannelConnectionAction.Inputs, Update_TelegramBotChannelConnectionAction.Outputs>("Queue.Update_TelegramBotChannelConnectionAction", executer);
            _Delete_TelegramBotChannelConnectionAction = new BaseSP<Delete_TelegramBotChannelConnectionAction.Inputs, Delete_TelegramBotChannelConnectionAction.Outputs>("Queue.Delete_TelegramBotChannelConnectionAction", executer);
            _Get_Payment = new BaseSP<Get_Payment.Inputs, Get_Payment.Outputs>("Queue.Get_Payment", executer);
        }

        public async Task<DBResult<IEnumerable<Get_Calendar.Outputs>>> Get_Calendar(Get_Calendar.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Calendar.Query(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Calendar.Outputs>> Insert_Calendar(Insert_Calendar.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Calendar.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Sms.Outputs>> Insert_Sms(Insert_Sms.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Sms.Single(inputs, cancellationToken); }
        public async Task<DBResult> Update_Sms(Update_Sms.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Sms.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Email.Outputs>> Insert_Email(Insert_Email.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Email.Single(inputs, cancellationToken); }
        public async Task<DBResult> Update_Email(Update_Email.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Email.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Token.Outputs>> Insert_Token(Insert_Token.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Token.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Tokens.Outputs>>> Get_Tokens(Get_Tokens.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Tokens.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<Get_Last_Token.Outputs>> Get_Last_Token(Get_Last_Token.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Last_Token.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Alarms.Outputs>>> Get_Alarms(Get_Alarms.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Alarms.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Alarm(Insert_Alarm.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Alarm.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Alarm(Update_Alarm.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Alarm.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Alarm(Delete_Alarm.Inputs inputs, CancellationToken cancellationToken) {  return await _Delete_Alarm.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Alarm_User(Delete_Alarm_User.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Alarm_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Insert_Chat.Outputs>>> Insert_Chat(Insert_Chat.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Chat.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Chat.Outputs>>> Get_Chat(Get_Chat.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Chat.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Emails.Outputs>>> Get_Emails(Get_Emails.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Emails.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_SMS.Outputs>>> Get_SMS(Get_SMS.Inputs inputs, CancellationToken cancellationToken) { return await _Get_SMS.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Messengers.Outputs>>> Get_Messengers(Get_Messengers.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Messengers.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Messengers.Outputs>> Insert_Messengers(Insert_Messengers.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Messengers.Single(inputs, cancellationToken); }
        public async Task<DBResult> Update_Messengers(Update_Messengers.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Messengers.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Connect_To_MessengersByCustomer.Outputs>> Connect_To_MessengersByCustomer(Connect_To_MessengersByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Connect_To_MessengersByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult> Update_Connect_To_MessengersByCustomer(Update_Connect_To_MessengersByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Connect_To_MessengersByCustomer.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Disconnect_To_MessengersByCustomer(Disconnect_To_MessengersByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Disconnect_To_MessengersByCustomer.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_TelegramState(Update_TelegramState.Inputs inputs, CancellationToken cancellationToken) { return await _Update_TelegramState.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Get_TelegramState.Outputs>> Get_TelegramState(Get_TelegramState.Inputs inputs, CancellationToken cancellationToken) { return await _Get_TelegramState.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_MessengersByHook.Outputs>> Insert_MessengersByHook(Insert_MessengersByHook.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_MessengersByHook.Single(inputs, cancellationToken); }
        public async Task<DBResult> Insert_TelegramBotChannel(Insert_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_TelegramBotChannel.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_TelegramBotChannelByHook(Insert_TelegramBotChannelByHook.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_TelegramBotChannelByHook.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_TelegramBotChannel(Update_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken) { return await _Update_TelegramBotChannel.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_TelegramBotChannel(Delete_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_TelegramBotChannel.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_TelegramBotChannel.Outputs>>> Get_TelegramBotChannel(Get_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken) { return await _Get_TelegramBotChannel.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_TelegramBotChannelConnectionAction.Outputs>>> Get_TelegramBotChannelConnectionAction(Get_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken) { return await _Get_TelegramBotChannelConnectionAction.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_TelegramBotChannelConnectionAction_WithoutToken.Outputs>>> Get_TelegramBotChannelConnectionAction_WithoutToken(Get_TelegramBotChannelConnectionAction_WithoutToken.Inputs inputs, CancellationToken cancellationToken) { return await _Get_TelegramBotChannelConnectionAction_WithoutToken.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_TelegramBotChannelConnectionAction(Insert_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_TelegramBotChannelConnectionAction.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_TelegramBotChannelConnectionAction(Update_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken) { return await _Update_TelegramBotChannelConnectionAction.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_TelegramBotChannelConnectionAction(Delete_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_TelegramBotChannelConnectionAction.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Payment.Outputs>>> Get_Payment(Get_Payment.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Payment.QueryPagination(inputs, cancellationToken); }
    }
}
