﻿using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.Queue
{
    public class ShiftContext: IShiftContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Insert_Shift.Inputs, Insert_Shift.Outputs> _Insert_Shift;
        private readonly DP.DapperORM.BaseSP<Update_Shift.Inputs, Update_Shift.Outputs> _Update_Shift;
        private readonly DP.DapperORM.BaseSP<Delete_Shift.Inputs, Delete_Shift.Outputs> _Delete_Shift;
        private readonly DP.DapperORM.BaseSP<Get_Shifts.Inputs, Get_Shifts.Outputs> _Get_Shifts;
        private readonly DP.DapperORM.BaseSP<Insert_ShiftDetail.Inputs, Insert_ShiftDetail.Outputs> _Insert_ShiftDetail;
        private readonly DP.DapperORM.BaseSP<Insert_ShiftUser.Inputs, Insert_ShiftUser.Outputs> _Insert_ShiftUser;
        private readonly DP.DapperORM.BaseSP<Delete_ShiftDetails.Inputs, Delete_ShiftDetails.Outputs> _Delete_ShiftDetails;
        private readonly DP.DapperORM.BaseSP<Delete_ShiftUser.Inputs, Delete_ShiftUser.Outputs> _Delete_ShiftUser;
        private readonly DP.DapperORM.BaseSP<Update_ShiftDetail.Inputs, Update_ShiftDetail.Outputs> _Update_ShiftDetail;
        private readonly DP.DapperORM.BaseSP<Get_ShiftUser.Inputs, Get_ShiftUser.Outputs> _Get_ShiftUser;
        private readonly DP.DapperORM.BaseSP<Get_ShiftDetails.Inputs, Get_ShiftDetails.Outputs> _Get_ShiftDetails;
        public ShiftContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Insert_Shift = new DP.DapperORM.BaseSP<Insert_Shift.Inputs, Insert_Shift.Outputs>("Queue.Insert_Shift", executer);
            _Insert_ShiftDetail = new DP.DapperORM.BaseSP<Insert_ShiftDetail.Inputs, Insert_ShiftDetail.Outputs>("Queue.Insert_ShiftDetail", executer);
            _Insert_ShiftUser = new DP.DapperORM.BaseSP<Insert_ShiftUser.Inputs, Insert_ShiftUser.Outputs>("Queue.Insert_ShiftUser", executer);
            _Update_Shift = new DP.DapperORM.BaseSP<Update_Shift.Inputs, Update_Shift.Outputs>("Queue.Update_Shift", executer);
            _Update_ShiftDetail = new DP.DapperORM.BaseSP<Update_ShiftDetail.Inputs, Update_ShiftDetail.Outputs>("Queue.Update_ShiftDetail", executer);
            _Delete_Shift = new DP.DapperORM.BaseSP<Delete_Shift.Inputs, Delete_Shift.Outputs>("Queue.Delete_Shift", executer);
            _Delete_ShiftDetails = new DP.DapperORM.BaseSP<Delete_ShiftDetails.Inputs, Delete_ShiftDetails.Outputs>("Queue.Delete_ShiftDetails", executer);
            _Delete_ShiftUser = new DP.DapperORM.BaseSP<Delete_ShiftUser.Inputs, Delete_ShiftUser.Outputs>("Queue.Delete_ShiftUser", executer);
            _Get_ShiftDetails = new DP.DapperORM.BaseSP<Get_ShiftDetails.Inputs, Get_ShiftDetails.Outputs>("Queue.Get_ShiftDetails", executer);
            _Get_Shifts = new DP.DapperORM.BaseSP<Get_Shifts.Inputs, Get_Shifts.Outputs>("Queue.Get_Shifts", executer);
            _Get_ShiftUser = new DP.DapperORM.BaseSP<Get_ShiftUser.Inputs, Get_ShiftUser.Outputs>("Queue.Get_ShiftUser", executer);
        }


        public async Task<DBResult> Insert_Shift(Insert_Shift.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Shift.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Shift(Update_Shift.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Shift.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_ShiftDetail(Insert_ShiftDetail.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_ShiftDetail.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_ShiftDetail(Update_ShiftDetail.Inputs inputs, CancellationToken cancellationToken) { return await _Update_ShiftDetail.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_ShiftUser(Insert_ShiftUser.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_ShiftUser.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Shift(Delete_Shift.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Shift.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_ShiftDetails(Delete_ShiftDetails.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_ShiftDetails.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_ShiftUser(Delete_ShiftUser.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_ShiftUser.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_ShiftDetails.Outputs>>> Get_ShiftDetails(Get_ShiftDetails.Inputs inputs, CancellationToken cancellationToken) { return await _Get_ShiftDetails.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Shifts.Outputs>>> Get_Shifts(Get_Shifts.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Shifts.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_ShiftUser.Outputs>>> Get_ShiftUser(Get_ShiftUser.Inputs inputs, CancellationToken cancellationToken) { return await _Get_ShiftUser.QueryPagination(inputs, cancellationToken); }
    }
}
