﻿using Farakonesh.DP.DapperORM;
using Farakonesh.Logic.IDatabase.IReport;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Report;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database
{
    public class ReportContext: IReportContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly BaseSP<Get_CurrencyWarehouse_Report_Admin.Inputs, Get_CurrencyWarehouse_Report_Admin.Outputs> _Get_CurrencyWarehouse_Report_Admin;
        private readonly BaseSP<GetCountAllDashboard.Inputs, GetCountAllDashboard.Outputs> _GetCountAllDashboard;
        private readonly BaseSP<Get_GeneralReportWarehouse_Admin.Inputs, Get_GeneralReportWarehouse_Admin.Outputs> _Get_GeneralReportWarehouse_Admin;
        private readonly BaseSP<GetPaymentLinkHistoryReport.Inputs, GetPaymentLinkHistoryReport.Outputs> _GetPaymentLinkHistoryReport;
        private readonly BaseSP<GetTransactionReport.Inputs, GetTransactionReport.Outputs> _GetTransactionReport;
        private readonly BaseSP<GetAccountNumberHistoryReport.Inputs, GetAccountNumberHistoryReport.Outputs> _GetAccountNumberHistoryReport;
        private readonly BaseSP<GetRfmSummary.Inputs, GetRfmSummary.Outputs> _GetRfmSummary;
        private readonly BaseSP<GetUserReport.Inputs, GetUserReport.Outputs> _GetUserReport;
        private readonly BaseSP<GetSummaryWallet.Inputs, GetSummaryWallet.Outputs> _GetSummaryWallet;
        private readonly BaseSP<Get_CurrencyWarehouse_Report_Sum_Admin.Inputs, Get_CurrencyWarehouse_Report_Sum_Admin.Outputs> _Get_CurrencyWarehouse_Report_Sum_Admin;
        private readonly BaseSP<GetUserRFMCategoryReport.Inputs, GetUserRFMCategoryReport.Outputs> _GetUserRFMCategoryReport;
        public ReportContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Get_CurrencyWarehouse_Report_Admin = new DP.DapperORM.BaseSP<Get_CurrencyWarehouse_Report_Admin.Inputs, Get_CurrencyWarehouse_Report_Admin.Outputs>("Report.Get_CurrencyWarehouse_Report_Admin", executer);
            _GetCountAllDashboard = new DP.DapperORM.BaseSP<GetCountAllDashboard.Inputs, GetCountAllDashboard.Outputs>("Report.GetCountAllDashboard", executer);
            _Get_GeneralReportWarehouse_Admin = new DP.DapperORM.BaseSP<Get_GeneralReportWarehouse_Admin.Inputs, Get_GeneralReportWarehouse_Admin.Outputs>("Report.Get_GeneralReportWarehouse_Admin", executer);
            _GetPaymentLinkHistoryReport = new DP.DapperORM.BaseSP<GetPaymentLinkHistoryReport.Inputs, GetPaymentLinkHistoryReport.Outputs>("Report.GetPaymentLinkHistoryReport", executer);
            _GetTransactionReport = new DP.DapperORM.BaseSP<GetTransactionReport.Inputs, GetTransactionReport.Outputs>("Report.GetTransactionReport", executer);
            _GetAccountNumberHistoryReport = new DP.DapperORM.BaseSP<GetAccountNumberHistoryReport.Inputs, GetAccountNumberHistoryReport.Outputs>("Report.GetAccountNumberHistoryReport", executer);
            _GetRfmSummary = new BaseSP<GetRfmSummary.Inputs, GetRfmSummary.Outputs>("Report.GetRfmSummary", executer);
            _GetUserReport = new BaseSP<GetUserReport.Inputs, GetUserReport.Outputs>("Report.GetUserReport", executer);
            _GetSummaryWallet = new BaseSP<GetSummaryWallet.Inputs, GetSummaryWallet.Outputs>("Report.GetSummaryWallet", executer);
            _Get_CurrencyWarehouse_Report_Sum_Admin = new BaseSP<Get_CurrencyWarehouse_Report_Sum_Admin.Inputs, Get_CurrencyWarehouse_Report_Sum_Admin.Outputs>("Report.Get_CurrencyWarehouse_Report_Sum_Admin", executer);
            _GetUserRFMCategoryReport = new BaseSP<GetUserRFMCategoryReport.Inputs, GetUserRFMCategoryReport.Outputs>("Report.GetUserRFMCategoryReport", executer);
        }
        public async Task<DBResult<GetPaymentLinkHistoryReport.Outputs>> GetPaymentLinkHistoryReport(GetPaymentLinkHistoryReport.Inputs inputs, CancellationToken cancellationToken) { return await _GetPaymentLinkHistoryReport.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetCountAllDashboard.Outputs>> GetCountAllDashboard(GetCountAllDashboard.Inputs inputs, CancellationToken cancellationToken) { return await _GetCountAllDashboard.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_GeneralReportWarehouse_Admin.Outputs>> Get_GeneralReportWarehouse_Admin(Get_GeneralReportWarehouse_Admin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_GeneralReportWarehouse_Admin.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetTransactionReport.Outputs>> GetTransactionReport(GetTransactionReport.Inputs inputs, CancellationToken cancellationToken) { return await _GetTransactionReport.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetAccountNumberHistoryReport.Outputs>> GetAccountNumberHistoryReport(GetAccountNumberHistoryReport.Inputs inputs, CancellationToken cancellationToken) { return await _GetAccountNumberHistoryReport.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetRfmSummary.Outputs>> GetRfmSummary(GetRfmSummary.Inputs inputs, CancellationToken cancellationToken) { return await _GetRfmSummary.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetUserReport.Outputs>>> GetUserReport(GetUserReport.Inputs inputs, CancellationToken cancellationToken) { return await _GetUserReport.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetUserRFMCategoryReport.Outputs>>> GetUserRFMCategoryReport(GetUserRFMCategoryReport.Inputs inputs, CancellationToken cancellationToken) { return await _GetUserRFMCategoryReport.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<GetSummaryWallet.Outputs>> GetSummaryWallet(GetSummaryWallet.Inputs inputs, CancellationToken cancellationToken) { return await _GetSummaryWallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_CurrencyWarehouse_Report_Sum_Admin.Outputs>>> Get_CurrencyWarehouse_Report_Sum_Admin(Get_CurrencyWarehouse_Report_Sum_Admin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_CurrencyWarehouse_Report_Sum_Admin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_CurrencyWarehouse_Report_Admin.Outputs>>> Get_CurrencyWarehouse_Report_Admin(Get_CurrencyWarehouse_Report_Admin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_CurrencyWarehouse_Report_Admin.Query(inputs, cancellationToken); }
    }
}
