﻿using Farakonesh.DP.DapperORM;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.ActionLog;
using Farakonesh.Models.Database.StoredProcedures.App.User.Address;
using Farakonesh.Models.Database.StoredProcedures.App.User.Authentication;
using Farakonesh.Models.Database.StoredProcedures.App.User.Location;
using Farakonesh.Models.Database.StoredProcedures.App.User.Survey;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.User
{
    public class AddressContext: IAddressContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly BaseSP<Check_ExistsAddress.Inputs, Check_ExistsAddress.Outputs> _Check_ExistsAddress;
        private readonly BaseSP<Insert_Address.Inputs, Insert_Address.Outputs> _Insert_Address;
        private readonly BaseSP<Update_Address.Inputs, Update_Address.Outputs> _Update_Address;
        private readonly BaseSP<Delete_Address.Inputs, Delete_Address.Outputs> _Delete_Address;
        private readonly BaseSP<GetAddress.Inputs, GetAddress.Outputs> _GetAddress;
        private readonly BaseSP<GetAddressByAdmin.Inputs, GetAddressByAdmin.Outputs> _GetAddressByAdmin;
        private readonly BaseSP<Insert_AddressByAdmin.Inputs, Insert_AddressByAdmin.Outputs> _Insert_AddressByAdmin;
        private readonly BaseSP<Update_AddressByAdmin.Inputs, Update_AddressByAdmin.Outputs> _Update_AddressByAdmin;
        private readonly BaseSP<Delete_AddressByAdmin.Inputs, Delete_AddressByAdmin.Outputs> _Delete_AddressByAdmin;

        public AddressContext(IConfiguration configuration)
        {

            _connectionString = configuration.GetConnectionString("cns");
            var executer = new SqlExecuter(_connectionString);

            _Check_ExistsAddress = new DP.DapperORM.BaseSP<Check_ExistsAddress.Inputs, Check_ExistsAddress.Outputs>("User.Check_ExistsAddress", executer);
            _Insert_Address = new DP.DapperORM.BaseSP<Insert_Address.Inputs, Insert_Address.Outputs>("User.Insert_Address", executer);
            _Delete_Address = new DP.DapperORM.BaseSP<Delete_Address.Inputs, Delete_Address.Outputs>("User.Delete_Address", executer);
            _Update_Address = new DP.DapperORM.BaseSP<Update_Address.Inputs, Update_Address.Outputs>("User.Update_Address", executer);
            _GetAddress = new DP.DapperORM.BaseSP<GetAddress.Inputs, GetAddress.Outputs>("User.GetAddress", executer);
            _GetAddressByAdmin = new BaseSP<GetAddressByAdmin.Inputs, GetAddressByAdmin.Outputs>("User.GetAddressByAdmin", executer);
            _Insert_AddressByAdmin = new BaseSP<Insert_AddressByAdmin.Inputs, Insert_AddressByAdmin.Outputs>("User.Insert_AddressByAdmin", executer);
            _Update_AddressByAdmin = new BaseSP<Update_AddressByAdmin.Inputs, Update_AddressByAdmin.Outputs>("User.Update_AddressByAdmin", executer);
            _Delete_AddressByAdmin = new BaseSP<Delete_AddressByAdmin.Inputs, Delete_AddressByAdmin.Outputs>("User.Delete_AddressByAdmin", executer);
        }
        public async Task<DBResult> Check_ExistsAddress(Check_ExistsAddress.Inputs inputs, CancellationToken cancellationToken) { return await _Check_ExistsAddress.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Address(Insert_Address.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Address.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_AddressByAdmin(Insert_AddressByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_AddressByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Address(Update_Address.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Address.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_AddressByAdmin(Update_AddressByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Update_AddressByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Address(Delete_Address.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Address.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_AddressByAdmin(Delete_AddressByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_AddressByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetAddress.Outputs>>> GetAddress(GetAddress.Inputs inputs, CancellationToken cancellationToken) { return await _GetAddress.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetAddressByAdmin.Outputs>>> GetAddressByAdmin(GetAddressByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetAddressByAdmin.QueryPagination(inputs, cancellationToken); }
    }
}
