﻿using Farakonesh.DP.DapperORM;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Authentication;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.User
{
    public class AuthenticationContext: IAuthenticationContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties


        #region SP_Authentication
        private readonly DP.DapperORM.BaseSP<LoginCompany.Inputs, LoginCompany.Outputs> _LoginCompany;
        private readonly DP.DapperORM.BaseSP<Insert_VerifyCodeByCompany.Inputs, Insert_VerifyCodeByCompany.Outputs> _Insert_VerifyCodeByCompany;
        private readonly DP.DapperORM.BaseSP<VeriyCode_Register_ByCompany.Inputs, VeriyCode_Register_ByCompany.Outputs> _VeriyCode_Register_ByCompany;
        private readonly DP.DapperORM.BaseSP<Login.Inputs, Login.Outputs> _Login;
        private readonly DP.DapperORM.BaseSP<LoginWithSocial.Inputs, LoginWithSocial.Outputs> _LoginWithSocial;
        private readonly DP.DapperORM.BaseSP<RefreshToken.Inputs, RefreshToken.Outputs> _RefreshToken;
        private readonly DP.DapperORM.BaseSP<SignOut.Inputs, SignOut.Outputs> _SignOut;
        private readonly DP.DapperORM.BaseSP<Insert_VerifyCode.Inputs, Insert_VerifyCode.Outputs> _Insert_VerifyCode;
        private readonly DP.DapperORM.BaseSP<Insert_VerifyCodeToken.Inputs, Insert_VerifyCodeToken.Outputs> _Insert_VerifyCodeToken;
        private readonly DP.DapperORM.BaseSP<VeriyCode_Login_Register.Inputs, VeriyCode_Login_Register.Outputs> _VeriyCode_Login_Register;
        private readonly DP.DapperORM.BaseSP<VeriyCode_Email_Tel.Inputs, VeriyCode_Email_Tel.Outputs> _VeriyCode_Email_Tel;
        private readonly BaseSP<Insert_VerifyCodeByCompany_Old_User.Inputs, Insert_VerifyCodeByCompany_Old_User.Outputs> _Insert_VerifyCodeByCompany_Old_User;
        private readonly BaseSP<Check_VerifyCodeByCompany.Inputs, Check_VerifyCodeByCompany.Outputs> _Check_VerifyCodeByCompany;
        private readonly BaseSP<Expire_VerifyCode.Inputs, Expire_VerifyCode.Outputs> _Expire_VerifyCode;
        #endregion SP_Authentication
        private readonly ITokenUserService _tokenUserService;
        public AuthenticationContext(IConfiguration configuration, ITokenUserService tokenUserService)
        {
            _tokenUserService = tokenUserService;
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _LoginCompany = new DP.DapperORM.BaseSP<LoginCompany.Inputs, LoginCompany.Outputs>("User.LoginCompany", executer);
            _Insert_VerifyCodeByCompany = new DP.DapperORM.BaseSP<Insert_VerifyCodeByCompany.Inputs, Insert_VerifyCodeByCompany.Outputs>("User.Insert_VerifyCodeByCompany", executer);
            _VeriyCode_Register_ByCompany = new DP.DapperORM.BaseSP<VeriyCode_Register_ByCompany.Inputs, VeriyCode_Register_ByCompany.Outputs>("User.VeriyCode_Register_ByCompany", executer);
            _Login = new DP.DapperORM.BaseSP<Login.Inputs, Login.Outputs>("User.Login", executer);
            _LoginWithSocial = new DP.DapperORM.BaseSP<LoginWithSocial.Inputs, LoginWithSocial.Outputs>("User.LoginWithSocial", executer);
            _RefreshToken = new DP.DapperORM.BaseSP<RefreshToken.Inputs, RefreshToken.Outputs>("User.RefreshToken", executer);
            _SignOut = new DP.DapperORM.BaseSP<SignOut.Inputs, SignOut.Outputs>("User.SignOut", executer);
            _Insert_VerifyCode = new DP.DapperORM.BaseSP<Insert_VerifyCode.Inputs, Insert_VerifyCode.Outputs>("User.Insert_VerifyCode", executer);
            _Insert_VerifyCodeToken = new DP.DapperORM.BaseSP<Insert_VerifyCodeToken.Inputs, Insert_VerifyCodeToken.Outputs>("User.Insert_VerifyCodeToken", executer);
            _VeriyCode_Login_Register = new DP.DapperORM.BaseSP<VeriyCode_Login_Register.Inputs, VeriyCode_Login_Register.Outputs>("User.VeriyCode_Login_Register", executer);
            _VeriyCode_Email_Tel = new DP.DapperORM.BaseSP<VeriyCode_Email_Tel.Inputs, VeriyCode_Email_Tel.Outputs>("User.VeriyCode_Email_Tel", executer);
            _Insert_VerifyCodeByCompany_Old_User = new BaseSP<Insert_VerifyCodeByCompany_Old_User.Inputs, Insert_VerifyCodeByCompany_Old_User.Outputs>("User.Insert_VerifyCodeByCompany_Old_User", executer);
            _Check_VerifyCodeByCompany = new BaseSP<Check_VerifyCodeByCompany.Inputs, Check_VerifyCodeByCompany.Outputs>("User.Check_VerifyCodeByCompany", executer);
            _Expire_VerifyCode = new BaseSP<Expire_VerifyCode.Inputs, Expire_VerifyCode.Outputs>("User.Expire_VerifyCode", executer);
        }

        public async Task<DBResult<LoginCompany.Outputs>> LoginCompany(LoginCompany.Inputs inputs, CancellationToken cancellationToken) { return await _LoginCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_VerifyCodeByCompany.Outputs>> Insert_VerifyCodeByCompany(Insert_VerifyCodeByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_VerifyCodeByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<VeriyCode_Register_ByCompany.Outputs>> VeriyCode_Register_ByCompany(VeriyCode_Register_ByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _VeriyCode_Register_ByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Login.Outputs>> Login(Login.Inputs inputs, CancellationToken cancellationToken) { return await _Login.Single(inputs, cancellationToken); }
        public async Task<DBResult<LoginWithSocial.Outputs>> LoginWithSocial(LoginWithSocial.Inputs inputs, CancellationToken cancellationToken) { return await _LoginWithSocial.Single(inputs, cancellationToken); }
        public async Task<DBResult<RefreshToken.Outputs>> RefreshToken(RefreshToken.Inputs inputs, CancellationToken cancellationToken) { inputs.RefreshToken = _tokenUserService.getUserRefreshInfo(inputs.RefreshToken).RefreshToken; return await _RefreshToken.Single(inputs, cancellationToken); }
        public async Task<DBResult> SignOut(SignOut.Inputs inputs, CancellationToken cancellationToken) { return await _SignOut.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Insert_VerifyCode.Outputs>> Insert_VerifyCode(Insert_VerifyCode.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_VerifyCode.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_VerifyCodeToken.Outputs>> Insert_VerifyCodeToken(Insert_VerifyCodeToken.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_VerifyCodeToken.Single(inputs, cancellationToken); }
        public async Task<DBResult<VeriyCode_Login_Register.Outputs>> VeriyCode_Login_Register(VeriyCode_Login_Register.Inputs inputs, CancellationToken cancellationToken) { return await _VeriyCode_Login_Register.Single(inputs, cancellationToken); }
        public async Task<DBResult<VeriyCode_Email_Tel.Outputs>> VeriyCode_Email_Tel(VeriyCode_Email_Tel.Inputs inputs, CancellationToken cancellationToken) { return await _VeriyCode_Email_Tel.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_VerifyCodeByCompany_Old_User.Outputs>> Insert_VerifyCodeByCompany_Old_User(Insert_VerifyCodeByCompany_Old_User.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_VerifyCodeByCompany_Old_User.Single(inputs, cancellationToken); }
        public async Task<DBResult> Check_VerifyCodeByCompany(Check_VerifyCodeByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Check_VerifyCodeByCompany.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Expire_VerifyCode(Expire_VerifyCode.Inputs inputs, CancellationToken cancellationToken) { return await _Expire_VerifyCode.Execute(inputs, cancellationToken); }
    }
}
