﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.DP.DapperORM;

namespace Farakonesh.Logic.Database.User
{
    public class BankAccountContext: IBankAccountContext
    {
        private readonly DP.DapperORM.BaseSP<Check_BankAccount_User.Inputs, Check_BankAccount_User.Outputs> _Check_BankAccount_User;
        private readonly DP.DapperORM.BaseSP<Insert_BankAccountByAdmin.Inputs, Insert_BankAccountByAdmin.Outputs> _Insert_BankAccountByAdmin;
        private readonly DP.DapperORM.BaseSP<Delete_BankAccountByAdmin.Inputs, Delete_BankAccountByAdmin.Outputs> _Delete_BankAccountByAdmin;
        private readonly DP.DapperORM.BaseSP<GetBankAccountByAdmin.Inputs, GetBankAccountByAdmin.Outputs> _GetBankAccountByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_BankAccount.Inputs, Insert_BankAccount.Outputs> _Insert_BankAccount;
        private readonly DP.DapperORM.BaseSP<Delete_BankAccount.Inputs, Delete_BankAccount.Outputs> _Delete_BankAccount;
        private readonly DP.DapperORM.BaseSP<GetBankAccount.Inputs, GetBankAccount.Outputs> _GetBankAccount;
        private readonly DP.DapperORM.BaseSP<Update_BankAccount.Inputs, Update_BankAccount.Outputs> _Update_BankAccount;
        private readonly DP.DapperORM.BaseSP<Update_BankAccountByAdmin.Inputs, Update_BankAccountByAdmin.Outputs> _Update_BankAccountByAdmin;
        private readonly DP.DapperORM.BaseSP<Update_BankAccount_Set_Default.Inputs, Update_BankAccount_Set_Default.Outputs> _Update_BankAccount_Set_Default;
        private readonly DP.DapperORM.BaseSP<Update_BankAccount_Set_Default_ByAdmin.Inputs, Update_BankAccount_Set_Default_ByAdmin.Outputs> _Update_BankAccount_Set_Default_ByAdmin;
        private readonly DP.DapperORM.BaseSP<GetBankAccount_WithoutToken.Inputs, GetBankAccount_WithoutToken.Outputs> _GetBankAccount_WithoutToken;
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        public BankAccountContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Insert_BankAccountByAdmin = new DP.DapperORM.BaseSP<Insert_BankAccountByAdmin.Inputs, Insert_BankAccountByAdmin.Outputs>("User.Insert_BankAccountByAdmin", executer);
            _Check_BankAccount_User = new BaseSP<Check_BankAccount_User.Inputs, Check_BankAccount_User.Outputs>("User.Check_BankAccount_User", executer);
            _GetBankAccountByAdmin = new DP.DapperORM.BaseSP<GetBankAccountByAdmin.Inputs, GetBankAccountByAdmin.Outputs>("User.GetBankAccountByAdmin", executer);
            _Delete_BankAccountByAdmin = new DP.DapperORM.BaseSP<Delete_BankAccountByAdmin.Inputs, Delete_BankAccountByAdmin.Outputs>("User.Delete_BankAccountByAdmin", executer);
            _Insert_BankAccount = new DP.DapperORM.BaseSP<Insert_BankAccount.Inputs, Insert_BankAccount.Outputs>("User.Insert_BankAccount", executer);
            _Delete_BankAccount = new DP.DapperORM.BaseSP<Delete_BankAccount.Inputs, Delete_BankAccount.Outputs>("User.Delete_BankAccount", executer);
            _GetBankAccount = new DP.DapperORM.BaseSP<GetBankAccount.Inputs, GetBankAccount.Outputs>("User.GetBankAccount", executer);
            _Update_BankAccount = new DP.DapperORM.BaseSP<Update_BankAccount.Inputs, Update_BankAccount.Outputs>("User.Update_BankAccount", executer);
            _Update_BankAccountByAdmin = new DP.DapperORM.BaseSP<Update_BankAccountByAdmin.Inputs, Update_BankAccountByAdmin.Outputs>("User.Update_BankAccountByAdmin", executer);
            _Update_BankAccount_Set_Default = new DP.DapperORM.BaseSP<Update_BankAccount_Set_Default.Inputs, Update_BankAccount_Set_Default.Outputs>("User.Update_BankAccount_Set_Default", executer);
            _Update_BankAccount_Set_Default_ByAdmin = new DP.DapperORM.BaseSP<Update_BankAccount_Set_Default_ByAdmin.Inputs, Update_BankAccount_Set_Default_ByAdmin.Outputs>("User.Update_BankAccount_Set_Default_ByAdmin", executer);
            _GetBankAccount_WithoutToken = new DP.DapperORM.BaseSP<GetBankAccount_WithoutToken.Inputs, GetBankAccount_WithoutToken.Outputs>("User.GetBankAccount_WithoutToken", executer);
        }

        public async Task<DBResult> Insert_BankAccountByAdmin(Insert_BankAccountByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_BankAccountByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Check_BankAccount_User(Check_BankAccount_User.Inputs inputs, CancellationToken cancellationToken) { return await _Check_BankAccount_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_BankAccountByAdmin(Delete_BankAccountByAdmin.Inputs inputs, CancellationToken cancellationToken) {  return await _Delete_BankAccountByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetBankAccountByAdmin.Outputs>>> GetBankAccountByAdmin(GetBankAccountByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetBankAccountByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetBankAccount_WithoutToken.Outputs>>> GetBankAccount_WithoutToken(GetBankAccount_WithoutToken.Inputs inputs, CancellationToken cancellationToken) { return await _GetBankAccount_WithoutToken.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_BankAccount(Insert_BankAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_BankAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_BankAccount(Delete_BankAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_BankAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetBankAccount.Outputs>>> GetBankAccount(GetBankAccount.Inputs inputs, CancellationToken cancellationToken) { return await _GetBankAccount.Query(inputs, cancellationToken); }
        public async Task<DBResult> Update_BankAccount(Update_BankAccount.Inputs inputs, CancellationToken cancellationToken) { return await _Update_BankAccount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_BankAccountByAdmin(Update_BankAccountByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Update_BankAccountByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_BankAccount_Set_Default(Update_BankAccount_Set_Default.Inputs inputs, CancellationToken cancellationToken) { return await _Update_BankAccount_Set_Default.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_BankAccount_Set_Default_ByAdmin(Update_BankAccount_Set_Default_ByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Update_BankAccount_Set_Default_ByAdmin.Execute(inputs, cancellationToken); }
    }
}
