﻿using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Discount;
using Farakonesh.Models.Database.StoredProcedures.App.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Models.Database;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Microsoft.Extensions.Configuration;
using Farakonesh.DP.DapperORM;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;

namespace Farakonesh.Logic.Database.User
{
    public class CompanyContext : ICompanyContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties


        #region SP_Company
        private readonly BaseSP<GetCompanyList.Inputs, GetCompanyList.Outputs> _GetCompanyList;
        private readonly BaseSP<Check_Duplicate_CompanyClient.Inputs, Check_Duplicate_CompanyClient.Outputs> _Check_Duplicate_CompanyClient;
        private readonly BaseSP<GetCompanyById.Inputs, GetCompanyById.Outputs> _GetCompanyById;
        private readonly BaseSP<Insert_Company.Inputs, Insert_Company.Outputs> _Insert_Company;
        private readonly BaseSP<Update_Company.Inputs, Update_Company.Outputs> _Update_Company;
        private readonly BaseSP<Delete_Company.Inputs, Delete_Company.Outputs> _Delete_Company;
        private readonly BaseSP<Delete_Company_User.Inputs, Delete_Company_User.Outputs> _Delete_Company_User;
        private readonly BaseSP<Insert_Company_User.Inputs, Insert_Company_User.Outputs> _Insert_Company_User;
        private readonly BaseSP<Update_Company_User.Inputs, Update_Company_User.Outputs> _Update_Company_User;
        private readonly BaseSP<Get_Company_User.Inputs, Get_Company_User.Outputs> _Get_Company_User;
        private readonly BaseSP<GetCompany.Inputs, GetCompany.Outputs> _GetCompany;
        private readonly BaseSP<GetCompanyListByUserId.Inputs, GetCompanyListByUserId.Outputs> _GetCompanyListByUserId;
        private readonly BaseSP<GetCompanyClientList.Inputs, GetCompanyClientList.Outputs> _GetCompanyClientList;
        private readonly BaseSP<GetCompanyClientListByAdmin.Inputs, GetCompanyClientListByAdmin.Outputs> _GetCompanyClientListByAdmin;
        private readonly BaseSP<Insert_CompanyClient.Inputs, Insert_CompanyClient.Outputs> _Insert_CompanyClient;
        private readonly BaseSP<Insert_CompanyClientByAdmin.Inputs, Insert_CompanyClientByAdmin.Outputs> _Insert_CompanyClientByAdmin;
        private readonly BaseSP<Delete_CompanyClient.Inputs, Delete_CompanyClient.Outputs> _Delete_CompanyClient;
        private readonly BaseSP<Delete_CompanyClientByAdmin.Inputs, Delete_CompanyClientByAdmin.Outputs> _Delete_CompanyClientByAdmin;
        #endregion SP_Company

        public CompanyContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetCompanyList = new DP.DapperORM.BaseSP<GetCompanyList.Inputs, GetCompanyList.Outputs>("User.GetCompanyList", executer);
            _Check_Duplicate_CompanyClient = new BaseSP<Check_Duplicate_CompanyClient.Inputs, Check_Duplicate_CompanyClient.Outputs>("User.Check_Duplicate_CompanyClient", executer);
            _GetCompanyListByUserId = new DP.DapperORM.BaseSP<GetCompanyListByUserId.Inputs, GetCompanyListByUserId.Outputs>("User.GetCompanyListByUserId", executer);
            _GetCompany = new DP.DapperORM.BaseSP<GetCompany.Inputs, GetCompany.Outputs>("User.GetCompany", executer);
            _GetCompanyById = new DP.DapperORM.BaseSP<GetCompanyById.Inputs, GetCompanyById.Outputs>("User.GetCompanyById", executer);
            _Insert_Company = new DP.DapperORM.BaseSP<Insert_Company.Inputs, Insert_Company.Outputs>("User.Insert_Company", executer);
            _Update_Company = new DP.DapperORM.BaseSP<Update_Company.Inputs, Update_Company.Outputs>("User.Update_Company", executer);
            _Delete_Company = new DP.DapperORM.BaseSP<Delete_Company.Inputs, Delete_Company.Outputs>("User.Delete_Company", executer);
            _Delete_Company_User = new DP.DapperORM.BaseSP<Delete_Company_User.Inputs, Delete_Company_User.Outputs>("User.Delete_Company_User", executer);
            _Get_Company_User = new DP.DapperORM.BaseSP<Get_Company_User.Inputs, Get_Company_User.Outputs>("User.Get_Company_User", executer);
            _Insert_Company_User = new DP.DapperORM.BaseSP<Insert_Company_User.Inputs, Insert_Company_User.Outputs>("User.Insert_Company_User", executer);
            _GetCompanyClientList = new DP.DapperORM.BaseSP<GetCompanyClientList.Inputs, GetCompanyClientList.Outputs>("User.GetCompanyClientList", executer);
            _GetCompanyClientListByAdmin = new DP.DapperORM.BaseSP<GetCompanyClientListByAdmin.Inputs, GetCompanyClientListByAdmin.Outputs>("User.GetCompanyClientListByAdmin", executer);
            _Insert_CompanyClient = new BaseSP<Insert_CompanyClient.Inputs, Insert_CompanyClient.Outputs>("User.Insert_CompanyClient", executer);
            _Update_Company_User = new BaseSP<Update_Company_User.Inputs, Update_Company_User.Outputs>("User.Update_Company_User", executer);
            _Insert_CompanyClientByAdmin = new BaseSP<Insert_CompanyClientByAdmin.Inputs, Insert_CompanyClientByAdmin.Outputs>("User.Insert_CompanyClientByAdmin", executer);
            _Delete_CompanyClient = new BaseSP<Delete_CompanyClient.Inputs, Delete_CompanyClient.Outputs>("User.Delete_CompanyClient", executer);
            _Delete_CompanyClientByAdmin = new BaseSP<Delete_CompanyClientByAdmin.Inputs, Delete_CompanyClientByAdmin.Outputs>("User.Delete_CompanyClientByAdmin", executer);

        }

        public async Task<DBResult<IEnumerable<GetCompanyList.Outputs>>> GetCompanyList(GetCompanyList.Inputs inputs, CancellationToken cancellationToken) { return await _GetCompanyList.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<GetCompany.Outputs>> GetCompany(GetCompany.Inputs inputs, CancellationToken cancellationToken) { return await _GetCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCompanyListByUserId.Outputs>>> GetCompanyListByUserId(GetCompanyListByUserId.Inputs inputs, CancellationToken cancellationToken) { return await _GetCompanyListByUserId.Query(inputs, cancellationToken); }
        public async Task<DBResult<GetCompanyById.Outputs>> GetCompanyById(GetCompanyById.Inputs inputs, CancellationToken cancellationToken) { return await _GetCompanyById.Single(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Company(Insert_Company.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Company.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Company(Update_Company.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Company.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Check_Duplicate_CompanyClient(Check_Duplicate_CompanyClient.Inputs inputs, CancellationToken cancellationToken) { return await _Check_Duplicate_CompanyClient.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Company_User(Update_Company_User.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Company_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Company(Delete_Company.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Company.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Company_User(Delete_Company_User.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Company_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Company_User(Insert_Company_User.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Company_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Company_User.Outputs>>> Get_Company_User(Get_Company_User.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Company_User.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCompanyClientList.Outputs>>> GetCompanyClientList(GetCompanyClientList.Inputs inputs, CancellationToken cancellationToken) { return await _GetCompanyClientList.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCompanyClientListByAdmin.Outputs>>> GetCompanyClientListByAdmin(GetCompanyClientListByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetCompanyClientListByAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CompanyClient(Insert_CompanyClient.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CompanyClient.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CompanyClientByAdmin(Insert_CompanyClientByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CompanyClientByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_CompanyClient(Delete_CompanyClient.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_CompanyClient.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_CompanyClientByAdmin(Delete_CompanyClientByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_CompanyClientByAdmin.Execute(inputs, cancellationToken); }

    }
}
