﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Models.Database.StoredProcedures.App.User.Discount;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.User
{
    public class DiscountContext: IDiscountContext
    {
        #region properties
        private string _connectionString { get; set; }

   
        #endregion properties


        #region SP_Discount
        private readonly DP.DapperORM.BaseSP<GetDiscountCode.Inputs, GetDiscountCode.Outputs> _GetDiscountCode;
        private readonly DP.DapperORM.BaseSP<GetDiscountForAlarmByCompany.Inputs, GetDiscountForAlarmByCompany.Outputs> _GetDiscountForAlarmByCompany;
        private readonly DP.DapperORM.BaseSP<GetDiscountByCompany.Inputs, GetDiscountByCompany.Outputs> _GetDiscountByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_Discount.Inputs, Insert_Discount.Outputs> _Insert_Discount;
        private readonly DP.DapperORM.BaseSP<Insert_DiscountByCompany.Inputs, Insert_DiscountByCompany.Outputs> _Insert_DiscountByCompany;
        private readonly DP.DapperORM.BaseSP<Update_DiscountByCompany.Inputs, Update_DiscountByCompany.Outputs> _Update_DiscountByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_Discount_User.Inputs, Insert_Discount_User.Outputs> _Insert_Discount_User;
        private readonly DP.DapperORM.BaseSP<Update_Discount.Inputs, Update_Discount.Outputs> _Update_Discount;
        private readonly DP.DapperORM.BaseSP<Delete_Discount.Inputs, Delete_Discount.Outputs> _Delete_Discount;
        private readonly DP.DapperORM.BaseSP<Delete_Discount_User.Inputs, Delete_Discount_User.Outputs> _Delete_Discount_User;
        private readonly DP.DapperORM.BaseSP<Delete_DiscountByCompany.Inputs, Delete_DiscountByCompany.Outputs> _Delete_DiscountByCompany;
        private readonly DP.DapperORM.BaseSP<GetDiscountUser.Inputs, GetDiscountUser.Outputs> _GetDiscountUser;
        private readonly DP.DapperORM.BaseSP<Reset_Discount_User.Inputs, Reset_Discount_User.Outputs> _Reset_Discount_User;
        private readonly DP.DapperORM.BaseSP<Delete_Discount_UserByCompany.Inputs, Delete_Discount_UserByCompany.Outputs> _Delete_Discount_UserByCompany;
        private readonly DP.DapperORM.BaseSP<Insert_Discount_UserByCompany.Inputs, Insert_Discount_UserByCompany.Outputs> _Insert_Discount_UserByCompany;
        private readonly DP.DapperORM.BaseSP<GetDiscountUserByCompany.Inputs, GetDiscountUserByCompany.Outputs> _GetDiscountUserByCompany;
        private readonly DP.DapperORM.BaseSP<Delete_Discount_UserByAdmin.Inputs, Delete_Discount_UserByAdmin.Outputs> _Delete_Discount_UserByAdmin;
        private readonly DP.DapperORM.BaseSP<Delete_Discount_OrderType.Inputs, Delete_Discount_OrderType.Outputs> _Delete_Discount_OrderType;
        private readonly DP.DapperORM.BaseSP<Insert_Discount_OrderType.Inputs, Insert_Discount_OrderType.Outputs> _Insert_Discount_OrderType;
        private readonly DP.DapperORM.BaseSP<Update_Discount_OrderType.Inputs, Update_Discount_OrderType.Outputs> _Update_Discount_OrderType;
        private readonly DP.DapperORM.BaseSP<GetDiscount_OrderTypeByAdmin.Inputs, GetDiscount_OrderTypeByAdmin.Outputs> _GetDiscount_OrderTypeByAdmin;
        #endregion SP_Discount

        public DiscountContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetDiscountCode = new DP.DapperORM.BaseSP<GetDiscountCode.Inputs, GetDiscountCode.Outputs>("User.GetDiscountCode", executer);
            _GetDiscountForAlarmByCompany = new DP.DapperORM.BaseSP<GetDiscountForAlarmByCompany.Inputs, GetDiscountForAlarmByCompany.Outputs>("User.GetDiscountForAlarmByCompany", executer);
            _GetDiscountByCompany = new DP.DapperORM.BaseSP<GetDiscountByCompany.Inputs, GetDiscountByCompany.Outputs>("User.GetDiscountByCompany", executer);
            _Delete_Discount = new DP.DapperORM.BaseSP<Delete_Discount.Inputs, Delete_Discount.Outputs>("User.Delete_Discount", executer);
            _Insert_Discount = new DP.DapperORM.BaseSP<Insert_Discount.Inputs, Insert_Discount.Outputs>("User.Insert_Discount", executer);
            _Insert_DiscountByCompany = new DP.DapperORM.BaseSP<Insert_DiscountByCompany.Inputs, Insert_DiscountByCompany.Outputs>("User.Insert_DiscountByCompany", executer);
            _Update_DiscountByCompany = new DP.DapperORM.BaseSP<Update_DiscountByCompany.Inputs, Update_DiscountByCompany.Outputs>("User.Update_DiscountByCompany", executer);
            _Insert_Discount_User = new DP.DapperORM.BaseSP<Insert_Discount_User.Inputs, Insert_Discount_User.Outputs>("User.Insert_Discount_User", executer);
            _Update_Discount = new DP.DapperORM.BaseSP<Update_Discount.Inputs, Update_Discount.Outputs>("User.Update_Discount", executer);
            _Delete_Discount_User = new DP.DapperORM.BaseSP<Delete_Discount_User.Inputs, Delete_Discount_User.Outputs>("User.Delete_Discount_User", executer);
            _Delete_DiscountByCompany = new DP.DapperORM.BaseSP<Delete_DiscountByCompany.Inputs, Delete_DiscountByCompany.Outputs>("User.Delete_DiscountByCompany", executer);
            _GetDiscountUser = new DP.DapperORM.BaseSP<GetDiscountUser.Inputs, GetDiscountUser.Outputs>("User.GetDiscountUser", executer);
            _Reset_Discount_User = new DP.DapperORM.BaseSP<Reset_Discount_User.Inputs, Reset_Discount_User.Outputs>("User.Reset_Discount_User", executer);
            _Delete_Discount_UserByCompany = new DP.DapperORM.BaseSP<Delete_Discount_UserByCompany.Inputs, Delete_Discount_UserByCompany.Outputs>("User.Delete_Discount_UserByCompany", executer);
            _Insert_Discount_UserByCompany = new DP.DapperORM.BaseSP<Insert_Discount_UserByCompany.Inputs, Insert_Discount_UserByCompany.Outputs>("User.Insert_Discount_UserByCompany", executer);
            _GetDiscountUserByCompany = new DP.DapperORM.BaseSP<GetDiscountUserByCompany.Inputs, GetDiscountUserByCompany.Outputs>("User.GetDiscountUserByCompany", executer);
            _Delete_Discount_UserByAdmin = new DP.DapperORM.BaseSP<Delete_Discount_UserByAdmin.Inputs, Delete_Discount_UserByAdmin.Outputs>("User.Delete_Discount_UserByAdmin", executer);
            _Delete_Discount_OrderType = new DP.DapperORM.BaseSP<Delete_Discount_OrderType.Inputs, Delete_Discount_OrderType.Outputs>("User.Delete_Discount_OrderType", executer);
            _Insert_Discount_OrderType = new DP.DapperORM.BaseSP<Insert_Discount_OrderType.Inputs, Insert_Discount_OrderType.Outputs>("User.Insert_Discount_OrderType", executer);
            _Update_Discount_OrderType = new DP.DapperORM.BaseSP<Update_Discount_OrderType.Inputs, Update_Discount_OrderType.Outputs>("User.Update_Discount_OrderType", executer);
            _GetDiscount_OrderTypeByAdmin = new DP.DapperORM.BaseSP<GetDiscount_OrderTypeByAdmin.Inputs, GetDiscount_OrderTypeByAdmin.Outputs>("User.GetDiscount_OrderTypeByAdmin", executer);
        }

        public async Task<DBResult<IEnumerable<GetDiscountCode.Outputs>>> GetDiscountCode(GetDiscountCode.Inputs inputs, CancellationToken cancellationToken) { return await _GetDiscountCode.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<GetDiscountForAlarmByCompany.Outputs>> GetDiscountForAlarmByCompany(GetDiscountForAlarmByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _GetDiscountForAlarmByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetDiscountByCompany.Outputs>>> GetDiscountByCompany(GetDiscountByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _GetDiscountByCompany.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Discount.Outputs>> Insert_Discount(Insert_Discount.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Discount.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_DiscountByCompany.Outputs>> Insert_DiscountByCompany(Insert_DiscountByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_DiscountByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_DiscountByCompany.Outputs>> Update_DiscountByCompany(Update_DiscountByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Update_DiscountByCompany.Single(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Discount_User(Insert_Discount_User.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Discount_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Update_Discount.Outputs>> Update_Discount(Update_Discount.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Discount.Single(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Discount(Delete_Discount.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Discount.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Discount_User(Delete_Discount_User.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Discount_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_DiscountByCompany(Delete_DiscountByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_DiscountByCompany.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetDiscountUser.Outputs>>> GetDiscountUser(GetDiscountUser.Inputs inputs, CancellationToken cancellationToken) {  return await _GetDiscountUser.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Reset_Discount_User(Reset_Discount_User.Inputs inputs, CancellationToken cancellationToken) { return await _Reset_Discount_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Discount_UserByCompany(Delete_Discount_UserByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Discount_UserByCompany.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetDiscountUserByCompany.Outputs>>> GetDiscountUserByCompany(GetDiscountUserByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _GetDiscountUserByCompany.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Discount_UserByCompany(Insert_Discount_UserByCompany.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Discount_UserByCompany.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Discount_UserByAdmin(Delete_Discount_UserByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Discount_UserByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Discount_OrderType(Insert_Discount_OrderType.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Discount_OrderType.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Discount_OrderType(Update_Discount_OrderType.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Discount_OrderType.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Discount_OrderType(Delete_Discount_OrderType.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Discount_OrderType.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetDiscount_OrderTypeByAdmin.Outputs>>> GetDiscount_OrderTypeByAdmin(GetDiscount_OrderTypeByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetDiscount_OrderTypeByAdmin.Query(inputs, cancellationToken); }
    }
}
