﻿using Microsoft.Extensions.Configuration;
using Farakonesh.DP.DapperORM;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.User.Gift;

namespace Farakonesh.Logic.Database.User
{
    public class GiftContext: IGiftContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties


        #region SP_User
        private readonly BaseSP<GetGift.Inputs, GetGift.Outputs> _GetGift;
        private readonly BaseSP<Insert_Gift.Inputs, Insert_Gift.Outputs> _Insert_Gift;
        private readonly BaseSP<Update_Gift.Inputs, Update_Gift.Outputs> _Update_Gift;
        private readonly BaseSP<Delete_Gift.Inputs, Delete_Gift.Outputs> _Delete_Gift;
        private readonly BaseSP<Delete_GiftUser.Inputs, Delete_GiftUser.Outputs> _Delete_GiftUser;
        private readonly BaseSP<Insert_GiftUser.Inputs, Insert_GiftUser.Outputs> _Insert_GiftUser;
        private readonly BaseSP<GetGiftUser.Inputs, GetGiftUser.Outputs> _GetGiftUser;
        private readonly BaseSP<GetGiftByCustomer.Inputs, GetGiftByCustomer.Outputs> _GetGiftByCustomer;
        #endregion SP_User

        public GiftContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetGift = new DP.DapperORM.BaseSP<GetGift.Inputs, GetGift.Outputs>("User.GetGift", executer);
            _Insert_Gift = new DP.DapperORM.BaseSP<Insert_Gift.Inputs, Insert_Gift.Outputs>("User.Insert_Gift", executer);
            _Update_Gift = new DP.DapperORM.BaseSP<Update_Gift.Inputs, Update_Gift.Outputs>("User.Update_Gift", executer);
            _Delete_Gift = new DP.DapperORM.BaseSP<Delete_Gift.Inputs, Delete_Gift.Outputs>("User.Delete_Gift", executer);
            _Delete_GiftUser = new DP.DapperORM.BaseSP<Delete_GiftUser.Inputs, Delete_GiftUser.Outputs>("User.Delete_GiftUser", executer);
            _Insert_GiftUser = new DP.DapperORM.BaseSP<Insert_GiftUser.Inputs, Insert_GiftUser.Outputs>("User.Insert_GiftUser", executer);
            _GetGiftUser = new DP.DapperORM.BaseSP<GetGiftUser.Inputs, GetGiftUser.Outputs>("User.GetGiftUser", executer);
            _GetGiftByCustomer = new DP.DapperORM.BaseSP<GetGiftByCustomer.Inputs, GetGiftByCustomer.Outputs>("User.GetGiftByCustomer", executer);
        }

        public async Task<DBResult<IEnumerable<GetGift.Outputs>>> GetGift(GetGift.Inputs inputs, CancellationToken cancellationToken) { return await _GetGift.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Gift(Insert_Gift.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Gift.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Gift(Update_Gift.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Gift.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Gift(Delete_Gift.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Gift.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_GiftUser(Delete_GiftUser.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_GiftUser.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_GiftUser(Insert_GiftUser.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_GiftUser.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetGiftUser.Outputs>>> GetGiftUser(GetGiftUser.Inputs inputs, CancellationToken cancellationToken) { return await _GetGiftUser.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetGiftByCustomer.Outputs>>> GetGiftByCustomer(GetGiftByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _GetGiftByCustomer.Query(inputs, cancellationToken); }
    }
}
