﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using Farakonesh.Models.Database.StoredProcedures.App.User.Level;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.User
{
    public class InboxContext: IInboxContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties


        #region SP_Inbox
        private readonly DP.DapperORM.BaseSP<Update_Seen_Inbox.Inputs, Update_Seen_Inbox.Outputs> _Update_Seen_Inbox;
        private readonly DP.DapperORM.BaseSP<GetInbox.Inputs, GetInbox.Outputs> _GetInbox;
        private readonly DP.DapperORM.BaseSP<GetInboxByAdmin.Inputs, GetInboxByAdmin.Outputs> _GetInboxByAdmin;
        private readonly DP.DapperORM.BaseSP<GetInboxById.Inputs, GetInboxById.Outputs> _GetInboxById;
        private readonly DP.DapperORM.BaseSP<GetInboxContent.Inputs, GetInboxContent.Outputs> _GetInboxContent;
        private readonly DP.DapperORM.BaseSP<Insert_Inbox.Inputs, Insert_Inbox.Outputs> _Insert_Inbox;
        private readonly DP.DapperORM.BaseSP<Insert_InboxContent.Inputs, Insert_InboxContent.Outputs> _Insert_InboxContent;
        private readonly DP.DapperORM.BaseSP<Delete_Inbox.Inputs, Delete_Inbox.Outputs> _Delete_Inbox;
        #endregion SP_Inbox

        public InboxContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetInbox = new DP.DapperORM.BaseSP<GetInbox.Inputs, GetInbox.Outputs>("User.GetInbox", executer);
            _GetInboxByAdmin = new DP.DapperORM.BaseSP<GetInboxByAdmin.Inputs, GetInboxByAdmin.Outputs>("User.GetInboxByAdmin", executer);
            _GetInboxById = new DP.DapperORM.BaseSP<GetInboxById.Inputs, GetInboxById.Outputs>("User.GetInboxById", executer);
            _GetInboxContent = new DP.DapperORM.BaseSP<GetInboxContent.Inputs, GetInboxContent.Outputs>("User.GetInboxContent", executer);
            _Insert_Inbox = new DP.DapperORM.BaseSP<Insert_Inbox.Inputs, Insert_Inbox.Outputs>("User.Insert_Inbox", executer);
            _Insert_InboxContent = new DP.DapperORM.BaseSP<Insert_InboxContent.Inputs, Insert_InboxContent.Outputs>("User.Insert_InboxContent", executer);
            _Delete_Inbox = new DP.DapperORM.BaseSP<Delete_Inbox.Inputs, Delete_Inbox.Outputs>("User.Delete_Inbox", executer);
            _Update_Seen_Inbox = new DP.DapperORM.BaseSP<Update_Seen_Inbox.Inputs, Update_Seen_Inbox.Outputs>("User.Update_Seen_Inbox", executer);

        }

        public async Task<DBResult<IEnumerable<GetInbox.Outputs>>> GetInbox(GetInbox.Inputs inputs, CancellationToken cancellationToken) { return await _GetInbox.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetInboxByAdmin.Outputs>>> GetInboxByAdmin(GetInboxByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetInboxByAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<GetInboxById.Outputs>> GetInboxById(GetInboxById.Inputs inputs, CancellationToken cancellationToken) { return await _GetInboxById.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetInboxContent.Outputs>>> GetInboxContent(GetInboxContent.Inputs inputs, CancellationToken cancellationToken) { return await _GetInboxContent.Query(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Inbox.Outputs>> Insert_Inbox(Insert_Inbox.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Inbox.Single(inputs, cancellationToken); }
        public async Task<DBResult> Insert_InboxContent(Insert_InboxContent.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_InboxContent.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Inbox(Delete_Inbox.Inputs inputs, CancellationToken cancellationToken) {return await _Delete_Inbox.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Seen_Inbox(Update_Seen_Inbox.Inputs inputs,CancellationToken cancellationToken) { return await _Update_Seen_Inbox.Execute(inputs, cancellationToken); }

    }
}
